/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.brakeman;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.PluginDescriptor;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.brakeman.BrakemanDescriptor;
import hudson.plugins.brakeman.BrakemanResult;
import hudson.plugins.brakeman.BrakemanResultAction;
import hudson.plugins.brakeman.ScanResult;
import hudson.plugins.brakeman.scanners.AbstractBrakemanScanner;
import hudson.plugins.brakeman.scanners.BrakemanJSONScanner;
import hudson.plugins.brakeman.scanners.BrakemanTabsScanner;
import java.io.IOException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public class BrakemanPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = -5936973521277401765L;
    @Extension
    public static final BrakemanDescriptor BRAKEMAN_DESCRIPTOR = new BrakemanDescriptor();
    public String outputFile;

    @DataBoundConstructor
    public BrakemanPublisher(String outputFile) {
        super("BRAKEMAN");
        this.setDefaultEncoding("UTF-8");
        this.outputFile = outputFile;
    }

    @Deprecated
    public BrakemanPublisher(String healthy, String unHealthy, String thresholdLimit, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean shouldDetectModules, boolean canComputeNew, String outputFile) {
        super(healthy, unHealthy, thresholdLimit, "UTF-8", useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, shouldDetectModules, canComputeNew, "BRAKEMAN");
        this.outputFile = outputFile;
    }

    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    public BuildResult perform(Run<?, ?> build, FilePath workspace, PluginLogger logger) throws InterruptedException, IOException {
        return this.publishReport(build, workspace, logger);
    }

    public BuildResult publishReport(Run<?, ?> build, FilePath workspace, PluginLogger logger) throws InterruptedException, IOException {
        FilePath brakemanOutput = new FilePath(workspace, this.outputFile);
        String output = brakemanOutput.readToString();
        ParserResult project = new ParserResult(workspace);
        AbstractBrakemanScanner scanner = this.createScanner(output);
        boolean successfulScan = scanner.scan(output, project, logger);
        BrakemanResult result = new BrakemanResult(build, this.getDefaultEncoding(), project, this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference(), new ScanResult(successfulScan, brakemanOutput.getName()));
        build.addAction((Action)new BrakemanResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    protected AbstractBrakemanScanner createScanner(String outputContent) {
        FileType scannerType = this.getFileType(outputContent);
        AbstractBrakemanScanner scanner = scannerType == FileType.JSON ? new BrakemanJSONScanner() : new BrakemanTabsScanner();
        return scanner;
    }

    protected FileType getFileType(String content) {
        FileType result = FileType.TABS;
        try {
            JSONObject.fromObject((Object)content);
            result = FileType.JSON;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return result;
    }

    public PluginDescriptor getDescriptor() {
        return BRAKEMAN_DESCRIPTOR;
    }

    protected boolean canContinue(Result result) {
        return super.canContinue(result);
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return null;
    }

    public static enum FileType {
        JSON,
        TABS;

    }
}

