/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.api;

import org.scribe.builder.api.DefaultApi20;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.JsonTokenExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuth20ServiceImpl;
import org.scribe.oauth.OAuthService;

public class BitbucketApiV2
extends DefaultApi20 {
    private static final String OAUTH_ENDPOINT = "https://bitbucket.org/site/oauth2/";

    public String getAccessTokenEndpoint() {
        return "https://bitbucket.org/site/oauth2/access_token";
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        return "https://bitbucket.org/site/oauth2/authorize?client_id=" + config.getApiKey() + "&response_type=code";
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public OAuthService createService(OAuthConfig config) {
        return new BitbucketOAuth20Service(this, config);
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new JsonTokenExtractor();
    }

    private static class BitbucketOAuth20Service
    extends OAuth20ServiceImpl {
        private static final String GRANT_TYPE = "grant_type";
        private DefaultApi20 api;
        private OAuthConfig config;

        public BitbucketOAuth20Service(DefaultApi20 api, OAuthConfig config) {
            super(api, config);
            this.api = api;
            this.config = config;
        }

        public Token getAccessToken(Token requestToken, Verifier verifier) {
            OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
            request.addBodyParameter("client_id", this.config.getApiKey());
            request.addBodyParameter("client_secret", this.config.getApiSecret());
            request.addBodyParameter("code", verifier.getValue());
            request.addBodyParameter(GRANT_TYPE, "authorization_code");
            Response response = request.send();
            return this.api.getAccessTokenExtractor().extract(response.getBody());
        }
    }
}

