/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.jenkinsci.plugins.api.BitbucketApiService;
import org.jenkinsci.plugins.api.BitbucketUser;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.scribe.model.Token;

public class BitbucketAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -7826610577724673531L;
    private Token accessToken;
    private BitbucketUser bitbucketUser;

    public BitbucketAuthenticationToken(Token accessToken, String apiKey, String apiSecret) {
        this.accessToken = accessToken;
        this.bitbucketUser = new BitbucketApiService(apiKey, apiSecret).getUserByToken(accessToken);
        boolean authenticated = false;
        if (this.bitbucketUser != null) {
            authenticated = true;
        }
        this.setAuthenticated(authenticated);
    }

    public GrantedAuthority[] getAuthorities() {
        return this.bitbucketUser != null ? this.bitbucketUser.getAuthorities() : new GrantedAuthority[]{};
    }

    public Token getAccessToken() {
        return this.accessToken;
    }

    public Object getCredentials() {
        return "";
    }

    public Object getPrincipal() {
        return this.getName();
    }

    public String getName() {
        return this.bitbucketUser != null ? this.bitbucketUser.getUsername() : null;
    }

    @Restricted(value={NoExternalUse.class})
    public BitbucketUser getBitbucketUser() {
        return this.bitbucketUser;
    }
}

