/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.utilities;

import hudson.model.Run;
import java.io.File;
import java.util.logging.Logger;
import org.jenkinsci.plugins.benchmark.parsers.JUnitJenkins;
import org.jenkinsci.plugins.benchmark.utilities.RunnableReader;

public class RunnableJenkinsReader
implements Runnable {
    private final Run startRun;
    private final Run endRun;
    private final JUnitJenkins mapper;
    private static final Logger log = Logger.getLogger(RunnableReader.class.getName());

    public RunnableJenkinsReader(Run startRun, Run endRun, JUnitJenkins mapper) {
        this.startRun = startRun;
        this.endRun = endRun;
        this.mapper = mapper;
    }

    @Override
    public void run() {
        Run run;
        try {
            for (run = this.startRun; run != null && run != this.endRun; run = run.getPreviousBuild()) {
                StringBuffer rawFilename = new StringBuffer();
                rawFilename.append(run.getRootDir().getAbsolutePath());
                rawFilename.append(File.separator);
                rawFilename.append("junitResult.xml");
                this.mapper.importFromFile((Integer)run.getNumber(), rawFilename.toString());
            }
        }
        catch (Exception e) {
            log.warning("Warning:" + Thread.currentThread().getName() + "- Build:" + run.getNumber() + " - " + e.getCause());
        }
    }
}

