/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.thresholds;

import hudson.AbortException;
import hudson.ExtensionList;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Run;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.thresholds.Messages;
import org.jenkinsci.plugins.benchmark.thresholds.ThresholdDescriptor;

public abstract class Threshold
extends AbstractDescribableImpl<Threshold> {
    private final ThresholdTypes type;
    private final String testGroup;
    private final String testName;

    protected Threshold(String testGroup, String testName, ThresholdTypes type) {
        this.type = type;
        this.testGroup = testGroup;
        this.testName = testName;
    }

    protected Threshold(ThresholdTypes type) {
        this.type = type;
        this.testGroup = "";
        this.testName = "";
    }

    public static ExtensionList<Threshold> all() {
        return Jenkins.get().getExtensionList(Threshold.class);
    }

    public ThresholdDescriptor getDescriptor() {
        return (ThresholdDescriptor)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public boolean isValid(int value) throws NullPointerException, ValidationException {
        return true;
    }

    public boolean isValid(double value) throws NullPointerException, ValidationException {
        return true;
    }

    public abstract boolean evaluate(List<? extends Run<?, ?>> var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, AbortException, ParseException;

    public void setAverageValue(Double average) {
    }

    public void setPreviousValue(Double average) {
    }

    public String getName() {
        switch (this.type) {
            case tt_absolute: {
                return Messages.Threshold_AbsoluteThreshold();
            }
            case tt_percentage: {
                return Messages.Threshold_PercentageFromLastThreshold();
            }
            case tt_percentageAverage: {
                return Messages.Threshold_PercentageFromAverageThreshold();
            }
            case tt_delta: {
                return Messages.Threshold_DeltaFromLastThreshold();
            }
            case tt_deltaAverage: {
                return Messages.Threshold_DeltaFromAverageThreshold();
            }
        }
        return Messages.Threshold_UnknownThreshold();
    }

    public ThresholdTypes getType() {
        return this.type;
    }

    public String getTestGroup() {
        return this.testGroup;
    }

    public String getTestName() {
        return this.testName;
    }

    public static enum ThresholdTypes {
        tt_unknown,
        tt_absolute,
        tt_percentage,
        tt_percentageAverage,
        tt_delta,
        tt_deltaAverage;

    }
}

