/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.thresholds;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.List;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.thresholds.Messages;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;
import org.jenkinsci.plugins.benchmark.thresholds.ThresholdDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PercentageThreshold
extends Threshold {
    private final Double percentage;
    private Double previous;

    @DataBoundConstructor
    public PercentageThreshold(String testGroup, String testName, Double percentage) {
        super(testGroup, testName, Threshold.ThresholdTypes.tt_percentage);
        this.percentage = percentage;
        this.previous = null;
    }

    public PercentageThreshold(Double percentage) throws ValidationException {
        super(Threshold.ThresholdTypes.tt_percentage);
        if (percentage == null) {
            throw new ValidationException(Messages.PercentageThreshold_MissingPercentage());
        }
        this.percentage = percentage;
        this.previous = null;
    }

    @Override
    public boolean evaluate(List<? extends Run<?, ?>> builds) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, AbortException, ParseException {
        return true;
    }

    @Override
    public boolean isValid(int value) throws NullPointerException, ValidationException {
        if (this.previous == null) {
            return true;
        }
        double calculatedPercentage = Math.abs(((double)value - this.previous) / this.previous) * 100.0;
        if (this.percentage != null && calculatedPercentage > this.percentage) {
            throw new ValidationException(Messages.PercentageThreshold_OutOfPercentageFromPrevious(Integer.toString(value), Double.toString(this.percentage), Double.toString(this.previous)));
        }
        return true;
    }

    @Override
    public boolean isValid(double value) throws NullPointerException, ValidationException {
        if (this.previous == null) {
            return true;
        }
        double calculatedPercentage = Math.abs((value - this.previous) / this.previous) * 100.0;
        if (this.percentage != null && calculatedPercentage > this.percentage) {
            throw new ValidationException(Messages.PercentageThreshold_OutOfPercentageFromPrevious(Double.toString(value), Double.toString(this.percentage), Double.toString(this.previous)));
        }
        return true;
    }

    @Override
    public void setPreviousValue(Double previousValue) {
        this.previous = previousValue;
    }

    public Double getPercentage() {
        return this.percentage;
    }

    public Double getPrevious() {
        return this.previous;
    }

    @Extension
    public static class DescriptorImpl
    extends ThresholdDescriptor {
        public String getDisplayName() {
            return Messages.PercentageThreshold_PercentageFromLastBuild();
        }

        public FormValidation doCheckPercentage(@QueryParameter Double percentage) {
            if (percentage == null) {
                return FormValidation.error((String)Messages.PercentageThreshold_PercentageCannotBeEmpty());
            }
            if (100.0 < percentage || percentage < 0.0) {
                return FormValidation.error((String)Messages.PercentageThreshold_PercentageBetween0And100());
            }
            return FormValidation.ok();
        }
    }
}

