/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.thresholds;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.List;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.thresholds.Messages;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;
import org.jenkinsci.plugins.benchmark.thresholds.ThresholdDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class DeltaAverageThreshold
extends Threshold {
    private final Double delta;
    private Double average;

    @DataBoundConstructor
    public DeltaAverageThreshold(String testGroup, String testName, Double delta) {
        super(testGroup, testName, Threshold.ThresholdTypes.tt_deltaAverage);
        this.delta = delta;
        this.average = null;
    }

    public DeltaAverageThreshold(Double delta) throws ValidationException {
        super(Threshold.ThresholdTypes.tt_deltaAverage);
        if (delta == null) {
            throw new ValidationException(Messages.DeltaAverageThreshold_MissingDelta());
        }
        this.delta = delta;
        this.average = null;
    }

    @Override
    public boolean evaluate(List<? extends Run<?, ?>> builds) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, AbortException, ParseException {
        return true;
    }

    @Override
    public boolean isValid(int value) throws NullPointerException, ValidationException {
        if (this.average == null) {
            return true;
        }
        double calculatedDelta = Math.sqrt(((double)value - this.average) * ((double)value - this.average));
        if (this.delta != null && calculatedDelta > this.delta) {
            throw new ValidationException(Messages.DeltaAverageThreshold_OutOfDeltaFromAverage(Integer.toString(value), Double.toString(this.delta), Double.toString(this.average)));
        }
        return true;
    }

    @Override
    public boolean isValid(double value) throws NullPointerException, ValidationException {
        if (this.average == null) {
            return true;
        }
        double calculatedDelta = Math.sqrt((value - this.average) * (value - this.average));
        if (this.delta != null && calculatedDelta > this.delta) {
            throw new ValidationException(Messages.DeltaAverageThreshold_OutOfDeltaFromAverage(Double.toString(value), Double.toString(this.delta), Double.toString(this.average)));
        }
        return true;
    }

    @Override
    public void setAverageValue(Double average) {
        this.average = average;
    }

    public Double getDelta() {
        return this.delta;
    }

    public Double getAverageValue() {
        return this.average;
    }

    @Extension
    public static class DescriptorImpl
    extends ThresholdDescriptor {
        public String getDisplayName() {
            return Messages.DeltaAverageThreshold_DeltaFromAverage();
        }

        public FormValidation doCheckDelta(@QueryParameter Double delta) {
            if (delta == null) {
                return FormValidation.error((String)Messages.DeltaAverageThreshold_DeltaCannotBeEmpty());
            }
            if (delta < 0.0) {
                return FormValidation.error((String)Messages.DeltaAverageThreshold_DeltaAboveOrEqualTo0());
            }
            return FormValidation.ok();
        }
    }
}

