/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.thresholds;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.List;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.thresholds.Messages;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;
import org.jenkinsci.plugins.benchmark.thresholds.ThresholdDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AbsoluteThreshold
extends Threshold {
    private final Double minimum;
    private final Double maximum;

    @DataBoundConstructor
    public AbsoluteThreshold(String testGroup, String testName, Double minimum, Double maximum) {
        super(testGroup, testName, Threshold.ThresholdTypes.tt_absolute);
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public AbsoluteThreshold(Double minimum, Double maximum) throws ValidationException {
        super(Threshold.ThresholdTypes.tt_absolute);
        if (minimum == null && maximum == null) {
            throw new ValidationException(Messages.AbsoluteThreshold_MissingMinAndMax());
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public boolean evaluate(List<? extends Run<?, ?>> builds) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, AbortException, ParseException {
        return true;
    }

    @Override
    public boolean isValid(int value) throws NullPointerException, ValidationException {
        if (this.minimum != null && (double)value < this.minimum) {
            throw new ValidationException(Messages.AbsoluteThreshold_IsBelowMinimum(Integer.toString(value), Double.toString(this.minimum)));
        }
        if (this.maximum != null && this.maximum < (double)value) {
            throw new ValidationException(Messages.AbsoluteThreshold_IsAboveMaximum(Integer.toString(value), Double.toString(this.maximum)));
        }
        return true;
    }

    @Override
    public boolean isValid(double value) throws NullPointerException, ValidationException {
        if (this.minimum != null && value < this.minimum) {
            throw new ValidationException(Messages.AbsoluteThreshold_IsBelowMinimum(Double.toString(value), Double.toString(this.minimum)));
        }
        if (this.maximum != null && this.maximum < value) {
            throw new ValidationException(Messages.AbsoluteThreshold_IsAboveMaximum(Double.toString(value), Double.toString(this.maximum)));
        }
        return true;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    @Extension
    public static class DescriptorImpl
    extends ThresholdDescriptor {
        public String getDisplayName() {
            return Messages.AbsoluteThreshold_AbsoluteValues();
        }

        public FormValidation doCheckMaximum(@QueryParameter Double minimum, @QueryParameter Double maximum) {
            if (minimum != null && maximum != null && minimum > maximum) {
                return FormValidation.error((String)Messages.AbsoluteThreshold_MaxIsBelowMin());
            }
            return FormValidation.ok();
        }
    }
}

