/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.results;

import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.results.Messages;

public class TestFailure {
    private final FailureType type;
    private final Boolean boolValue;
    private final Double dblValue;
    private final String strValue;
    private final CompareType compType;

    public TestFailure(boolean value) {
        this.type = FailureType.ftBoolean;
        this.boolValue = value;
        this.dblValue = null;
        this.strValue = null;
        this.compType = CompareType.ct_equal;
    }

    public TestFailure(double value) {
        this.type = FailureType.ftInteger;
        this.boolValue = null;
        this.dblValue = value;
        this.strValue = null;
        this.compType = CompareType.ct_equal;
    }

    public TestFailure(double value, String compareType) throws ValidationException {
        this.type = FailureType.ftInteger;
        this.boolValue = null;
        this.dblValue = value;
        this.strValue = null;
        if (compareType == null) {
            this.compType = CompareType.ct_equal;
        } else if ((compareType = compareType.toLowerCase()).equals("above")) {
            this.compType = CompareType.ct_above;
        } else if (compareType.equals("below")) {
            this.compType = CompareType.ct_below;
        } else if (compareType.equals("aboveorequal")) {
            this.compType = CompareType.ct_aboveOrEqual;
        } else if (compareType.equals("beloworequal")) {
            this.compType = CompareType.ct_belowOrEqual;
        } else {
            throw new ValidationException(Messages.TestFailure_CompareTypeUnknown());
        }
    }

    public TestFailure(String value) {
        this.type = FailureType.ftValueString;
        this.boolValue = null;
        this.dblValue = null;
        this.strValue = value;
        this.compType = CompareType.ct_equal;
    }

    public TestFailure(String value, boolean key) {
        this.type = key ? FailureType.ftKeyString : FailureType.ftValueString;
        this.boolValue = null;
        this.dblValue = null;
        this.strValue = value;
        this.compType = CompareType.ct_equal;
    }

    public boolean isFailure(boolean content) {
        return this.boolValue != null && content == this.boolValue;
    }

    public boolean isFailure(double content) {
        if (this.dblValue != null) {
            switch (this.compType) {
                case ct_equal: {
                    if (content != this.dblValue) break;
                    return true;
                }
                case ct_aboveOrEqual: {
                    if (!(content >= this.dblValue)) break;
                    return true;
                }
                case ct_belowOrEqual: {
                    if (!(content <= this.dblValue)) break;
                    return true;
                }
                case ct_above: {
                    if (!(content > this.dblValue)) break;
                    return true;
                }
                case ct_below: {
                    if (!(content < this.dblValue)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFailure(int content) {
        if (this.dblValue != null) {
            switch (this.compType) {
                case ct_equal: {
                    if ((double)content != this.dblValue) break;
                    return true;
                }
                case ct_aboveOrEqual: {
                    if (!((double)content >= this.dblValue)) break;
                    return true;
                }
                case ct_belowOrEqual: {
                    if (!((double)content <= this.dblValue)) break;
                    return true;
                }
                case ct_above: {
                    if (!((double)content > this.dblValue)) break;
                    return true;
                }
                case ct_below: {
                    if (!((double)content < this.dblValue)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFailure(String content) {
        return this.strValue != null && content.equals(this.strValue);
    }

    public boolean isFailure(String content, boolean key) {
        return this.strValue != null && this.isKeyFailure() && content.equals(this.strValue);
    }

    public boolean isKeyFailure() {
        return this.type == FailureType.ftKeyString;
    }

    public static enum CompareType {
        ct_below,
        ct_belowOrEqual,
        ct_equal,
        ct_aboveOrEqual,
        ct_above;

    }

    public static enum FailureType {
        ftBoolean,
        ftInteger,
        ftValueString,
        ftKeyString;

    }
}

