/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.results;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InvalidClassException;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.results.NumeralValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestProperty;
import org.jenkinsci.plugins.benchmark.results.TestValue;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;

public class DoubleValue
extends NumeralValue {
    protected final ConcurrentHashMap<Integer, Double> values = new ConcurrentHashMap();

    public DoubleValue(TestGroup parent, String group, String name) {
        super(parent, group, name, null, null, TestValue.ValueType.rt_double);
    }

    public DoubleValue(TestGroup parent, String group, String name, String unit) {
        super(parent, group, name, null, unit, TestValue.ValueType.rt_double);
    }

    public DoubleValue(TestGroup parent, String group, String name, String description, String unit) {
        super(parent, group, name, description, unit, TestValue.ValueType.rt_double);
    }

    public DoubleValue(TestGroup parent, String group, String name, TestGroup.ClassType ctype) {
        super(parent, group, name, null, null, TestValue.ValueType.rt_double, ctype);
    }

    public DoubleValue(TestGroup parent, String group, String name, String unit, TestGroup.ClassType ctype) {
        super(parent, group, name, null, unit, TestValue.ValueType.rt_double, ctype);
    }

    public DoubleValue(TestGroup parent, String group, String name, String description, String unit, TestGroup.ClassType ctype) {
        super(parent, group, name, description, unit, TestValue.ValueType.rt_double, ctype);
    }

    public Double getPreviousValue(int build) {
        while (build > 0) {
            Double value = this.values.get(build);
            if (value != null) {
                return value;
            }
            --build;
        }
        return null;
    }

    public Double calculateAverage() {
        int number = 0;
        double sum = 0.0;
        for (Map.Entry<Integer, Double> entry : this.values.entrySet()) {
            TestProperty property = (TestProperty)this.properties.get(entry.getKey());
            if (property == null) {
                sum += entry.getValue().doubleValue();
                ++number;
                continue;
            }
            Boolean failedState = property.getFailedState();
            if (failedState != null && failedState.booleanValue()) continue;
            sum += entry.getValue().doubleValue();
            ++number;
        }
        if (number == 0) {
            return null;
        }
        return sum / (double)number;
    }

    @Override
    public JsonObject getCondensedJsonObject(int build, int hash) {
        Integer _fileHash;
        int failed = 0;
        int passed = 0;
        Double minimum = null;
        Double maximum = null;
        Double std_deviation = null;
        Double average = this.calculateAverage();
        if (average != null) {
            int number = 0;
            std_deviation = 0.0;
            for (Map.Entry<Integer, Double> entry : this.values.entrySet()) {
                TestProperty property = (TestProperty)this.properties.get(entry.getKey());
                Boolean failedState = property == null ? null : property.getFailedState();
                if (failedState != null) {
                    if (failedState.booleanValue()) {
                        ++failed;
                    } else {
                        ++passed;
                    }
                }
                if (failedState != null && failedState.booleanValue()) continue;
                Double value = entry.getValue();
                if (number == 0) {
                    minimum = value;
                    maximum = value;
                } else if (value < minimum) {
                    minimum = value;
                } else if (value > maximum) {
                    maximum = value;
                }
                std_deviation = std_deviation + (value - average) * (value - average);
                ++number;
            }
            std_deviation = Math.sqrt(std_deviation / (double)number);
        }
        JsonObject object = new JsonObject();
        object.addProperty("hash", (Number)hash);
        if (this.getFileGroup() != null) {
            object.addProperty("file", (Number)this.getFileGroup().getGroupHash());
        }
        if (this.group != null && !this.group.isEmpty()) {
            object.addProperty("group", this.group);
        }
        object.addProperty("name", this.name);
        if (this.description != null && !this.description.isEmpty()) {
            object.addProperty("description", this.description);
        }
        if (this.unit != null && !this.unit.isEmpty()) {
            object.addProperty("unit", this.unit);
        }
        object.addProperty("type", DoubleValue.outputType(this.type));
        if (this.ctype == TestGroup.ClassType.ct_result && (_fileHash = this.getFileHash()) != null) {
            object.addProperty("file", (Number)_fileHash);
        }
        if (average != null) {
            object.addProperty("previous", (Number)this.getPreviousValue(build));
            object.addProperty("average", (Number)average);
            object.addProperty("std_deviation", (Number)std_deviation);
            object.addProperty("minimum", (Number)minimum);
            object.addProperty("maximum", (Number)maximum);
        }
        object.addProperty("failed", (Number)failed);
        object.addProperty("passed", (Number)passed);
        return object;
    }

    @Override
    public JsonArray getDataAsJsonArray(TreeSet<Integer> buildNumbers) throws InvalidClassException {
        JsonArray array = new JsonArray();
        Integer build = buildNumbers.last();
        while (build >= buildNumbers.first()) {
            JsonObject object = new JsonObject();
            Double value = this.getValue(build);
            if (value == null) {
                object.addProperty("x", (Number)build);
                object.add("y", null);
            } else {
                object.addProperty("x", (Number)build);
                object.addProperty("y", (Number)value);
            }
            array.add((JsonElement)object);
            Integer n = build;
            Integer n2 = build = Integer.valueOf(build - 1);
        }
        return array;
    }

    @Override
    public JsonObject getJsonObject(int hash) {
        JsonObject object = super.getJsonObject(hash);
        object.addProperty("value", (Number)this.getValue());
        return object;
    }

    @Override
    public String getValueAsString(int build) {
        Double value = this.getValue(build);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public String getValueAsLocaleString(int build, char decimalSeparator) {
        Double value = this.getValue(build);
        if (value == null) {
            return "";
        }
        return value.toString().replace('.', decimalSeparator);
    }

    @Override
    public void checkThresholdStatus(Double previous, Double average) {
        List<Threshold> list = this.getAllConnectedThresholds();
        for (Threshold threshold : list) {
            try {
                threshold.setAverageValue(average);
                threshold.setPreviousValue(previous);
                threshold.isValid(this.values.get(0));
                this.setFailedState(false);
            }
            catch (ValidationException e) {
                this.setMessage(threshold.getName(), e.getMessage());
                this.setFailedState(true);
            }
        }
    }

    public void setValue(double value) {
        this.values.put(0, value);
    }

    public void setValue(int build, double value) {
        this.values.put(build, value);
    }

    public Map<Integer, Double> getValues() {
        return this.values;
    }

    public Double getValue() throws NullPointerException {
        return this.values.get(0);
    }

    public Double getValue(int build) throws NullPointerException {
        return this.values.get(build);
    }
}

