/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.results;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestProperty;
import org.jenkinsci.plugins.benchmark.results.TestValue;

public class BooleanValue
extends TestValue {
    private final ConcurrentHashMap<Integer, Boolean> values = new ConcurrentHashMap();

    public BooleanValue(TestGroup parent, String group, String name) {
        super(parent, group, name, null, null, TestValue.ValueType.rt_boolean);
    }

    public BooleanValue(TestGroup parent, String group, String name, String unit) {
        super(parent, group, name, null, unit, TestValue.ValueType.rt_boolean);
    }

    public BooleanValue(TestGroup parent, String group, String name, String description, String unit) {
        super(parent, group, name, description, unit, TestValue.ValueType.rt_boolean);
    }

    public BooleanValue(TestGroup parent, String group, String name, TestGroup.ClassType ctype) {
        super(parent, group, name, null, null, TestValue.ValueType.rt_boolean, ctype);
    }

    public BooleanValue(TestGroup parent, String group, String name, String unit, TestGroup.ClassType ctype) {
        super(parent, group, name, null, unit, TestValue.ValueType.rt_boolean, ctype);
    }

    public BooleanValue(TestGroup parent, String group, String name, String description, String unit, TestGroup.ClassType ctype) {
        super(parent, group, name, description, unit, TestValue.ValueType.rt_boolean, ctype);
    }

    @Override
    public JsonObject getCondensedJsonObject(int build, int hash) {
        Integer _fileHash;
        int failed = 0;
        int passed = 0;
        for (TestProperty property : this.properties.values()) {
            Boolean failedState = property.getFailedState();
            if (failedState == null) continue;
            if (failedState.booleanValue()) {
                ++failed;
                continue;
            }
            ++passed;
        }
        JsonObject object = new JsonObject();
        object.addProperty("hash", (Number)hash);
        if (this.group != null && !this.group.isEmpty()) {
            object.addProperty("group", this.group);
        }
        object.addProperty("name", this.name);
        if (this.description != null && !this.description.isEmpty()) {
            object.addProperty("description", this.description);
        }
        if (this.unit != null && !this.unit.isEmpty()) {
            object.addProperty("unit", this.unit);
        }
        object.addProperty("type", BooleanValue.outputType(this.type));
        if (this.ctype == TestGroup.ClassType.ct_result && (_fileHash = this.getFileHash()) != null) {
            object.addProperty("file", (Number)_fileHash);
        }
        object.addProperty("failed", (Number)failed);
        object.addProperty("passed", (Number)passed);
        return object;
    }

    @Override
    public JsonObject getJsonObject(int hash) {
        JsonObject object = super.getJsonObject(hash);
        object.addProperty("value", this.getValue());
        return object;
    }

    @Override
    public String getValueAsString(int build) {
        Boolean value = this.getValue(build);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public String getValueAsLocaleString(int build, char decimalSeparator) {
        Boolean value = this.getValue(build);
        if (value == null) {
            return "";
        }
        return "__boolean__";
    }

    public void setValue(boolean value) {
        this.values.put(0, value);
    }

    public void setValue(int build, boolean value) {
        this.values.put(build, value);
    }

    public Map<Integer, Boolean> getValues() {
        return this.values;
    }

    public Boolean getValue() {
        return this.values.get(0);
    }

    public Boolean getValue(int build) {
        return this.values.get(build);
    }
}

