/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.MapperBase;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.MapXmlFailures;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.MapXmlGroup;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.MapXmlParameter;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.MapXmlResult;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.MapXmlThreshold;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.Messages;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestValue;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MapXmlToPlugin
extends MapperBase {
    private final Map<String, Element> complexTypes = new HashMap<String, Element>();
    private final Map<String, Element> elements = new HashMap<String, Element>();

    public MapXmlToPlugin(Integer build, File content, Document schema, boolean truncateStrings) throws IOException, ValidationException {
        super(build, truncateStrings);
        Document xContent;
        try {
            xContent = this.getXML(content);
        }
        catch (Exception e) {
            throw new IOException(Messages.MapXmlToPlugin_FileFormatNotRecognisedAsXml(content.getName()));
        }
        this.InitiateLoading(this.rootGroup, xContent, schema);
    }

    public MapXmlToPlugin(Integer build, FilePath content, Document schema, boolean truncateStrings) throws IOException, ValidationException {
        super(build, truncateStrings);
        Document xContent;
        try {
            xContent = this.getXML(content);
        }
        catch (Exception e) {
            throw new IOException(Messages.MapXmlToPlugin_FileFormatNotRecognisedAsXml(content.getName()));
        }
        this.InitiateLoading(this.rootGroup, xContent, schema);
    }

    public MapXmlToPlugin(Integer build, Map<String, FilePath> content, Document schema, boolean truncateStrings, TaskListener listener) throws IOException, ValidationException {
        super(build, truncateStrings);
        listener.getLogger().println(Messages.MapXmlToPlugin_ListOfFilesDetected());
        int files_processed = 0;
        for (Map.Entry<String, FilePath> entry : content.entrySet()) {
            Document xContent;
            String relativePath = this.FilePathToString(entry.getValue());
            try {
                xContent = this.getXML(entry.getValue());
            }
            catch (Exception e) {
                listener.getLogger().println("   - " + Messages.MapXmlToPlugin_PrintFailedToIdentifyFile(relativePath));
                continue;
            }
            try {
                TestGroup group = new TestGroup(this.rootGroup, entry.getKey(), relativePath, TestGroup.ClassType.ct_fileGrp);
                this.files.put(group.getGroupHash(), group);
                this.groups.put(group.getGroupHash(), group);
                this.rootGroup.addGroup(group);
                this.InitiateLoading(group, xContent, schema);
            }
            catch (Exception e) {
                listener.getLogger().println("   - " + Messages.MapXmlToPlugin_PrintFailedToLoadFile(relativePath));
                continue;
            }
            listener.getLogger().println("   - " + relativePath);
            ++files_processed;
        }
        if (files_processed == 0) {
            throw new ValidationException(Messages.MapXmlToPlugin_NoValidFileFound());
        }
    }

    public MapXmlToPlugin(Integer build, FilePath content, String schema, boolean truncateStrings) throws IOException, ValidationException {
        super(build, truncateStrings);
        Document xContent;
        Document xSchema;
        try {
            xSchema = this.getXML(schema);
        }
        catch (Exception e) {
            throw new IOException(Messages.MapXmlToPlugin_SchemaFormatNotRecognisedAsXml());
        }
        try {
            xContent = this.getXML(content);
        }
        catch (Exception e) {
            throw new IOException(Messages.MapXmlToPlugin_FileFormatNotRecognisedAsXml(content.getName()));
        }
        this.InitiateLoading(this.rootGroup, xContent, xSchema);
    }

    public MapXmlToPlugin(Integer build, Map<String, FilePath> content, String schema, boolean truncateStrings) throws IOException, ValidationException {
        super(build, truncateStrings);
        Document xSchema;
        try {
            xSchema = this.getXML(schema);
        }
        catch (Exception e) {
            throw new IOException(Messages.MapXmlToPlugin_SchemaFormatNotRecognisedAsXml());
        }
        for (Map.Entry<String, FilePath> entry : content.entrySet()) {
            Document xContent;
            try {
                xContent = this.getXML(entry.getValue());
            }
            catch (Exception e) {
                throw new IOException(Messages.MapXmlToPlugin_FileFormatNotRecognisedAsXml(entry.getValue().getName()));
            }
            String relativePath = null;
            Object nextChunk = null;
            for (FilePath path = entry.getValue(); path != null && !path.getName().equalsIgnoreCase("workspace"); path = path.getParent()) {
                if (relativePath == null) {
                    if (nextChunk != null) {
                        relativePath = nextChunk;
                    }
                } else {
                    relativePath = nextChunk + "/" + relativePath;
                }
                nextChunk = path.getName();
            }
            TestGroup group = new TestGroup(this.rootGroup, entry.getKey(), relativePath, TestGroup.ClassType.ct_fileGrp);
            this.files.put(group.getGroupHash(), group);
            this.groups.put(group.getGroupHash(), group);
            this.rootGroup.addGroup(group);
            this.InitiateLoading(group, xContent, xSchema);
        }
    }

    private Document getXML(File xmlFile) throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.parse(xmlFile);
    }

    private Document getXML(FilePath xmlFile) throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.parse(xmlFile.read());
    }

    private Document getXML(String xmlContent) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.parse(xmlContent);
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        factory.setExpandEntityReferences(false);
        factory.setXIncludeAware(false);
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }

    private void InitiateLoading(TestGroup group, Document dContent, Document dSchema) throws ValidationException {
        Element eSchema;
        if (dSchema.getDocumentElement().getLocalName().equalsIgnoreCase("schema")) {
            String attrName;
            eSchema = dSchema.getDocumentElement();
            for (Node nSNode = eSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("complextype") || (attrName = ((Element)nSNode).getAttribute("name")) == null || attrName.length() <= 0) continue;
                this.complexTypes.put(attrName, (Element)nSNode);
            }
            for (Node nNode = eSchema.getFirstChild(); nNode != null; nNode = nNode.getNextSibling()) {
                if (nNode.getNodeType() != 1 || !nNode.getLocalName().equalsIgnoreCase("element") || (attrName = ((Element)nNode).getAttribute("name")) == null || attrName.length() <= 0) continue;
                this.elements.put(attrName, (Element)nNode);
            }
        } else {
            throw new ValidationException(Messages.MapXmlToPlugin_SchemaRootElementAndNamespaceAreIncorrect());
        }
        this.ProcessSequence(group, "__first__", dContent, eSchema, null);
    }

    private void ProcessSequence(TestGroup parent, String key, Node nContent, Node nSchema, MapXmlFailures failures) throws ValidationException {
        MapXmlFailures newFailures = new MapXmlFailures(this.rootGroup, nSchema, failures);
        for (Node nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
            String name;
            if (nSNode.getNodeType() != 1 || !(name = nSNode.getLocalName()).equalsIgnoreCase("element")) continue;
            this.ProcessElement(parent, key, nContent, nSNode, newFailures);
        }
    }

    private void ProcessElement(TestGroup parent, String key, Node nContent, Node nSchema, MapXmlFailures failures) throws ValidationException {
        String name = this.getElementAttribute(nSchema, "name");
        if (name == null) {
            return;
        }
        GroupTags type = this.getElementType(nSchema);
        switch (type) {
            case gt_empty: {
                for (Node nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                    if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("complextype")) continue;
                    this.ProcessComplexType(parent, name, nContent, nSNode, failures);
                }
                break;
            }
            case gt_unknown: {
                String value = this.getElementAttribute(nSchema, "type");
                Element nSElement = this.complexTypes.get(value);
                if (nSElement == null) break;
                this.ProcessComplexType(parent, name, nContent, nSElement, failures);
                break;
            }
            case gt_parameter: {
                for (Node nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                    if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("complextype")) continue;
                    this.ProcessParameter(parent, name, nContent, nSNode, failures);
                }
                break;
            }
            case gt_result: {
                for (Node nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                    if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("complextype")) continue;
                    this.ProcessResult(parent, name, nContent, nSNode, failures);
                }
                break;
            }
            case gt_threshold: {
                for (Node nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                    if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("complextype")) continue;
                    this.ProcessThreshold(parent, name, nContent, nSNode, failures);
                }
                break;
            }
        }
    }

    private void ProcessComplexType(TestGroup parent, String key, Node nContent, Node nSchema, MapXmlFailures failures) throws ValidationException {
        GroupTags typeCT = this.getElementType(nSchema);
        switch (typeCT) {
            case gt_parameter: {
                this.ProcessParameter(parent, key, nContent, nSchema, failures);
                break;
            }
            case gt_result: {
                this.ProcessResult(parent, key, nContent, nSchema, failures);
                break;
            }
            case gt_threshold: {
                this.ProcessThreshold(parent, key, nContent, nSchema, failures);
                break;
            }
            default: {
                this.ProcessGroup(parent, key, nContent, nSchema, failures);
            }
        }
    }

    private void ProcessThreshold(TestGroup parent, String key, Node nContent, Node nSchema, MapXmlFailures failures) throws ValidationException {
        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
            MapXmlThreshold content;
            Threshold threshold;
            if (nCNode.getNodeType() != 1 || !nCNode.getNodeName().equals(key) || (threshold = (content = new MapXmlThreshold(parent, key, nCNode, nSchema)).getThreshold()) == null) continue;
            parent.addThreshold(threshold);
            this.checkThresholdType(threshold);
        }
    }

    private void ProcessParameter(TestGroup parent, String key, Node nContent, Node nSchema, MapXmlFailures failures) throws ValidationException {
        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
            MapXmlParameter content;
            TestValue parameter;
            if (nCNode.getNodeType() != 1 || !nCNode.getNodeName().equals(key) || (parameter = (content = new MapXmlParameter(parent, key, nCNode, nSchema, failures, this.truncateStrings)).getParameter()) == null) continue;
            parent.addGroup(parameter);
            this.groups.put(parameter.getGroupHash(), parameter);
            this.parameters.put(parameter.getGroupHash(), parameter);
        }
    }

    private void ProcessResult(TestGroup parent, String key, Node nContent, Node nSchema, MapXmlFailures failures) throws ValidationException {
        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
            MapXmlResult content;
            TestValue result;
            if (nCNode.getNodeType() != 1 || !nCNode.getNodeName().equals(key) || (result = (content = new MapXmlResult(parent, key, nCNode, nSchema, failures, this.truncateStrings)).getResult()) == null) continue;
            parent.addGroup(result);
            this.checkResult(result);
            this.groups.put(result.getGroupHash(), result);
            this.results.put(result.getGroupHash(), result);
            for (Node nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("sequence")) continue;
                this.ProcessSequence(result, key, nCNode, nSNode, failures);
            }
        }
    }

    private void ProcessGroup(TestGroup parent, String key, Node nContent, Node nSchema, MapXmlFailures failures) throws ValidationException {
        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
            MapXmlGroup content;
            TestGroup group;
            if (nCNode.getNodeType() != 1 || !nCNode.getNodeName().equals(key) || (group = (content = new MapXmlGroup(parent, key, nCNode, nSchema, failures, this.truncateStrings)).getGroup()) == null) continue;
            parent.addGroup(group);
            this.groups.put(group.getGroupHash(), group);
            for (Node nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("sequence")) continue;
                this.ProcessSequence(group, key, nCNode, nSNode, failures);
            }
            group.isParameterGrp();
            group.isThresholdGrp();
        }
    }

    private String FilePathToString(FilePath path) {
        String relativePath = null;
        String nextChunk = null;
        while (path != null && !path.getName().equalsIgnoreCase("workspace")) {
            if (relativePath == null) {
                if (nextChunk != null) {
                    relativePath = nextChunk;
                }
            } else {
                relativePath = nextChunk + "/" + (String)relativePath;
            }
            nextChunk = path.getName();
            path = path.getParent();
        }
        if (nextChunk != null) {
            relativePath = nextChunk + "/" + relativePath;
        }
        return relativePath;
    }

    private GroupTags getElementType(Node nSchema) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String value;
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase("type")) continue;
            switch (value = attributes.item(i).getNodeValue().toLowerCase()) {
                case "jbs:result": {
                    return GroupTags.gt_result;
                }
                case "jbs:threshold": {
                    return GroupTags.gt_threshold;
                }
                case "jbs:parameter": {
                    return GroupTags.gt_parameter;
                }
            }
            return GroupTags.gt_unknown;
        }
        return GroupTags.gt_empty;
    }

    private String getElementAttribute(Node nSchema, String key) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase(key)) continue;
            return attributes.item(i).getNodeValue();
        }
        return null;
    }

    private static enum GroupTags {
        gt_empty,
        gt_unknown,
        gt_result,
        gt_threshold,
        gt_parameter;

    }
}

