/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin;

import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.Messages;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.thresholds.AbsoluteThreshold;
import org.jenkinsci.plugins.benchmark.thresholds.DeltaAverageThreshold;
import org.jenkinsci.plugins.benchmark.thresholds.DeltaThreshold;
import org.jenkinsci.plugins.benchmark.thresholds.PercentageAverageThreshold;
import org.jenkinsci.plugins.benchmark.thresholds.PercentageThreshold;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MapXmlThreshold {
    private Double minimum;
    private Double maximum;
    private Double delta;
    private Double percentage;
    private Threshold threshold = null;

    MapXmlThreshold(TestGroup parent, String key, Node nContent, Node nSchema) throws ValidationException {
        String attrName;
        Node nSNode;
        Node nSNode2;
        int nItem;
        NamedNodeMap attributes;
        ThresholdTags type;
        block76: for (Node nSNode3 = nSchema.getFirstChild(); nSNode3 != null; nSNode3 = nSNode3.getNextSibling()) {
            if (nSNode3.getNodeType() != 1 || !nSNode3.getLocalName().equalsIgnoreCase("attribute")) continue;
            type = this.getTypeTag(nSNode3);
            String attrName2 = this.getNameTag(nSNode3);
            switch (type) {
                case tt_minimum: {
                    Node node;
                    int i;
                    if (this.minimum != null) continue block76;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        try {
                            this.minimum = Double.parseDouble(node.getTextContent());
                            continue block76;
                        }
                        catch (Exception e) {
                            throw new ValidationException(Messages.IncorrectDoubleForMinimum(parent.getFullName()));
                        }
                    }
                    continue block76;
                }
                case tt_maximum: {
                    Node node;
                    int i;
                    if (this.maximum != null) continue block76;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        try {
                            this.maximum = Double.parseDouble(node.getTextContent());
                            continue block76;
                        }
                        catch (Exception e) {
                            throw new ValidationException(Messages.IncorrectDoubleForMaximum(parent.getFullName()));
                        }
                    }
                    continue block76;
                }
                case tt_delta: {
                    Node node;
                    int i;
                    if (this.delta != null) continue block76;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        try {
                            this.delta = Double.parseDouble(node.getTextContent());
                            continue block76;
                        }
                        catch (Exception e) {
                            throw new ValidationException(Messages.IncorrectDoubleForDelta(parent.getFullName()));
                        }
                    }
                    continue block76;
                }
                case tt_percentage: {
                    Node node;
                    int i;
                    if (this.delta != null) continue block76;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        try {
                            this.percentage = Double.parseDouble(node.getTextContent());
                            continue block76;
                        }
                        catch (Exception e) {
                            throw new ValidationException(Messages.IncorrectDoubleForPercentage(parent.getFullName()));
                        }
                    }
                    continue block76;
                }
            }
        }
        Node nSequence = null;
        for (nSNode2 = nSchema.getFirstChild(); nSNode2 != null; nSNode2 = nSNode2.getNextSibling()) {
            if (nSNode2.getNodeType() != 1 || !nSNode2.getLocalName().equalsIgnoreCase("sequence")) continue;
            nSequence = nSNode2;
            break;
        }
        if (nSequence != null) {
            block82: for (nSNode2 = nSequence.getFirstChild(); nSNode2 != null; nSNode2 = nSNode2.getNextSibling()) {
                if (nSNode2.getNodeType() != 1 || !nSNode2.getLocalName().equalsIgnoreCase("element")) continue;
                type = this.getTypeTag(nSNode2);
                String attrName3 = this.getNameTag(nSNode2);
                switch (type) {
                    case tt_minimum: {
                        Node nCNode;
                        if (this.minimum != null) continue block82;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            try {
                                this.minimum = Double.parseDouble(nCNode.getTextContent());
                                continue block82;
                            }
                            catch (Exception e) {
                                throw new ValidationException(Messages.IncorrectDoubleForMinimum(parent.getFullName()));
                            }
                        }
                        continue block82;
                    }
                    case tt_maximum: {
                        Node nCNode;
                        if (this.maximum != null) continue block82;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            try {
                                this.maximum = Double.parseDouble(nCNode.getTextContent());
                                continue block82;
                            }
                            catch (Exception e) {
                                throw new ValidationException(Messages.IncorrectDoubleForMaximum(parent.getFullName()));
                            }
                        }
                        continue block82;
                    }
                    case tt_delta: {
                        Node nCNode;
                        if (this.delta != null) continue block82;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            try {
                                this.delta = Double.parseDouble(nCNode.getTextContent());
                                continue block82;
                            }
                            catch (Exception e) {
                                throw new ValidationException(Messages.IncorrectDoubleForDelta(parent.getFullName()));
                            }
                        }
                        continue block82;
                    }
                    case tt_percentage: {
                        Node nCNode;
                        if (this.delta != null) continue block82;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            try {
                                this.percentage = Double.parseDouble(nCNode.getTextContent());
                                continue block82;
                            }
                            catch (Exception e) {
                                throw new ValidationException(Messages.IncorrectDoubleForPercentage(parent.getFullName()));
                            }
                        }
                        continue block82;
                    }
                }
            }
        }
        boolean thresholdDetected = false;
        block87: for (nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
            if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("attribute")) continue;
            type = this.getTypeTag(nSNode);
            attrName = this.getNameTag(nSNode);
            switch (type) {
                case tt_method: {
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (int i = 0; i < nItem; ++i) {
                        String method;
                        Node node = attributes.item(i);
                        if (!attrName.equals(node.getNodeName())) continue;
                        switch (method = node.getNodeValue().toLowerCase()) {
                            case "absolute": {
                                Threshold thres = new AbsoluteThreshold(this.minimum, this.maximum);
                                this.threshold = thres;
                                thresholdDetected = true;
                                continue block87;
                            }
                            case "percentage": {
                                Threshold thres = new PercentageThreshold(this.percentage);
                                this.threshold = thres;
                                thresholdDetected = true;
                                continue block87;
                            }
                            case "delta": {
                                Threshold thres = new DeltaThreshold(this.delta);
                                this.threshold = thres;
                                thresholdDetected = true;
                                continue block87;
                            }
                            case "percentageaverage": {
                                Threshold thres = new PercentageAverageThreshold(this.percentage);
                                this.threshold = thres;
                                thresholdDetected = true;
                                continue block87;
                            }
                            case "deltaaverage": {
                                Threshold thres = new DeltaAverageThreshold(this.delta);
                                this.threshold = thres;
                                thresholdDetected = true;
                                continue block87;
                            }
                        }
                        continue block87;
                    }
                    continue block87;
                }
            }
        }
        if (thresholdDetected) {
            return;
        }
        if (nSequence != null) {
            block89: for (nSNode = nSequence.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("element")) continue;
                type = this.getTypeTag(nSNode);
                attrName = this.getNameTag(nSNode);
                switch (type) {
                    case tt_method: {
                        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            String method;
                            if (!attrName.equals(nCNode.getLocalName())) continue;
                            switch (method = nCNode.getTextContent().toLowerCase()) {
                                case "absolute": {
                                    Threshold thres = new AbsoluteThreshold(this.minimum, this.maximum);
                                    this.threshold = thres;
                                    thresholdDetected = true;
                                    continue block89;
                                }
                                case "percentage": {
                                    Threshold thres = new PercentageThreshold(this.percentage);
                                    this.threshold = thres;
                                    thresholdDetected = true;
                                    continue block89;
                                }
                                case "delta": {
                                    Threshold thres = new DeltaThreshold(this.delta);
                                    this.threshold = thres;
                                    thresholdDetected = true;
                                    continue block89;
                                }
                                case "percentageaverage": {
                                    Threshold thres = new PercentageAverageThreshold(this.percentage);
                                    this.threshold = thres;
                                    thresholdDetected = true;
                                    continue block89;
                                }
                                case "deltaaverage": {
                                    Threshold thres = new DeltaAverageThreshold(this.delta);
                                    this.threshold = thres;
                                    thresholdDetected = true;
                                    continue block89;
                                }
                            }
                            continue block89;
                        }
                        continue block89;
                    }
                }
            }
        }
        if (thresholdDetected) {
            return;
        }
        if (key.equals(nContent.getNodeName())) {
            String method;
            switch (method = nContent.getTextContent().toLowerCase()) {
                case "absolute": {
                    Threshold thres = new AbsoluteThreshold(this.minimum, this.maximum);
                    this.threshold = thres;
                    break;
                }
                case "percentage": {
                    Threshold thres = new PercentageThreshold(this.percentage);
                    this.threshold = thres;
                    break;
                }
                case "delta": {
                    Threshold thres = new DeltaThreshold(this.delta);
                    this.threshold = thres;
                    break;
                }
                case "percentageaverage": {
                    Threshold thres = new PercentageAverageThreshold(this.percentage);
                    this.threshold = thres;
                    break;
                }
                case "deltaaverage": {
                    Threshold thres = new DeltaAverageThreshold(this.delta);
                    this.threshold = thres;
                    break;
                }
            }
        }
    }

    private String getNameTag(Node nSchema) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase("name")) continue;
            return attributes.item(i).getNodeValue();
        }
        return null;
    }

    private ThresholdTags getTypeTag(Node nSchema) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String value;
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase("type")) continue;
            switch (value = attributes.item(i).getNodeValue().toLowerCase()) {
                case "jbs:method": {
                    return ThresholdTags.tt_method;
                }
                case "jbs:minimum": {
                    return ThresholdTags.tt_minimum;
                }
                case "jbs:maximum": {
                    return ThresholdTags.tt_maximum;
                }
                case "jbs:delta": {
                    return ThresholdTags.tt_delta;
                }
                case "jbs:percentage": {
                    return ThresholdTags.tt_percentage;
                }
            }
            return ThresholdTags.tt_unknown;
        }
        return ThresholdTags.tt_empty;
    }

    public Threshold getThreshold() {
        return this.threshold;
    }

    static enum ThresholdTags {
        tt_empty,
        tt_unknown,
        tt_method,
        tt_minimum,
        tt_maximum,
        tt_delta,
        tt_percentage,
        tt_name,
        tt_description;

    }
}

