/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.MapXmlFailures;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.Messages;
import org.jenkinsci.plugins.benchmark.results.BooleanValue;
import org.jenkinsci.plugins.benchmark.results.DoubleValue;
import org.jenkinsci.plugins.benchmark.results.IntegerValue;
import org.jenkinsci.plugins.benchmark.results.StringValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestValue;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MapXmlResult {
    private Integer id = null;
    private String name = null;
    private String description = null;
    private String unit = null;
    private Map<String, String> messages = new HashMap<String, String>();
    private TestValue result;

    MapXmlResult(TestGroup parent, String key, Node nContent, Node nSchema, MapXmlFailures failures, boolean truncateStrings) throws ValidationException {
        TestValue res;
        String attrName;
        Node nSNode;
        Node nSNode2;
        Object message;
        int nItem;
        NamedNodeMap attributes;
        ResultTags type;
        block50: for (Node nSNode3 = nSchema.getFirstChild(); nSNode3 != null; nSNode3 = nSNode3.getNextSibling()) {
            if (nSNode3.getNodeType() != 1 || !nSNode3.getLocalName().equalsIgnoreCase("attribute")) continue;
            type = this.getTypeTag(nSNode3);
            String attrName2 = this.getNameTag(nSNode3);
            switch (type) {
                case rt_id: {
                    Node node;
                    int i;
                    if (this.id != null) continue block50;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        try {
                            this.id = Integer.parseInt(node.getTextContent());
                            continue block50;
                        }
                        catch (Exception e) {
                            throw new ValidationException(Messages.IncorrectIntegerForId(parent.getFullName()));
                        }
                    }
                    continue block50;
                }
                case rt_name: {
                    Node node;
                    int i;
                    if (this.name != null) continue block50;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        this.name = node.getNodeValue();
                        this.name = this.name.replaceAll(" ", "_");
                        continue block50;
                    }
                    continue block50;
                }
                case rt_description: {
                    Node node;
                    int i;
                    if (this.description != null) continue block50;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        this.description = node.getNodeValue();
                        if (!truncateStrings || this.description.length() <= 512) continue block50;
                        this.description = this.description.substring(0, 512);
                        this.description = this.description + "...";
                        continue block50;
                    }
                    continue block50;
                }
                case rt_unit: {
                    Node node;
                    int i;
                    if (this.unit != null) continue block50;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        this.unit = node.getNodeValue();
                        continue block50;
                    }
                    continue block50;
                }
                case rt_message: {
                    Node node;
                    int i;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        if (truncateStrings) {
                            message = node.getNodeValue();
                            if (((String)message).length() > 512) {
                                message = ((String)message).substring(0, 512);
                                message = (String)message + "...";
                            }
                            this.messages.put(attrName2, (String)message);
                            continue block50;
                        }
                        this.messages.put(attrName2, node.getNodeValue());
                        continue block50;
                    }
                    continue block50;
                }
            }
        }
        Node nSequence = null;
        for (nSNode2 = nSchema.getFirstChild(); nSNode2 != null; nSNode2 = nSNode2.getNextSibling()) {
            if (nSNode2.getNodeType() != 1 || !nSNode2.getLocalName().equalsIgnoreCase("sequence")) continue;
            nSequence = nSNode2;
            break;
        }
        if (nSequence != null) {
            block57: for (nSNode2 = nSequence.getFirstChild(); nSNode2 != null; nSNode2 = nSNode2.getNextSibling()) {
                if (nSNode2.getNodeType() != 1 || !nSNode2.getLocalName().equalsIgnoreCase("element")) continue;
                type = this.getTypeTag(nSNode2);
                String attrName3 = this.getNameTag(nSNode2);
                switch (type) {
                    case rt_id: {
                        Node nCNode;
                        if (this.id != null) continue block57;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            try {
                                this.id = Integer.parseInt(nCNode.getTextContent());
                                continue;
                            }
                            catch (Exception e) {
                                throw new ValidationException(Messages.IncorrectIntegerForId(parent.getFullName()));
                            }
                        }
                        continue block57;
                    }
                    case rt_name: {
                        Node nCNode;
                        if (this.name != null) continue block57;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            this.name = nCNode.getTextContent();
                            this.name = this.name.replaceAll(" ", "_");
                            continue block57;
                        }
                        continue block57;
                    }
                    case rt_description: {
                        Node nCNode;
                        if (this.description != null) continue block57;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            this.description = nCNode.getTextContent();
                            if (!truncateStrings || this.description.length() <= 512) continue block57;
                            this.description = this.description.substring(0, 512);
                            this.description = this.description + "...";
                            continue block57;
                        }
                        continue block57;
                    }
                    case rt_unit: {
                        Node nCNode;
                        if (this.unit != null) continue block57;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            this.unit = nCNode.getTextContent();
                            continue block57;
                        }
                        continue block57;
                    }
                    case rt_message: {
                        Node nCNode;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            if (truncateStrings) {
                                message = nCNode.getTextContent();
                                if (((String)message).length() > 512) {
                                    message = ((String)message).substring(0, 512);
                                    message = (String)message + "...";
                                }
                                this.messages.put(attrName3, (String)message);
                                continue block57;
                            }
                            this.messages.put(attrName3, nCNode.getTextContent());
                            continue block57;
                        }
                        continue block57;
                    }
                }
            }
        }
        boolean resultDetected = false;
        for (nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
            if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("attribute")) continue;
            type = this.getTypeTag(nSNode);
            attrName = this.getNameTag(nSNode);
            block25 : switch (type) {
                case rt_double: {
                    Number value;
                    Node node;
                    int i;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName.equals(node.getNodeName())) continue;
                        if (this.name == null) {
                            this.name = Objects.requireNonNullElse(key, attrName);
                        }
                        try {
                            value = Double.parseDouble(node.getNodeValue());
                            DoubleValue res2 = new DoubleValue(parent, null, this.name, this.description, this.unit);
                            res2.setValue((Double)value);
                            this.result = res2;
                            resultDetected = true;
                            break block25;
                        }
                        catch (Exception e) {
                            throw new ValidationException(Messages.IncorrectDoubleForDouble(parent.getFullName()));
                        }
                    }
                    break;
                }
                case rt_integer: {
                    Number value;
                    Node node;
                    int i;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName.equals(node.getNodeName())) continue;
                        if (this.name == null) {
                            this.name = Objects.requireNonNullElse(key, attrName);
                        }
                        try {
                            value = Integer.parseInt(node.getNodeValue());
                            IntegerValue res3 = new IntegerValue(parent, null, this.name, this.description, this.unit);
                            res3.setValue((Integer)value);
                            this.result = res3;
                            resultDetected = true;
                            break block25;
                        }
                        catch (Exception e) {
                            throw new ValidationException(Messages.IncorrectIntegerForInteger(parent.getFullName()));
                        }
                    }
                    break;
                }
                case rt_booleankey: {
                    Node node;
                    int i;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName.equals(node.getLocalName())) continue;
                        if (this.name == null) {
                            this.name = Objects.requireNonNullElse(key, attrName);
                        }
                        StringValue res4 = new StringValue(parent, null, this.name, this.description, this.unit);
                        res4.setValue(attrName);
                        if (failures.hasFailures()) {
                            res4.setFailedState(failures.isFailure(attrName, true));
                        }
                        this.result = res4;
                        resultDetected = true;
                        break block25;
                    }
                    break;
                }
                case rt_boolean: {
                    String text;
                    Node node;
                    int i;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName.equals(node.getLocalName())) continue;
                        if (this.name == null) {
                            this.name = Objects.requireNonNullElse(key, attrName);
                        }
                        if ((text = node.getNodeValue()).equalsIgnoreCase("true") && text.equalsIgnoreCase("false")) {
                            boolean boolValue = Boolean.parseBoolean(text);
                            res = new BooleanValue(parent, null, this.name, this.description, this.unit);
                            ((BooleanValue)res).setValue(boolValue);
                            if (failures.hasFailures()) {
                                res.setFailedState(failures.isFailure(boolValue));
                            }
                            this.result = res;
                            resultDetected = true;
                            break block25;
                        }
                        try {
                            double dblValue = Double.parseDouble(text);
                            DoubleValue res5 = new DoubleValue(parent, null, this.name, this.description, this.unit);
                            res5.setValue(dblValue);
                            if (failures.hasFailures()) {
                                res5.setFailedState(failures.isFailure(dblValue));
                            }
                            this.result = res5;
                            resultDetected = true;
                        }
                        catch (Exception e) {
                            res = new StringValue(parent, null, this.name, this.description, this.unit);
                            ((StringValue)res).setValue(text);
                            if (failures.hasFailures()) {
                                res.setFailedState(failures.isFailure(text));
                            }
                            this.result = res;
                            resultDetected = true;
                        }
                        break block25;
                    }
                    break;
                }
                case rt_value: {
                    String text;
                    Node node;
                    int i;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName.equals(node.getNodeName())) continue;
                        if (this.name == null) {
                            this.name = Objects.requireNonNullElse(key, attrName);
                        }
                        if ((text = node.getNodeValue()).equalsIgnoreCase("true") && text.equalsIgnoreCase("false")) {
                            boolean boolValue = Boolean.parseBoolean(text);
                            res = new BooleanValue(parent, null, this.name, this.description, this.unit);
                            ((BooleanValue)res).setValue(boolValue);
                            if (failures.hasFailures()) {
                                res.setFailedState(failures.isFailure(boolValue));
                            }
                            this.result = res;
                            resultDetected = true;
                            break block25;
                        }
                        try {
                            DoubleValue res6 = new DoubleValue(parent, null, this.name, this.description, this.unit);
                            res6.setValue(Double.parseDouble(text));
                            this.result = res6;
                            resultDetected = true;
                        }
                        catch (Exception e) {
                            res = new StringValue(parent, null, this.name, this.description, this.unit);
                            ((StringValue)res).setValue(text);
                            if (failures.hasFailures()) {
                                res.setFailedState(failures.isFailure(text));
                            }
                            this.result = res;
                            resultDetected = true;
                        }
                        break block25;
                    }
                    break;
                }
            }
            if (resultDetected) break;
        }
        if (resultDetected) {
            this.result.setMessages(this.messages);
            return;
        }
        if (nSequence != null) {
            for (nSNode = nSequence.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("element")) continue;
                type = this.getTypeTag(nSNode);
                attrName = this.getNameTag(nSNode);
                block32 : switch (type) {
                    case rt_double: {
                        TestValue res7;
                        Number value;
                        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName.equals(nCNode.getLocalName())) continue;
                            if (this.name == null) {
                                this.name = Objects.requireNonNullElse(key, attrName);
                            }
                            try {
                                value = Double.parseDouble(nCNode.getTextContent());
                                res7 = new DoubleValue(parent, null, this.name, this.description, this.unit);
                                ((DoubleValue)res7).setValue((Double)value);
                                this.result = res7;
                                resultDetected = true;
                                break block32;
                            }
                            catch (Exception e) {
                                throw new ValidationException(Messages.IncorrectDoubleForDouble(parent.getFullName()));
                            }
                        }
                        break;
                    }
                    case rt_integer: {
                        TestValue res7;
                        Number value;
                        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName.equals(nCNode.getLocalName())) continue;
                            if (this.name == null) {
                                this.name = Objects.requireNonNullElse(key, attrName);
                            }
                            try {
                                value = Integer.parseInt(nCNode.getTextContent());
                                res7 = new IntegerValue(parent, null, this.name, this.description, this.unit);
                                ((IntegerValue)res7).setValue((Integer)value);
                                this.result = res7;
                                resultDetected = true;
                                break block32;
                            }
                            catch (Exception e) {
                                throw new ValidationException(Messages.IncorrectIntegerForInteger(parent.getFullName()));
                            }
                        }
                        break;
                    }
                    case rt_booleankey: {
                        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName.equals(nCNode.getLocalName())) continue;
                            if (this.name == null) {
                                this.name = Objects.requireNonNullElse(key, attrName);
                            }
                            StringValue res8 = new StringValue(parent, null, this.name, this.description, this.unit);
                            res8.setValue(attrName);
                            if (failures.hasFailures()) {
                                res8.setFailedState(failures.isFailure(attrName, true));
                            }
                            this.result = res8;
                            resultDetected = true;
                        }
                        break;
                    }
                    case rt_boolean: {
                        String text;
                        TestValue res7;
                        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName.equals(nCNode.getLocalName())) continue;
                            if (this.name == null) {
                                this.name = Objects.requireNonNullElse(key, attrName);
                            }
                            if ((text = nCNode.getTextContent()).length() == 0) {
                                res7 = new StringValue(parent, null, this.name, this.description, this.unit);
                                ((StringValue)res7).setValue(attrName);
                                if (failures.hasFailures()) {
                                    res7.setFailedState(failures.isFailure(attrName, true));
                                }
                                this.result = res7;
                                resultDetected = true;
                                break block32;
                            }
                            if (text.equalsIgnoreCase("true") && text.equalsIgnoreCase("false")) {
                                boolean boolValue = Boolean.parseBoolean(text);
                                BooleanValue res9 = new BooleanValue(parent, null, this.name, this.description, this.unit);
                                res9.setValue(boolValue);
                                if (failures.hasFailures()) {
                                    res9.setFailedState(failures.isFailure(boolValue));
                                }
                                this.result = res9;
                                resultDetected = true;
                                break block32;
                            }
                            try {
                                double dblValue = Double.parseDouble(text);
                                res = new DoubleValue(parent, null, this.name, this.description, this.unit);
                                ((DoubleValue)res).setValue(dblValue);
                                if (failures.hasFailures()) {
                                    res.setFailedState(failures.isFailure(dblValue));
                                }
                                this.result = res;
                                resultDetected = true;
                            }
                            catch (Exception e) {
                                StringValue res10 = new StringValue(parent, null, this.name, this.description, this.unit);
                                res10.setValue(text);
                                if (failures.hasFailures()) {
                                    res10.setFailedState(failures.isFailure(text));
                                }
                                this.result = res10;
                                resultDetected = true;
                            }
                            break block32;
                        }
                        break;
                    }
                    case rt_value: {
                        String text;
                        TestValue res7;
                        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName.equals(nCNode.getLocalName())) continue;
                            if (this.name == null) {
                                this.name = Objects.requireNonNullElse(key, attrName);
                            }
                            if ((text = nCNode.getTextContent()).length() == 0) {
                                res7 = new StringValue(parent, null, this.name, this.description, this.unit);
                                ((StringValue)res7).setValue(attrName);
                                if (failures.hasFailures()) {
                                    res7.setFailedState(failures.isFailure(attrName, true));
                                }
                                this.result = res7;
                                resultDetected = true;
                                break block32;
                            }
                            if (text.equalsIgnoreCase("true") && text.equalsIgnoreCase("false")) {
                                boolean boolValue = Boolean.parseBoolean(text);
                                BooleanValue res11 = new BooleanValue(parent, null, this.name, this.description, this.unit);
                                res11.setValue(boolValue);
                                if (failures.hasFailures()) {
                                    res11.setFailedState(failures.isFailure(boolValue));
                                }
                                this.result = res11;
                                resultDetected = true;
                                break block32;
                            }
                            try {
                                res7 = new DoubleValue(parent, null, this.name, this.description, this.unit);
                                ((DoubleValue)res7).setValue(Double.parseDouble(text));
                                this.result = res7;
                                resultDetected = true;
                            }
                            catch (Exception e) {
                                StringValue res12 = new StringValue(parent, null, this.name, this.description, this.unit);
                                res12.setValue(text);
                                if (failures.hasFailures()) {
                                    res12.setFailedState(failures.isFailure(text));
                                }
                                this.result = res12;
                                resultDetected = true;
                            }
                            break block32;
                        }
                        break;
                    }
                }
                if (resultDetected) break;
            }
            if (resultDetected) {
                this.result.setMessages(this.messages);
                return;
            }
        }
        if (key.equals(nContent.getNodeName())) {
            TestValue res13;
            String text;
            if (this.name == null) {
                this.name = key;
            }
            if ((text = nContent.getTextContent()).length() == 0) {
                res13 = new StringValue(parent, null, this.name, this.description, this.unit);
                ((StringValue)res13).setValue(key);
                if (failures.hasFailures()) {
                    res13.setFailedState(failures.isFailure(key, true));
                }
                this.result = res13;
                resultDetected = true;
            } else if (text.equalsIgnoreCase("true") && text.equalsIgnoreCase("false")) {
                boolean boolValue = Boolean.parseBoolean(text);
                BooleanValue res14 = new BooleanValue(parent, null, this.name, this.description, this.unit);
                res14.setValue(boolValue);
                if (failures.hasFailures()) {
                    res14.setFailedState(failures.isFailure(boolValue));
                }
                this.result = res14;
                resultDetected = true;
            } else {
                try {
                    res13 = new DoubleValue(parent, null, this.name, this.description, this.unit);
                    ((DoubleValue)res13).setValue(Double.parseDouble(text));
                    this.result = res13;
                    resultDetected = true;
                }
                catch (Exception e) {
                    StringValue res15 = new StringValue(parent, null, this.name, this.description, this.unit);
                    res15.setValue(text);
                    if (failures.hasFailures()) {
                        res15.setFailedState(failures.isFailure(text));
                    }
                    this.result = res15;
                    resultDetected = true;
                }
            }
        }
        if (resultDetected) {
            this.result.setMessages(this.messages);
        }
    }

    private String getNameTag(Node nSchema) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase("name")) continue;
            return attributes.item(i).getNodeValue();
        }
        return null;
    }

    private ResultTags getTypeTag(Node nSchema) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String value;
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase("type")) continue;
            switch (value = attributes.item(i).getNodeValue().toLowerCase()) {
                case "jbs:id": {
                    return ResultTags.rt_id;
                }
                case "jbs:name": {
                    return ResultTags.rt_name;
                }
                case "jbs:description": {
                    return ResultTags.rt_description;
                }
                case "jbs:unit": {
                    return ResultTags.rt_unit;
                }
                case "jbs:value": {
                    return ResultTags.rt_value;
                }
                case "jbs:boolean": {
                    return ResultTags.rt_boolean;
                }
                case "jbs:booleankey": {
                    return ResultTags.rt_booleankey;
                }
                case "jbs:integer": {
                    return ResultTags.rt_integer;
                }
                case "jbs:double": {
                    return ResultTags.rt_double;
                }
                case "jbs:string": {
                    return ResultTags.rt_string;
                }
                case "jbs:message": {
                    return ResultTags.rt_message;
                }
            }
            return ResultTags.rt_unknown;
        }
        return ResultTags.rt_empty;
    }

    public TestValue getResult() {
        return this.result;
    }

    private static enum ResultTags {
        rt_empty,
        rt_unknown,
        rt_id,
        rt_name,
        rt_description,
        rt_unit,
        rt_boolean,
        rt_booleankey,
        rt_integer,
        rt_double,
        rt_value,
        rt_string,
        rt_message;

    }
}

