/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin;

import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.MapXmlFailures;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MapXmlGroup {
    private String name = null;
    private String description = null;
    private TestGroup group = null;

    MapXmlGroup(TestGroup parent, String key, Node nContent, Node nSchema, MapXmlFailures failures, boolean truncateStrings) {
        Node nSNode;
        GroupTags type;
        block8: for (Node nSNode2 = nSchema.getFirstChild(); nSNode2 != null; nSNode2 = nSNode2.getNextSibling()) {
            if (nSNode2.getNodeType() != 1 || !nSNode2.getLocalName().equalsIgnoreCase("attribute")) continue;
            type = this.getTypeTag(nSNode2);
            String attrName = this.getNameTag(nSNode2);
            switch (type) {
                case gt_name: {
                    Node node;
                    int i;
                    if (this.name != null) continue block8;
                    NamedNodeMap attributes = nContent.getAttributes();
                    int nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName.equals(node.getNodeName())) continue;
                        this.name = node.getNodeValue();
                        this.name = this.name.replaceAll(" ", "_");
                        continue block8;
                    }
                    continue block8;
                }
                case gt_description: {
                    Node node;
                    int i;
                    if (this.description != null) continue block8;
                    NamedNodeMap attributes = nContent.getAttributes();
                    int nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName.equals(node.getNodeName())) continue;
                        this.description = node.getNodeValue();
                        if (!truncateStrings || this.description.length() <= 512) continue block8;
                        this.description = this.description.substring(0, 512);
                        this.description = this.description + "...";
                        continue block8;
                    }
                    continue block8;
                }
            }
        }
        Node nSequence = null;
        for (nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
            if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("sequence")) continue;
            nSequence = nSNode;
            break;
        }
        if (nSequence != null) {
            block12: for (nSNode = nSequence.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("element")) continue;
                type = this.getTypeTag(nSNode);
                String attrName = this.getNameTag(nSNode);
                switch (type) {
                    case gt_name: {
                        Node nCNode;
                        if (this.name != null) continue block12;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName.equals(nCNode.getNodeName())) continue;
                            this.name = nCNode.getTextContent();
                            this.name = this.name.replaceAll(" ", "_");
                            continue block12;
                        }
                        continue block12;
                    }
                    case gt_description: {
                        Node nCNode;
                        if (this.description != null) continue block12;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName.equals(nCNode.getNodeName())) continue;
                            this.description = nCNode.getTextContent();
                            if (!truncateStrings || this.description.length() <= 512) continue block12;
                            this.description = this.description.substring(0, 512);
                            this.description = this.description + "...";
                            continue block12;
                        }
                        continue block12;
                    }
                }
            }
        }
        if (this.name == null) {
            this.name = key;
        }
        this.group = new TestGroup(parent, this.name, this.description);
    }

    private String getNameTag(Node nSchema) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase("name")) continue;
            return attributes.item(i).getNodeValue();
        }
        return null;
    }

    private GroupTags getTypeTag(Node nSchema) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase("type")) continue;
            String value = attributes.item(i).getNodeValue().toLowerCase();
            if (value.equals("jbs:name")) {
                return GroupTags.gt_name;
            }
            if (value.equals("jbs:description")) {
                return GroupTags.gt_description;
            }
            return GroupTags.gt_unknown;
        }
        return GroupTags.gt_empty;
    }

    public TestGroup getGroup() {
        return this.group;
    }

    private static enum GroupTags {
        gt_empty,
        gt_unknown,
        gt_name,
        gt_description;

    }
}

