/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin;

import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.Messages;
import org.jenkinsci.plugins.benchmark.results.TestFailure;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MapXmlFailures {
    private List<TestFailure> failures = new ArrayList<TestFailure>();

    MapXmlFailures(TestGroup parent, Node nSchema) throws ValidationException {
        this.LoadFailures(parent, nSchema);
    }

    MapXmlFailures(TestGroup parent, Node nSchema, MapXmlFailures oFailures) throws ValidationException {
        this.LoadFailures(parent, nSchema);
        if (oFailures != null) {
            this.failures.addAll(oFailures.getFailures());
        }
    }

    private void LoadFailures(TestGroup parent, Node nSchema) throws ValidationException {
        for (Node nNode = nSchema.getFirstChild(); nNode != null; nNode = nNode.getNextSibling()) {
            if (nNode.getNodeType() != 1) continue;
            if (nNode.getLocalName().equalsIgnoreCase("failures")) {
                for (Node nSubNode = nNode.getFirstChild(); nSubNode != null; nSubNode = nSubNode.getNextSibling()) {
                    if (nSubNode.getNodeType() != 1 || !nSubNode.getLocalName().equals("failure")) continue;
                    this.ProcessFailure(parent, nSubNode);
                }
                continue;
            }
            if (!nNode.getLocalName().equalsIgnoreCase("failure")) continue;
            this.ProcessFailure(parent, nNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ProcessFailure(TestGroup parent, Node nFailure) throws ValidationException {
        FailureTags type = this.getElementType(nFailure);
        switch (type) {
            case ft_boolean: {
                String text = nFailure.getTextContent();
                if (!text.equalsIgnoreCase("true") && !text.equalsIgnoreCase("false")) throw new ValidationException(Messages.MapXmlFailures_BooleanFailureOnlyTrueOrFalse());
                this.failures.add(new TestFailure(Boolean.parseBoolean(text)));
                return;
            }
            case ft_string: {
                this.failures.add(new TestFailure(nFailure.getTextContent()));
                return;
            }
            case ft_element: {
                this.failures.add(new TestFailure(nFailure.getTextContent(), true));
                return;
            }
            case ft_value: {
                String text_2 = nFailure.getTextContent();
                try {
                    Double value = Double.parseDouble(text_2);
                    String compare = this.getElementAttribute(nFailure, "compare");
                    if (compare == null) return;
                    try {
                        this.failures.add(new TestFailure(value, compare));
                        return;
                    }
                    catch (ValidationException e) {
                        throw new ValidationException(Messages.MapXmlFailures_CompareIsNotRecogmizedAsType(compare, parent.getFullName()));
                    }
                }
                catch (NumberFormatException e) {
                    throw new ValidationException(Messages.MapXmlFailures_TextCouldNotBeParseToNumber(text_2, parent.getFullName()));
                }
            }
        }
    }

    public Boolean isFailure(boolean value) {
        for (TestFailure failure : this.failures) {
            if (!failure.isFailure(value)) continue;
            return true;
        }
        return false;
    }

    public Boolean isFailure(Number value) {
        for (TestFailure failure : this.failures) {
            if (!failure.isFailure(value.doubleValue())) continue;
            return true;
        }
        return false;
    }

    public Boolean isFailure(String value) {
        for (TestFailure failure : this.failures) {
            if (!failure.isFailure(value)) continue;
            return true;
        }
        return false;
    }

    public Boolean isFailure(String value, boolean key) {
        for (TestFailure failure : this.failures) {
            if (!failure.isFailure(value, key)) continue;
            return true;
        }
        return false;
    }

    private String getElementAttribute(Node nSchema, String name) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String key = attributes.item(i).getNodeName();
            if (!key.equalsIgnoreCase(name)) continue;
            return attributes.item(i).getNodeValue();
        }
        return null;
    }

    private FailureTags getElementType(Node nSchema) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String value;
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase("type")) continue;
            switch (value = attributes.item(i).getNodeValue().toLowerCase()) {
                case "jbs:boolean": {
                    return FailureTags.ft_boolean;
                }
                case "jbs:element": {
                    return FailureTags.ft_element;
                }
                case "jbs:string": {
                    return FailureTags.ft_string;
                }
                case "jbs:value": {
                    return FailureTags.ft_value;
                }
            }
            return FailureTags.ft_unknown;
        }
        return FailureTags.ft_empty;
    }

    public int size() {
        return this.failures.size();
    }

    public List<TestFailure> getFailures() {
        return this.failures;
    }

    public boolean hasFailures() {
        return this.failures.size() > 0;
    }

    private static enum FailureTags {
        ft_empty,
        ft_unknown,
        ft_boolean,
        ft_value,
        ft_string,
        ft_element;

    }
}

