/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonFailures;
import org.jenkinsci.plugins.benchmark.results.BooleanValue;
import org.jenkinsci.plugins.benchmark.results.DoubleValue;
import org.jenkinsci.plugins.benchmark.results.StringValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestValue;

public class MapJsonResultFull {
    private final String key;
    private final JsonElement content;

    MapJsonResultFull(String key, JsonElement content) {
        this.key = key;
        this.content = content;
    }

    public TestValue get(TestGroup parent, MapJsonFailures failures) {
        if (this.content.isJsonPrimitive()) {
            JsonPrimitive primitive = this.content.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                BooleanValue result = new BooleanValue(parent, null, this.key);
                result.setValue(primitive.getAsBoolean());
                if (failures.hasFailures()) {
                    result.setFailedState(failures.isFailure(primitive.getAsBoolean()));
                }
                return result;
            }
            if (primitive.isString()) {
                StringValue result = new StringValue(parent, null, this.key);
                result.setValue(primitive.getAsString());
                if (failures.hasFailures()) {
                    result.setFailedState(failures.isFailure(primitive.getAsString()));
                }
                return result;
            }
            if (primitive.isNumber()) {
                DoubleValue result = new DoubleValue(parent, null, this.key);
                result.setValue(primitive.getAsDouble());
                return result;
            }
        }
        return null;
    }
}

