/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonFailures;
import org.jenkinsci.plugins.benchmark.results.BooleanValue;
import org.jenkinsci.plugins.benchmark.results.DoubleValue;
import org.jenkinsci.plugins.benchmark.results.IntegerValue;
import org.jenkinsci.plugins.benchmark.results.StringValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestValue;

public class MapJsonResult {
    private Integer id = null;
    private String name = null;
    private String description = null;
    private String unit = null;
    private Map<String, String> messages = new HashMap<String, String>();
    private TestValue result;

    MapJsonResult(TestGroup parent, String key, JsonObject oContent, JsonObject oSchema, MapJsonFailures failures, boolean truncateStrings) {
        ResultTags type = ResultTags.rt_unknown;
        block14: for (Map.Entry enSchema : oSchema.entrySet()) {
            String schemaKey = (String)enSchema.getKey();
            JsonElement schemaValue = (JsonElement)enSchema.getValue();
            if (!schemaValue.isJsonObject()) continue;
            JsonObject iSchemaObj = schemaValue.getAsJsonObject();
            type = this.getResultTag(iSchemaObj);
            block0 : switch (type) {
                case rt_id: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.id != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isNumber()) continue;
                        this.id = primitive.getAsInt();
                        break block0;
                    }
                    continue block14;
                }
                case rt_name: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.name != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                        this.name = primitive.getAsString();
                        this.name = this.name.replaceAll(" ", "_");
                        break block0;
                    }
                    continue block14;
                }
                case rt_description: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.description != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                        this.description = primitive.getAsString();
                        if (!truncateStrings || this.description.length() <= 512) continue block14;
                        this.description = this.description.substring(0, 512);
                        this.description = this.description + "...";
                        break block0;
                    }
                    continue block14;
                }
                case rt_unit: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.unit != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                        this.unit = primitive.getAsString();
                        break block0;
                    }
                    continue block14;
                }
                case rt_message: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                        if (truncateStrings) {
                            Object message = primitive.getAsString();
                            if (((String)message).length() > 512) {
                                message = ((String)message).substring(0, 512);
                                message = (String)message + "...";
                            }
                            this.messages.put(schemaKey, (String)message);
                            break block0;
                        }
                        this.messages.put(schemaKey, primitive.getAsString());
                        break block0;
                    }
                    break;
                }
            }
        }
        boolean resultDetected = false;
        for (Map.Entry enSchema : oSchema.entrySet()) {
            String schemaKey = (String)enSchema.getKey();
            JsonElement schemaValue = (JsonElement)enSchema.getValue();
            if (!schemaValue.isJsonObject()) continue;
            JsonObject iSchemaObj = schemaValue.getAsJsonObject();
            type = this.getResultTag(iSchemaObj);
            block7 : switch (type) {
                case rt_double: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey())) continue;
                        if (this.name == null) {
                            this.name = Objects.requireNonNullElse(key, schemaKey);
                        }
                        if (!(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isNumber()) continue;
                        DoubleValue res = new DoubleValue(parent, null, this.name, this.description, this.unit);
                        res.setValue(primitive.getAsDouble());
                        this.result = res;
                        resultDetected = true;
                        break block7;
                    }
                    break;
                }
                case rt_integer: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey())) continue;
                        if (this.name == null) {
                            this.name = Objects.requireNonNullElse(key, schemaKey);
                        }
                        if (!(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isNumber()) continue;
                        IntegerValue res = new IntegerValue(parent, null, this.name, this.description, this.unit);
                        res.setValue(primitive.getAsInt());
                        this.result = res;
                        resultDetected = true;
                        break block7;
                    }
                    break;
                }
                case rt_boolean: {
                    DoubleValue res;
                    JsonPrimitive primitive;
                    JsonElement value;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey())) continue;
                        if (this.name == null) {
                            this.name = Objects.requireNonNullElse(key, schemaKey);
                        }
                        if (!(value = (JsonElement)enContent.getValue()).isJsonPrimitive()) continue;
                        primitive = value.getAsJsonPrimitive();
                        if (primitive.isBoolean()) {
                            BooleanValue res2 = new BooleanValue(parent, null, this.name, this.description, this.unit);
                            res2.setValue(primitive.getAsBoolean());
                            if (failures.hasFailures()) {
                                res2.setFailedState(failures.isFailure(primitive.getAsBoolean()));
                            }
                            this.result = res2;
                            resultDetected = true;
                            break block7;
                        }
                        if (primitive.isString()) {
                            StringValue res3 = new StringValue(parent, null, this.name, this.description, this.unit);
                            res3.setValue(primitive.getAsString());
                            if (failures.hasFailures()) {
                                res3.setFailedState(failures.isFailure(primitive.getAsString()));
                            }
                            this.result = res3;
                            resultDetected = true;
                            break block7;
                        }
                        if (!primitive.isNumber()) break block7;
                        double dblValue = primitive.getAsDouble();
                        res = new DoubleValue(parent, null, this.name, this.description, this.unit);
                        res.setValue(dblValue);
                        if (failures.hasFailures()) {
                            res.setFailedState(failures.isFailure(primitive.getAsNumber()));
                        }
                        this.result = res;
                        resultDetected = true;
                        break block7;
                    }
                    break;
                }
                case rt_booleankey: {
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey())) continue;
                        if (this.name == null) {
                            if (key == null) {
                                this.name = schemaKey;
                                key = schemaKey;
                            } else {
                                this.name = key;
                            }
                        }
                        StringValue res = new StringValue(parent, this.name, this.description, this.unit);
                        res.setValue(key);
                        if (failures.hasFailures()) {
                            res.setFailedState(failures.isFailure(key, true));
                        }
                        this.result = res;
                        resultDetected = true;
                    }
                    break;
                }
                case rt_value: {
                    DoubleValue res;
                    JsonPrimitive primitive;
                    JsonElement value;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey())) continue;
                        if (this.name == null) {
                            this.name = Objects.requireNonNullElse(key, schemaKey);
                        }
                        if (!(value = (JsonElement)enContent.getValue()).isJsonPrimitive()) continue;
                        primitive = value.getAsJsonPrimitive();
                        if (primitive.isBoolean()) {
                            BooleanValue res4 = new BooleanValue(parent, null, this.name, this.description, this.unit);
                            res4.setValue(primitive.getAsBoolean());
                            if (failures.hasFailures()) {
                                res4.setFailedState(failures.isFailure(primitive.getAsBoolean()));
                            }
                            this.result = res4;
                            resultDetected = true;
                            break block7;
                        }
                        if (primitive.isString()) {
                            StringValue res5 = new StringValue(parent, null, this.name, this.description, this.unit);
                            res5.setValue(primitive.getAsString());
                            if (failures.hasFailures()) {
                                res5.setFailedState(failures.isFailure(primitive.getAsString()));
                            }
                            this.result = res5;
                            resultDetected = true;
                            break block7;
                        }
                        if (!primitive.isNumber()) break block7;
                        double dblValue = primitive.getAsDouble();
                        res = new DoubleValue(parent, null, this.name, this.description, this.unit);
                        res.setValue(dblValue);
                        this.result = res;
                        resultDetected = true;
                        break block7;
                    }
                    break;
                }
            }
            if (!resultDetected) continue;
            break;
        }
        if (resultDetected) {
            this.result.setMessages(this.messages);
        }
    }

    private ResultTags getResultTag(JsonObject schemaObj) {
        String type = "";
        for (Map.Entry entrySchema : schemaObj.entrySet()) {
            JsonPrimitive primitive;
            if (!((String)entrySchema.getKey()).equals("type") || !(primitive = ((JsonElement)entrySchema.getValue()).getAsJsonPrimitive()).isString()) continue;
            type = primitive.getAsString();
            break;
        }
        type = type.toLowerCase();
        switch (type) {
            case "name": {
                return ResultTags.rt_name;
            }
            case "id": {
                return ResultTags.rt_id;
            }
            case "description": {
                return ResultTags.rt_description;
            }
            case "unit": {
                return ResultTags.rt_unit;
            }
            case "message": {
                return ResultTags.rt_message;
            }
            case "boolean": {
                return ResultTags.rt_boolean;
            }
            case "booleankey": {
                return ResultTags.rt_booleankey;
            }
            case "integer": {
                return ResultTags.rt_integer;
            }
            case "double": {
                return ResultTags.rt_double;
            }
            case "value": {
                return ResultTags.rt_value;
            }
        }
        return ResultTags.rt_unknown;
    }

    public TestValue getResult() {
        return this.result;
    }

    private static enum ResultTags {
        rt_unknown,
        rt_id,
        rt_name,
        rt_description,
        rt_unit,
        rt_message,
        rt_boolean,
        rt_booleankey,
        rt_integer,
        rt_double,
        rt_value;

    }
}

