/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.Messages;
import org.jenkinsci.plugins.benchmark.results.TestFailure;
import org.jenkinsci.plugins.benchmark.results.TestGroup;

public class MapJsonFailures {
    private List<TestFailure> failures = new ArrayList<TestFailure>();

    MapJsonFailures(TestGroup parent, JsonElement eSchema) throws ValidationException {
        this.LoadFailures(parent, eSchema);
    }

    MapJsonFailures(TestGroup parent, JsonElement eSchema, MapJsonFailures oFailures) throws ValidationException {
        this.LoadFailures(parent, eSchema);
        if (oFailures != null) {
            this.failures.addAll(oFailures.getFailures());
        }
    }

    private void LoadFailures(TestGroup parent, JsonElement eSchema) throws ValidationException {
        if (eSchema.isJsonObject()) {
            JsonObject oSchema = eSchema.getAsJsonObject();
            for (Map.Entry entrySchema : oSchema.entrySet()) {
                JsonElement eFailure;
                if (((String)entrySchema.getKey()).equals("failures") && (eFailure = (JsonElement)entrySchema.getValue()).isJsonArray()) {
                    JsonArray aFailure = eFailure.getAsJsonArray();
                    for (JsonElement entryFailure : aFailure) {
                        if (!entryFailure.isJsonObject()) continue;
                        this.LoadFailureObject(parent, entryFailure);
                    }
                }
                if (!((String)entrySchema.getKey()).equals("failure")) continue;
                eFailure = (JsonElement)entrySchema.getValue();
                if (eFailure.isJsonPrimitive()) {
                    JsonPrimitive pFailure = eFailure.getAsJsonPrimitive();
                    if (pFailure.isString()) {
                        this.failures.add(new TestFailure(pFailure.getAsString()));
                    } else if (pFailure.isNumber()) {
                        this.failures.add(new TestFailure(pFailure.getAsDouble()));
                    } else if (pFailure.isBoolean()) {
                        this.failures.add(new TestFailure(pFailure.getAsBoolean()));
                    }
                }
                if (!eFailure.isJsonObject()) continue;
                this.LoadFailureObject(parent, eFailure);
            }
        }
    }

    private void LoadFailureObject(TestGroup parent, JsonElement eFailure) throws ValidationException {
        JsonPrimitive pType;
        JsonElement eType;
        JsonObject oFailure = eFailure.getAsJsonObject();
        String compareType = null;
        for (Map.Entry entryFailure : oFailure.entrySet()) {
            if (!((String)entryFailure.getKey()).equals("compare") || !(eType = (JsonElement)entryFailure.getValue()).isJsonPrimitive() || !(pType = eType.getAsJsonPrimitive()).isString()) continue;
            compareType = pType.getAsString();
        }
        for (Map.Entry entryFailure : oFailure.entrySet()) {
            if (((String)entryFailure.getKey()).equals("value") && (eType = (JsonElement)entryFailure.getValue()).isJsonPrimitive()) {
                pType = eType.getAsJsonPrimitive();
                if (pType.isString()) {
                    this.failures.add(new TestFailure(pType.getAsString()));
                } else if (pType.isBoolean()) {
                    this.failures.add(new TestFailure(pType.getAsBoolean()));
                } else if (pType.isNumber()) {
                    try {
                        this.failures.add(new TestFailure(pType.getAsDouble(), compareType));
                    }
                    catch (Exception e) {
                        throw new ValidationException(Messages.MapJsonFailures_CompareIsNotRecognisedAsType(compareType, parent.getName()));
                    }
                }
            }
            if (!((String)entryFailure.getKey()).equals("key") || !(eType = (JsonElement)entryFailure.getValue()).isJsonPrimitive() || !(pType = eFailure.getAsJsonPrimitive()).isString()) continue;
            this.failures.add(new TestFailure(pType.getAsString(), true));
        }
    }

    public Boolean isFailure(boolean value) {
        for (TestFailure failure : this.failures) {
            if (!failure.isFailure(value)) continue;
            return true;
        }
        return false;
    }

    public Boolean isFailure(Number value) {
        for (TestFailure failure : this.failures) {
            if (!failure.isFailure(value.doubleValue())) continue;
            return true;
        }
        return false;
    }

    public Boolean isFailure(String value) {
        for (TestFailure failure : this.failures) {
            if (!failure.isFailure(value)) continue;
            return true;
        }
        return false;
    }

    public Boolean isFailure(String value, boolean key) {
        for (TestFailure failure : this.failures) {
            if (!failure.isFailure(value, key)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.failures.size();
    }

    public List<TestFailure> getFailures() {
        return this.failures;
    }

    public boolean hasFailures() {
        return this.failures.size() > 0;
    }
}

