/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.MapperBase;
import org.jenkinsci.plugins.benchmark.parsers.Messages;
import org.jenkinsci.plugins.benchmark.results.BooleanValue;
import org.jenkinsci.plugins.benchmark.results.DoubleValue;
import org.jenkinsci.plugins.benchmark.results.IntegerValue;
import org.jenkinsci.plugins.benchmark.results.StringValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.utilities.FilePathGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JUnitJenkins
extends MapperBase {
    public JUnitJenkins(Integer build, boolean truncateStrings) throws IOException, ValidationException {
        super(build, truncateStrings);
    }

    public boolean importFromFile(Integer build, String inputFile) throws IOException, InterruptedException {
        File oFile = new File(inputFile);
        if (oFile.exists()) {
            this.importFromFile(build, oFile);
            return true;
        }
        return false;
    }

    public void importFromFile(Integer build, File filename) throws IOException, InterruptedException {
        String nodeText;
        Node nCNode;
        Document document;
        this.builds.add(build);
        try {
            document = this.getXML(filename);
        }
        catch (Exception e) {
            throw new IOException(Messages.jUnitJenkins_FileFormatNotRecognizedAsXml(filename.getName()));
        }
        Element element = document.getDocumentElement();
        StringValue plugin = null;
        String text = element.getAttribute("plugin");
        if (text != null && !text.isEmpty()) {
            int hash = "plugin".hashCode();
            plugin = (StringValue)this.parameters.get(hash);
            if (plugin == null) {
                plugin = new StringValue(this.rootGroup, null, "plugin_version", null, TestGroup.ClassType.ct_parameter);
                this.parameters.put(hash, plugin);
                this.groups.put(hash, plugin);
                this.rootGroup.addGroup(plugin);
            }
            plugin.setValue(build, text);
        }
        DoubleValue total_duration = null;
        BooleanValue longStdio = null;
        for (nCNode = element.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
            Boolean keepLongStdio;
            int hash;
            if (nCNode.getNodeType() != 1) continue;
            nodeText = nCNode.getNodeName();
            if (nodeText.equals("duration")) {
                Double duration;
                text = nCNode.getTextContent();
                if (text == null || text.isEmpty() || !((duration = Double.valueOf(Double.parseDouble(text))) > 0.0)) continue;
                hash = "duration".hashCode();
                total_duration = (DoubleValue)this.parameters.get(hash);
                if (total_duration == null) {
                    total_duration = new DoubleValue(this.rootGroup, null, "all_tests_duration", TestGroup.ClassType.ct_parameter);
                    this.parameters.put(hash, total_duration);
                    this.groups.put(hash, total_duration);
                    this.rootGroup.addGroup(total_duration);
                }
                total_duration.setValue(build, duration);
                continue;
            }
            if (!nodeText.equals("keepLongStdio") || (text = nCNode.getTextContent()) == null || text.isEmpty() || (keepLongStdio = Boolean.valueOf(Boolean.parseBoolean(text))) == null) continue;
            hash = "keepLongStdio".hashCode();
            longStdio = (BooleanValue)this.parameters.get(hash);
            if (longStdio == null) {
                longStdio = new BooleanValue(this.rootGroup, null, "keep_long_stdio", TestGroup.ClassType.ct_parameter);
                this.parameters.put(hash, longStdio);
                this.groups.put(hash, longStdio);
                this.rootGroup.addGroup(longStdio);
            }
            longStdio.setValue(build, keepLongStdio);
        }
        for (nCNode = element.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
            if (nCNode.getNodeType() != 1) continue;
            nodeText = nCNode.getNodeName();
            if (!nCNode.getNodeName().equals("suites")) continue;
            this.ProcessXMLSuites(this.rootGroup, build, nCNode, plugin, total_duration, longStdio);
        }
    }

    private void ProcessXMLSuites(TestGroup parent, Integer build, Node xNode, StringValue plugin, DoubleValue total_duration, BooleanValue keepLongStdio) throws IOException, InterruptedException {
        Node nCNode;
        int nFiles = 0;
        ArrayList<FilePathGroup> filenames = new ArrayList<FilePathGroup>();
        block0: for (nCNode = xNode.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
            if (!nCNode.getNodeName().equals("suite")) continue;
            for (Node nCNode2 = nCNode.getFirstChild(); nCNode2 != null; nCNode2 = nCNode2.getNextSibling()) {
                if (!nCNode2.getNodeName().equals("file")) continue;
                String text = nCNode2.getTextContent();
                if (text == null || text.isEmpty()) continue block0;
                filenames.add(new FilePathGroup(text));
                ++nFiles;
                continue block0;
            }
        }
        if (filenames.size() != nFiles) {
            throw new IOException(Messages.jUnitJenkins_WrongNumberOfFiles());
        }
        if (nFiles > 1) {
            JUnitJenkins.RecurseNames(false, 0, "", filenames);
            nCNode = xNode.getFirstChild();
            for (FilePathGroup file : filenames) {
                if (!nCNode.getNodeName().equals("suite")) continue;
                this.ProcessXMLSuite(false, file, parent, build, nCNode, plugin, total_duration, keepLongStdio);
                nCNode = nCNode.getNextSibling();
            }
        } else {
            for (nCNode = xNode.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                if (!nCNode.getNodeName().equals("suite")) continue;
                this.ProcessXMLSuite(true, null, parent, build, nCNode, plugin, total_duration, keepLongStdio);
            }
        }
    }

    public static void RecurseNames(boolean odd, int pos, String shortName, List<FilePathGroup> names) {
        int maxSize = 0;
        for (FilePathGroup name : names) {
            if (maxSize >= name.getNumberOfSegments()) continue;
            maxSize = name.getNumberOfSegments();
        }
        if (pos < maxSize || names.size() == 0) {
            String base = names.get(0).getPathSegment(pos);
            ArrayList<FilePathGroup> matchList = new ArrayList<FilePathGroup>();
            ArrayList<FilePathGroup> oddList = new ArrayList<FilePathGroup>();
            for (FilePathGroup name : names) {
                if (name.getPathSegment(pos).equals(base)) {
                    matchList.add(name);
                    continue;
                }
                oddList.add(name);
            }
            if (oddList.size() > 0) {
                if (shortName != null && shortName.length() == 0) {
                    JUnitJenkins.RecurseNames(false, pos + 1, base, matchList);
                } else {
                    JUnitJenkins.RecurseNames(false, pos + 1, shortName + File.separator + base, matchList);
                }
                JUnitJenkins.RecurseNames(true, pos, shortName, oddList);
            } else if (odd) {
                if (shortName != null && shortName.length() == 0) {
                    JUnitJenkins.RecurseNames(false, pos + 1, base, matchList);
                } else {
                    JUnitJenkins.RecurseNames(false, pos + 1, shortName + File.separator + base, matchList);
                }
            } else {
                JUnitJenkins.RecurseNames(false, pos + 1, shortName, matchList);
            }
        } else {
            for (FilePathGroup name : names) {
                name.setRelativepath(shortName);
            }
        }
    }

    private void ProcessXMLSuite(boolean singleFile, FilePathGroup file, TestGroup parent, Integer build, Node xNode, StringValue plugin, DoubleValue total_duration, BooleanValue keepLongStdio) {
        Node nCNode;
        Double _duration = null;
        for (Node nCNode2 = xNode.getFirstChild(); nCNode2 != null; nCNode2 = nCNode2.getNextSibling()) {
            String text;
            String nodeText = nCNode2.getNodeName();
            if (!nodeText.equals("duration") || (text = nCNode2.getTextContent()) == null || text.isEmpty()) continue;
            _duration = Double.parseDouble(text);
        }
        TestGroup _file = null;
        StringBuffer _key = new StringBuffer();
        if (!singleFile) {
            for (nCNode = xNode.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                String name;
                if (!nCNode.getNodeName().equals("name") || (name = nCNode.getTextContent()) == null || name.isEmpty()) continue;
                _key.append(name);
                int hash = _key.toString().hashCode();
                _file = (TestGroup)this.files.get(hash);
                if (_file == null) {
                    _file = new TestGroup(this.rootGroup, file.getRelativePath(), file.getFullPath(), TestGroup.ClassType.ct_fileGrp);
                    this.files.put(hash, _file);
                    this.groups.put(hash, _file);
                    this.rootGroup.addGroup(_file);
                    this.detected.setFileDetected(true);
                }
                if (_duration != null && _duration > 0.0) {
                    String key = _key.toString() + "file_duration";
                    hash = key.hashCode();
                    DoubleValue file_duration = (DoubleValue)this.parameters.get(hash);
                    if (file_duration == null) {
                        file_duration = new DoubleValue(_file, null, "file_duration", TestGroup.ClassType.ct_parameter);
                        this.parameters.put(hash, file_duration);
                        this.groups.put(hash, file_duration);
                        _file.addGroup(file_duration);
                    }
                    file_duration.setValue(build, _duration);
                }
                break;
            }
        } else {
            _file = parent;
        }
        for (nCNode = xNode.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
            if (!nCNode.getNodeName().equals("cases")) continue;
            this.ProcessXMLCases(_file, build, _key.toString(), nCNode, plugin, total_duration, keepLongStdio);
        }
    }

    private void ProcessXMLCases(TestGroup parent, Integer build, String key, Node xNode, StringValue plugin, DoubleValue total_duration, BooleanValue keepLongStdio) {
        for (Node nCNode = xNode.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
            if (!nCNode.getNodeName().equals("case")) continue;
            this.ProcessXMLCase(parent, build, key, nCNode, plugin, total_duration, keepLongStdio);
        }
    }

    private void ProcessXMLCase(TestGroup parent, Integer build, String key, Node xNode, StringValue plugin, DoubleValue total_duration, BooleanValue keepLongStdio) {
        String _group = null;
        Double _duration = null;
        Integer _failedSince = null;
        HashMap<String, String> _messages = new HashMap<String, String>();
        block18: for (Node nCNode = xNode.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
            String nodeText;
            switch (nodeText = nCNode.getNodeName()) {
                case "className": {
                    String text = nCNode.getTextContent();
                    if (text == null || text.isEmpty()) continue block18;
                    _group = text;
                    continue block18;
                }
                case "failedSince": {
                    String text = nCNode.getTextContent();
                    if (text == null || text.isEmpty()) continue block18;
                    _failedSince = Integer.parseInt(text);
                    continue block18;
                }
                case "skippedMessage": {
                    String text = nCNode.getTextContent();
                    if (text == null || text.isEmpty()) continue block18;
                    _messages.put("skippedMessage", text);
                    continue block18;
                }
                case "stdout": {
                    String text = nCNode.getTextContent();
                    if (text == null || text.isEmpty()) continue block18;
                    _messages.put("stdout", text);
                    continue block18;
                }
                case "stderr": {
                    String text = nCNode.getTextContent();
                    if (text == null || text.isEmpty()) continue block18;
                    _messages.put("stdout", text);
                    continue block18;
                }
                case "errorStackTrace": {
                    String text = nCNode.getTextContent();
                    if (text == null || text.isEmpty()) continue block18;
                    _messages.put("errorStackTrace", text);
                    continue block18;
                }
                case "errorDetails": {
                    String text = nCNode.getTextContent();
                    if (text == null || text.isEmpty()) continue block18;
                    _messages.put("errorDetails", text);
                    continue block18;
                }
            }
        }
        if (_failedSince != null) {
            Node nCNode;
            String _name = "";
            StringBuffer _key = new StringBuffer(key);
            for (nCNode = xNode.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                IntegerValue failedSince;
                if (!nCNode.getNodeName().equals("testName") || (_name = nCNode.getTextContent()) == null || _name.isEmpty()) continue;
                if (_group != null && !_group.isEmpty()) {
                    _key.append(_group);
                }
                _key.append(_name);
                int hash = _key.toString().hashCode();
                StringValue result = (StringValue)this.results.get(hash);
                if (result == null) {
                    result = new StringValue(parent, _group, _name);
                    this.results.put(hash, result);
                    this.groups.put(hash, result);
                    parent.addGroup(result);
                    this.detected.setGroupDetected(true);
                }
                if (_failedSince > 0) {
                    result.setValue(build, "Failed");
                    result.setFailedState(build, true);
                } else {
                    result.setValue(build, "Passed");
                    result.setFailedState(build, false);
                }
                result.setMessages(build, _messages);
                if (plugin != null) {
                    result.setParameter(build, plugin);
                }
                if (total_duration != null) {
                    result.setParameter(build, total_duration);
                }
                if (keepLongStdio != null) {
                    result.setParameter(build, keepLongStdio);
                }
                if ((failedSince = (IntegerValue)this.parameters.get(hash = (_key.toString() + "FailedSince").hashCode())) == null) {
                    failedSince = new IntegerValue((TestGroup)result, "FailedSince", null, TestGroup.ClassType.ct_parameter);
                    this.parameters.put(hash, failedSince);
                    this.groups.put(hash, failedSince);
                    result.addGroup(failedSince);
                }
                failedSince.setValue(build, _failedSince);
                if (plugin != null) {
                    failedSince.setParameter(build, plugin);
                }
                if (total_duration != null) {
                    failedSince.setParameter(build, total_duration);
                }
                if (keepLongStdio == null) break;
                failedSince.setParameter(build, keepLongStdio);
                break;
            }
            if (_failedSince == 0) {
                for (nCNode = xNode.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                    String text;
                    if (!nCNode.getNodeName().equals("duration") || (text = nCNode.getTextContent()) == null || text.isEmpty() || !((_duration = Double.valueOf(Double.parseDouble(text))) > 0.0)) continue;
                    _key.append("duration");
                    int hash = _key.toString().hashCode();
                    DoubleValue result = (DoubleValue)this.results.get(hash);
                    if (result == null) {
                        result = new DoubleValue(parent, _group, _name + ".duration");
                        this.results.put(hash, result);
                        this.groups.put(hash, result);
                        parent.addGroup(result);
                    }
                    result.setValue(build, _duration);
                    if (plugin != null) {
                        result.setParameter(build, plugin);
                    }
                    if (total_duration != null) {
                        result.setParameter(build, total_duration);
                    }
                    if (keepLongStdio == null) break;
                    result.setParameter(build, keepLongStdio);
                    break;
                }
            }
        }
    }

    private Document getXML(File xmlFile) throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        factory.setExpandEntityReferences(false);
        factory.setXIncludeAware(false);
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(xmlFile);
    }
}

