/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.core;

import com.google.gson.JsonArray;
import hudson.model.Action;
import hudson.model.Job;
import java.awt.ComponentOrientation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.TreeSet;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.benchmark.core.BenchmarkPublisher;
import org.jenkinsci.plugins.benchmark.core.Messages;
import org.jenkinsci.plugins.benchmark.parsers.MapperBase;
import org.jenkinsci.plugins.benchmark.results.NumeralValue;
import org.jenkinsci.plugins.benchmark.results.TestValue;
import org.jenkinsci.plugins.benchmark.utilities.FrontendMethod;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class BenchmarkResultAction
implements Action,
SimpleBuildStep.LastBuildAction {
    private static final Logger log = Logger.getLogger(BenchmarkResultAction.class.getName());
    private final Job<?, ?> project;
    private final BenchmarkPublisher core;
    private transient TreeSet<Integer> builds;
    private transient TestValue result;

    BenchmarkResultAction(Job<?, ?> project, BenchmarkPublisher core) {
        this.project = project;
        this.core = core;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "BenchmarkResult";
    }

    public String getDisplayName() {
        return Messages.BenchmarkResultAction_DisplayName();
    }

    @FrontendMethod
    public String getTextDirection() {
        if (ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight()) {
            return "ltr";
        }
        return "rtl";
    }

    @FrontendMethod
    public String getRightBoxPosition() {
        if (ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight()) {
            return "right";
        }
        return "left";
    }

    @FrontendMethod
    public Boolean getHasResult() {
        if (this.core.getSelectedResult() == null) {
            return false;
        }
        return true;
    }

    @FrontendMethod
    public String getResultName() {
        this.result = null;
        try {
            Integer resultID = this.core.getSelectedResult();
            if (resultID != null) {
                this.core.fillAllResults(this.project);
                MapperBase mapper = this.core.getMapper();
                this.result = mapper.getResults().get(resultID);
                this.builds = mapper.getBuilds();
                return Messages.BenchmarkResultAction_ResultName(this.result.getName());
            }
            return "none";
        }
        catch (Exception e) {
            return "none";
        }
    }

    @FrontendMethod
    public String getGroupName() {
        try {
            MapperBase base = this.core.getMapper();
            if (base != null && base.getDetected().isGroupDetected().booleanValue()) {
                if (this.result.getGroup() == null) {
                    return Messages.BenchmarkResultAction_NoGroup();
                }
                return Messages.BenchmarkResultAction_GroupName(this.result.getGroup());
            }
            return "none";
        }
        catch (Exception e) {
            return "none";
        }
    }

    @FrontendMethod
    public String getFileName() {
        try {
            MapperBase base = this.core.getMapper();
            if (base != null && base.getDetected().isFileDetected().booleanValue()) {
                return Messages.BenchmarkResultAction_FileName(this.result.getParent().getDescription());
            }
            return "none";
        }
        catch (Exception e) {
            return "none";
        }
    }

    @FrontendMethod
    public Boolean getIsNumeral() {
        try {
            return this.result.isNumeral();
        }
        catch (Exception e) {
            return false;
        }
    }

    @FrontendMethod
    public String getGraphTitle() {
        try {
            NumeralValue value = (NumeralValue)this.result;
            return value.getUnit();
        }
        catch (Exception e) {
            return "none";
        }
    }

    @FrontendMethod
    public JsonArray getChartLabels() {
        JsonArray array = new JsonArray();
        if (ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight()) {
            Integer build = this.builds.last();
            while (build >= this.builds.first()) {
                array.add((Number)build);
                Integer n = build;
                Integer n2 = build = Integer.valueOf(build - 1);
            }
        } else {
            Integer build = this.builds.first();
            while (build <= this.builds.last()) {
                array.add((Number)build);
                Integer n = build;
                Integer n3 = build = Integer.valueOf(build + 1);
            }
        }
        return array;
    }

    @FrontendMethod
    public JsonArray getChartData() {
        try {
            return this.result.getDataAsJsonArray(this.builds);
        }
        catch (Exception e) {
            return new JsonArray();
        }
    }

    @FrontendMethod
    public String getTablePageURL() {
        return Jenkins.get().getRootUrl() + this.project.getUrl() + "BenchmarkTable";
    }

    @FrontendMethod
    public String getRawTable() {
        try {
            TestValue result = this.result;
            MapperBase base = this.core.getMapper();
            if (base != null && result != null) {
                StringBuffer output = new StringBuffer();
                output.append("<thead><tr><th>");
                output.append(Messages.Build());
                Integer build = this.builds.last();
                while (build >= this.builds.first()) {
                    output.append("</th><th>");
                    output.append(build.toString());
                    Integer n = build;
                    Integer n2 = build = Integer.valueOf(build - 1);
                }
                output.append("</th></tr></thead><tbody><tr><td style=\"text-align:center;\"><b>");
                output.append(Messages.Value());
                output.append("</b></td>");
                output.append(result.getHTMLResult(this.builds, base.getDecimalSeparator()));
                output.append("</tr></tbody>");
                return output.toString();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @FrontendMethod
    public String getCondensedTable() {
        try {
            TestValue result = this.result;
            MapperBase base = this.core.getMapper();
            if (base != null && result != null) {
                return result.getHTMLCondensedDetail(base.getDetected(), base.getDecimalSeparator());
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @FrontendMethod
    public String getGraphYMinimum() {
        try {
            MapperBase base = this.core.getMapper();
            NumeralValue value = (NumeralValue)base.getResults().get(this.core.getSelectedResult());
            if (value.getMaximum() > value.getMinimum()) {
                return String.format(Locale.US, "%6g", value.getMinimum() - 0.2 * (value.getMaximum() - value.getMinimum()));
            }
            return String.format(Locale.US, "%6g", value.getMaximum() - 0.2 * value.getMaximum());
        }
        catch (Exception e) {
            return "0";
        }
    }

    @FrontendMethod
    public String getGraphYMaximum() {
        try {
            MapperBase base = this.core.getMapper();
            NumeralValue value = (NumeralValue)base.getResults().get(this.core.getSelectedResult());
            if (value.getMaximum() > value.getMinimum()) {
                return String.format(Locale.US, "%6g", value.getMaximum() + 0.2 * (value.getMaximum() - value.getMinimum()));
            }
            return String.format(Locale.US, "%6g", value.getMaximum() + 0.2 * value.getMaximum());
        }
        catch (Exception e) {
            return "10";
        }
    }

    @JavaScriptMethod
    public String getResultDetails() {
        try {
            TestValue result = this.result;
            MapperBase base = this.core.getMapper();
            if (base != null && result != null) {
                return result.getHTMLDetails(this.getBuildNumber(), base.getDecimalSeparator());
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @JavaScriptMethod
    public String getParameters() {
        try {
            TestValue result = this.result;
            MapperBase base = this.core.getMapper();
            if (base != null && result != null) {
                return result.getHTMLParameters(this.getBuildNumber(), base.getDecimalSeparator());
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @FrontendMethod
    public String getResultPageURL() {
        return Jenkins.get().getRootUrl() + this.project.getUrl() + "BenchmarkResult";
    }

    @JavaScriptMethod
    public int getBuildSelected() {
        Integer build = this.core.getSelectedBuild();
        if (build == null) {
            return 1;
        }
        return this.core.getSelectedBuild();
    }

    @JavaScriptMethod
    public int getBuildNumber() {
        Integer build = this.core.getSelectedBuild();
        if (build == null) {
            return this.builds.last();
        }
        return this.builds.last() - build + 1;
    }

    @JavaScriptMethod
    public void resetClock() {
        this.core.resetClock();
    }

    @JavaScriptMethod
    public void setBuildSelected(Integer build) {
        this.core.setSelectedBuild(build);
    }

    public Collection<? extends Action> getProjectActions() {
        ArrayList<BenchmarkResultAction> projectActions = new ArrayList<BenchmarkResultAction>();
        projectActions.add(new BenchmarkResultAction(this.project, this.core));
        return projectActions;
    }

    public Job<?, ?> getProject() {
        return this.project;
    }

    public BenchmarkPublisher getCore() {
        return this.core;
    }
}

