/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.core;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Job;
import hudson.model.Run;
import java.awt.ComponentOrientation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.benchmark.core.BenchmarkPublisher;
import org.jenkinsci.plugins.benchmark.core.Messages;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.MapperBase;
import org.jenkinsci.plugins.benchmark.utilities.ContentDetected;
import org.jenkinsci.plugins.benchmark.utilities.FrontendMethod;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class BenchmarkProjectAction
implements Action,
SimpleBuildStep.LastBuildAction {
    private static final Logger log = Logger.getLogger(BenchmarkProjectAction.class.getName());
    private final Job<?, ?> project;
    private final BenchmarkPublisher core;

    BenchmarkProjectAction(Job<?, ?> project, BenchmarkPublisher core) {
        this.project = project;
        this.core = core;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "BenchmarkTable";
    }

    @FrontendMethod
    public String getTextDirection() {
        if (ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight()) {
            return "ltr";
        }
        return "rtl";
    }

    @FrontendMethod
    public String getRightBoxPosition() {
        if (ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight()) {
            return "right";
        }
        return "left";
    }

    @FrontendMethod
    public String getBottomMessage() {
        return Messages.BenchmarkProjectAction_DownloadTablesAt();
    }

    @FrontendMethod
    public String getRootPageURL() {
        return Jenkins.get().getRootUrl() + this.project.getUrl();
    }

    @FrontendMethod
    public String getResultPageURL() {
        return Jenkins.get().getRootUrl() + this.project.getUrl() + "BenchmarkResult";
    }

    @FrontendMethod
    public String getAPIURL() {
        return Jenkins.get().getRootUrl() + this.project.getUrl() + "BenchmarkTable/api/json";
    }

    @FrontendMethod
    public Boolean getContentAvailable() {
        try {
            Run run = this.project.getLastBuild();
            if (run != null) {
                if (this.core.hasResults(run).booleanValue()) {
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException | NullPointerException e) {
            return false;
        }
    }

    @FrontendMethod
    public int getNumberOfHeads() {
        int i = 1;
        try {
            MapperBase base;
            ContentDetected detected;
            Run run = this.project.getLastBuild();
            if (run != null && (detected = (base = this.core.getMapper(run)).getDetected()) != null) {
                if (detected.isFileDetected().booleanValue()) {
                    ++i;
                }
                if (detected.isGroupDetected().booleanValue()) {
                    ++i;
                }
                if (detected.isUnitsDetected().booleanValue()) {
                    ++i;
                }
            }
            return i;
        }
        catch (JsonIOException | JsonSyntaxException | IOException | InterruptedException | NullPointerException | ValidationException e) {
            return i;
        }
    }

    @FrontendMethod
    public String getRawTable() {
        try {
            this.resetClock();
            Run run = this.project.getLastBuild();
            if (run != null) {
                MapperBase base = this.core.getMapper(run);
                return base.getHTMLTable();
            }
            return "";
        }
        catch (Exception e) {
            log.info(Messages.BenchmarkProjectAction_RawTableErrorDetected());
            log.info(Messages.BenchmarkProjectAction_RawTableErrorMessage(e.getMessage()));
            return "";
        }
    }

    @JavaScriptMethod
    public String getCondensedTable() {
        try {
            Run run = this.project.getLastBuild();
            if (run != null) {
                MapperBase base = this.core.getMapper(run);
                return base.getHTMLCondensedTable();
            }
            return "";
        }
        catch (Exception e) {
            log.info(Messages.BenchmarkProjectAction_CondensedTableErrorDetected());
            log.info(Messages.BenchmarkProjectAction_CondensedTableErrorMessage(e.getMessage()));
            return "";
        }
    }

    @FrontendMethod
    public String getEmptyTableWord() {
        return Messages.BenchmarkProjectAction_DatatablesEmptyTable();
    }

    @FrontendMethod
    public String getZeroRecordsWord() {
        return Messages.BenchmarkProjectAction_DatatablesZeroRecords();
    }

    @FrontendMethod
    public String getFirstWord() {
        return Messages.BenchmarkProjectAction_DatatablesFirst();
    }

    @FrontendMethod
    public String getPreviousWord() {
        return Messages.BenchmarkProjectAction_DatatablesPrevious();
    }

    @FrontendMethod
    public String getNextWord() {
        return Messages.BenchmarkProjectAction_DatatablesNext();
    }

    @FrontendMethod
    public String getLastWord() {
        return Messages.BenchmarkProjectAction_DatatablesLast();
    }

    @JavaScriptMethod
    public void setResultSelected(Integer result) {
        this.core.setSelectedResult(result);
        this.core.setSelectedBuild(null);
    }

    @JavaScriptMethod
    public void resetClock() {
        this.core.resetClock();
    }

    @JavaScriptMethod
    public String getCSVRawTable() {
        try {
            this.resetClock();
            Run run = this.project.getLastBuild();
            if (run != null) {
                MapperBase base = this.core.getMapper(run);
                StringBuffer output = new StringBuffer();
                output.append(base.getCSVTableHeader());
                output.append("\n");
                output.append(base.getCSVTableBody());
                return output.toString();
            }
            return "";
        }
        catch (Exception e) {
            log.info(Messages.BenchmarkProjectAction_CsvRawTableErrorDetected());
            log.info(Messages.BenchmarkProjectAction_CsvRawTableErrorMessage(e.getMessage()));
            return "";
        }
    }

    @Exported(visibility=2)
    public String getCSVRawHeader() {
        try {
            this.resetClock();
            Run run = this.project.getLastBuild();
            if (run != null) {
                MapperBase base = this.core.getMapper(run);
                return base.getCSVTableHeader();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Exported(visibility=2)
    public String getCSVRawBody() {
        try {
            this.resetClock();
            Run run = this.project.getLastBuild();
            if (run != null) {
                MapperBase base = this.core.getMapper(run);
                return base.getCSVTableBody();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @JavaScriptMethod
    public String getCSVRawStateTable() {
        try {
            this.resetClock();
            Run run = this.project.getLastBuild();
            if (run != null) {
                MapperBase base = this.core.getMapper(run);
                Object output = "";
                output = (String)output + base.getCSVTableHeader() + "\n";
                output = (String)output + base.getCSVTableStateBody();
                return output;
            }
            return "";
        }
        catch (Exception e) {
            log.info("Benchmark CSV Raw Table Result - Error detected");
            log.info("Benchmark CSV Raw Table Result - " + e.getMessage());
            return "";
        }
    }

    @Exported(visibility=2)
    public String getCSVRawStateBody() {
        try {
            this.resetClock();
            Run run = this.project.getLastBuild();
            if (run != null) {
                MapperBase base = this.core.getMapper(run);
                return base.getCSVTableStateBody();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @JavaScriptMethod
    public String getCSVCondensedTable() {
        try {
            Run run = this.project.getLastBuild();
            if (run != null) {
                MapperBase base = this.core.getMapper(run);
                StringBuffer output = new StringBuffer();
                output.append(base.getCSVCondensedTableHeader());
                output.append("\n");
                output.append(base.getCSVCondensedTableBody());
                return output.toString();
            }
            return "";
        }
        catch (Exception e) {
            log.info(Messages.BenchmarkProjectAction_CsvCondensedTableErrorDetected());
            log.info(Messages.BenchmarkProjectAction_CsvCondensedTableErrorMessage(e.getMessage()));
            return "";
        }
    }

    @Exported(visibility=2)
    public String getCSVCondensedHeader() {
        try {
            Run run = this.project.getLastBuild();
            if (run != null) {
                MapperBase base = this.core.getMapper(run);
                return base.getCSVCondensedTableHeader();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Exported(visibility=2)
    public String getCSVCondensedBody() {
        try {
            Run run = this.project.getLastBuild();
            if (run != null) {
                MapperBase base = this.core.getMapper(run);
                return base.getCSVCondensedTableBody();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public Collection<? extends Action> getProjectActions() {
        ArrayList<BenchmarkProjectAction> projectActions = new ArrayList<BenchmarkProjectAction>();
        projectActions.add(new BenchmarkProjectAction(this.project, this.core));
        return projectActions;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public Job<?, ?> getProject() {
        return this.project;
    }

    public BenchmarkPublisher getCore() {
        return this.core;
    }
}

