/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.condensed;

import org.jenkinsci.plugins.benchmark.results.Messages;
import org.jenkinsci.plugins.benchmark.results.StringValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.utilities.ContentDetected;

public class StringCondensed
extends StringValue {
    private final int passed;
    private final int failed;

    public StringCondensed(TestGroup parent, String group, String name, String description, String unit, int passed, int failed) {
        super(parent, group, name, description, unit);
        this.passed = passed;
        this.failed = failed;
    }

    @Override
    public String getHTMLCondensed(Integer key, ContentDetected detected, char decimalSeparator) {
        StringBuffer content = new StringBuffer();
        content.append("<tr><td>");
        if (detected.isFileDetected().booleanValue()) {
            if (this.parent == null) {
                content.append("</td><td>");
            } else {
                content.append(this.parent.getName());
                content.append("</td><td>");
            }
        }
        if (detected.isGroupDetected().booleanValue()) {
            if (this.group == null) {
                content.append("</td><td>");
            } else {
                content.append(this.group);
                content.append("</td><td>");
            }
        }
        content.append(this.getName());
        content.append("</td><td>");
        if (detected.isUnitsDetected().booleanValue()) {
            if (this.unit == null) {
                content.append("-</td><td>");
            } else {
                content.append(this.unit);
                content.append("</td><td>");
            }
        }
        content.append(key.toString());
        content.append("</td><td>");
        if (detected.isNumeralDetected().booleanValue()) {
            content.append("</td><td></td><td></td><td></td><td>");
        }
        content.append(Integer.toString(this.passed));
        content.append("</td><td>");
        content.append(Integer.toString(this.failed));
        content.append("</td></tr>");
        return content.toString();
    }

    @Override
    public String getHTMLCondensedDetail(ContentDetected detected, char decimalSeparator) {
        StringBuffer content = new StringBuffer();
        content.append("<tr><td>");
        content.append(Messages.NumberOFPassedTests());
        content.append("</td><td>");
        content.append(Integer.toString(this.passed));
        content.append("</td></tr><tr><td>");
        content.append(Messages.NumberOfFailedTests());
        content.append("</td><td>");
        content.append(Integer.toString(this.failed));
        content.append("</td></tr>");
        return content.toString();
    }

    @Override
    public String getCSVCondensed(ContentDetected detected) {
        StringBuffer content = new StringBuffer();
        if (detected.isFileDetected().booleanValue()) {
            if (this.parent == null) {
                content.append(',');
            } else {
                content.append(this.parent.getName());
                content.append(',');
            }
        }
        if (detected.isGroupDetected().booleanValue()) {
            if (this.group == null) {
                content.append(',');
            } else {
                content.append(this.group);
                content.append(',');
            }
        }
        content.append(this.getName());
        if (detected.isUnitsDetected().booleanValue()) {
            if (this.unit == null) {
                content.append(",-");
            } else {
                content.append(',');
                content.append(this.unit);
            }
        }
        if (detected.isNumeralDetected().booleanValue()) {
            content.append(",-,-,-,-");
        }
        content.append(',');
        content.append(Integer.toString(this.passed));
        content.append(',');
        content.append(Integer.toString(this.failed));
        return content.toString();
    }

    public int getPassed() {
        return this.passed;
    }

    public int getFailed() {
        return this.failed;
    }
}

