/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.bearychat;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import java.util.logging.Logger;
import jenkins.plugins.bearychat.BearyChatNotifier;
import jenkins.plugins.bearychat.BearyChatService;
import jenkins.plugins.bearychat.FineGrainedNotifier;
import jenkins.plugins.bearychat.Helper;
import jenkins.plugins.bearychat.MessageBuilder;

public class ActiveNotifier
implements FineGrainedNotifier {
    private static final Logger logger = Logger.getLogger(ActiveNotifier.class.getName());
    BuildListener listener;
    BearyChatNotifier notifier;

    public ActiveNotifier(BearyChatNotifier notifier, BuildListener listener) {
        this.notifier = notifier;
        this.listener = listener;
    }

    private BearyChatService getBearyChat(AbstractBuild build) {
        return this.notifier.newBearyChatService(build, this.listener);
    }

    @Override
    public void deleted(AbstractBuild build) {
    }

    @Override
    public void started(AbstractBuild build) {
        Result lastResult;
        MessageBuilder messageBuilder = new MessageBuilder(this.notifier, build);
        String color = "#008800";
        AbstractBuild previousBuild = null;
        try {
            previousBuild = build.getProject().getLastBuild().getPreviousBuild();
        }
        catch (NullPointerException e) {
            logger.info("get previous build failure");
        }
        catch (Exception e) {
            logger.info("get previous build failure");
            color = "#008800";
        }
        Result result = lastResult = previousBuild == null ? null : previousBuild.getResult();
        if (lastResult != null && lastResult == Result.FAILURE) {
            color = "#FF0000";
        }
        String title = messageBuilder.getStartedMessage();
        String fallback = messageBuilder.getStartedFallback();
        String text = messageBuilder.getStartedText();
        this.getBearyChat(build).publish(title, text, fallback, color);
    }

    @Override
    public void finalized(AbstractBuild r) {
    }

    private void notifyCompleted(AbstractBuild build) {
        MessageBuilder messageBuilder = new MessageBuilder(this.notifier, build);
        String color = Helper.getBuildColor(build);
        String title = messageBuilder.getCompletedMessage();
        String fallback = messageBuilder.getCompletedFallback();
        String text = messageBuilder.getCompletedText();
        this.getBearyChat(build).publish(title, text, fallback, color);
    }

    @Override
    public void completed(AbstractBuild build) {
        Result previousResult;
        AbstractProject project = build.getProject();
        Result result = build.getResult();
        AbstractBuild previousBuild = project.getLastBuild();
        do {
            AbstractBuild abstractBuild = previousBuild = previousBuild == null ? null : (AbstractBuild)previousBuild.getPreviousCompletedBuild();
        } while (previousBuild != null && previousBuild.getResult() == Result.ABORTED);
        Result result2 = previousResult = previousBuild != null ? previousBuild.getResult() : Result.SUCCESS;
        if (result == Result.ABORTED && this.notifier.isNotifyOnAborted()) {
            this.notifyCompleted(build);
            return;
        }
        if (result == Result.FAILURE && previousResult != Result.FAILURE && this.notifier.isNotifyOnFailure()) {
            this.notifyCompleted(build);
            return;
        }
        if (result == Result.FAILURE && previousResult == Result.FAILURE) {
            this.notifyCompleted(build);
            return;
        }
        if (result == Result.NOT_BUILT && this.notifier.isNotifyOnNotBuilt()) {
            this.notifyCompleted(build);
            return;
        }
        if (result == Result.SUCCESS && (previousResult == Result.FAILURE || previousResult == Result.UNSTABLE) && this.notifier.isNotifyOnBackToNormal()) {
            this.notifyCompleted(build);
            return;
        }
        if (result == Result.SUCCESS && this.notifier.isNotifyOnSuccess()) {
            this.notifyCompleted(build);
            return;
        }
        if (result == Result.UNSTABLE && this.notifier.isNotifyOnUnstable()) {
            this.notifyCompleted(build);
            return;
        }
    }
}

