/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.beakerbuilder;

import com.github.vjuranek.beaker4j.remote_model.BeakerTask;
import com.github.vjuranek.beaker4j.remote_model.TaskStatus;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskWatchdog
extends TimerTask {
    private static final Logger LOGGER = Logger.getLogger(TaskWatchdog.class.getName());
    public static final int DEFAULT_DELAY = Integer.getInteger(TaskWatchdog.class.getName() + ".DEFAULT_DELAY", 300) * 1000;
    public static final int DEFAULT_PERIOD = Integer.getInteger(TaskWatchdog.class.getName() + ".DEFAULT_PERIOD", 300) * 1000;
    private BeakerTask task;
    private TaskStatus status;
    private TaskStatus oldStatus;
    private boolean isFinished;

    public TaskWatchdog(BeakerTask task, TaskStatus status) {
        this.task = task;
        this.status = status;
        this.oldStatus = status;
        this.isFinished = false;
    }

    @Override
    public synchronized void run() {
        try {
            BeakerTask.TaskInfo info = this.task.getInfo();
            this.isFinished = info.isFinished();
            if (info.getState() != this.status) {
                this.oldStatus = this.status;
                this.status = info.getState();
                this.notifyAll();
            }
        }
        catch (Throwable ex) {
            LOGGER.log(Level.WARNING, "Unable to get task info", ex);
        }
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public TaskStatus getOldStatus() {
        return this.oldStatus;
    }

    public boolean isFinished() {
        return this.isFinished;
    }
}

