/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.beakerbuilder;

import com.github.vjuranek.beaker4j.beaker.BeakerServer;
import com.github.vjuranek.beaker4j.client.BeakerClient;
import com.github.vjuranek.beaker4j.remote_model.BeakerJob;
import com.github.vjuranek.beaker4j.remote_model.Identity;
import com.github.vjuranek.beaker4j.remote_model.TaskResult;
import com.github.vjuranek.beaker4j.remote_model.TaskStatus;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import net.sf.json.JSONObject;
import org.apache.xmlrpc.XmlRpcException;
import org.jenkinsci.plugins.beakerbuilder.BeakerBuildAction;
import org.jenkinsci.plugins.beakerbuilder.JobSource;
import org.jenkinsci.plugins.beakerbuilder.TaskWatchdog;
import org.jenkinsci.plugins.beakerbuilder.utils.ConsoleLogger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class BeakerBuilder
extends Builder {
    private final JobSource jobSource;
    private final boolean downloadFiles;
    private static final Logger LOGGER = Logger.getLogger(BeakerBuilder.class.getName());

    @DataBoundConstructor
    public BeakerBuilder(JobSource jobSource, boolean downloadFiles) {
        this.jobSource = jobSource;
        this.downloadFiles = downloadFiles;
        LOGGER.fine("download is " + downloadFiles);
    }

    public JobSource getJobSource() {
        return this.jobSource;
    }

    public boolean getDownloadFiles() {
        return this.downloadFiles;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        String jobXml;
        ConsoleLogger console = new ConsoleLogger(listener);
        try {
            jobXml = this.jobSource.getJobContent(build, listener);
        }
        catch (IOException ex) {
            BeakerBuilder.log(console, "[Beaker] ERROR: Cannot create job source file, cause " + ex.getMessage());
            return false;
        }
        BeakerJob job = this.scheduleJob(jobXml, build, console);
        if (job == null) {
            BeakerBuilder.log(console, "[Beaker] ERROR: Something went wrong when submitting job to Beaker, got NULL from Beaker, see console and Jenkins log for details");
            return false;
        }
        BeakerBuildAction bba = new BeakerBuildAction(job.getJobNumber(), this.getDescriptor().getBeakerURL());
        build.addAction((Action)bba);
        BeakerBuilder.log(console, "[Beaker] INFO: Job successfully submitted to Beaker, job ID is " + job.getJobId());
        if (!BeakerBuilder.waitForJobCompletion(job, console)) {
            return false;
        }
        this.setBuildResult(job, build, console);
        if (this.downloadFiles) {
            this.downloadJobFiles(job, build, console);
        }
        return true;
    }

    @CheckForNull
    private BeakerJob scheduleJob(String jobXml, AbstractBuild<?, ?> build, ConsoleLogger console) {
        LOGGER.fine("Job XML is: \n" + jobXml);
        BeakerJob job = null;
        try {
            BeakerClient client = this.getDescriptor().getBeakerClient();
            Identity identity = this.getDescriptor().getIdentity();
            if (client == null || identity == null) {
                BeakerBuilder.log(console, "[Beaker] ERROR: Beaker connection not configured properly");
                return null;
            }
            client.authenticate(identity);
            job = client.scheduleJob(jobXml);
        }
        catch (XmlRpcException e) {
            BeakerBuilder.log(console, "[Beaker] ERROR: Job scheduling has failed, reason: " + e.getMessage());
            LOGGER.log(Level.WARNING, "Beaker job scheduling has failed", e);
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean waitForJobCompletion(BeakerJob job, ConsoleLogger console) {
        TaskWatchdog watchdog = new TaskWatchdog(job.getBeakerTask(), TaskStatus.NEW);
        Timer timer = new Timer("Waiting for beaker job " + job.getJobId());
        timer.scheduleAtFixedRate((TimerTask)watchdog, TaskWatchdog.DEFAULT_DELAY, (long)TaskWatchdog.DEFAULT_PERIOD);
        TaskWatchdog taskWatchdog = watchdog;
        synchronized (taskWatchdog) {
            while (!watchdog.isFinished()) {
                try {
                    watchdog.wait();
                }
                catch (InterruptedException e) {
                    timer.cancel();
                    BeakerBuilder.log(console, "[Beaker] INFO: Job aborted");
                    return false;
                }
                BeakerBuilder.log(console, "[Beaker] INFO: Job has changed state from " + watchdog.getOldStatus() + " state to state " + watchdog.getStatus());
            }
        }
        timer.cancel();
        BeakerBuilder.log(console, "[Beaker] INFO: Job finished");
        return true;
    }

    private void setBuildResult(BeakerJob job, AbstractBuild<?, ?> build, ConsoleLogger console) {
        TaskResult result = null;
        try {
            result = job.getBeakerTask().getInfo().getResult();
        }
        catch (XmlRpcException e) {
            LOGGER.log(Level.INFO, "Beaker error: cannot get result from Beaker ", e);
            BeakerBuilder.log(console, "[Beaker] ERROR: Cannot get job result from Beaker, check Jenkins logs for more details");
        }
        if (result == null) {
            BeakerBuilder.log(console, "[Beaker] ERROR: Cannot get job result from Beaker, got NULL");
            build.setResult(Result.FAILURE);
        }
        switch (result) {
            case PANIC: 
            case FAIL: {
                build.setResult(Result.FAILURE);
                break;
            }
            case WARN: {
                build.setResult(Result.UNSTABLE);
                break;
            }
            case PASS: {
                build.setResult(Result.SUCCESS);
                break;
            }
            default: {
                build.setResult(Result.UNSTABLE);
                BeakerBuilder.log(console, "[Beaker] INFO: Unknow job result, setting build result to UNSTABLE");
            }
        }
    }

    private void downloadJobFiles(BeakerJob job, AbstractBuild<?, ?> build, ConsoleLogger console) {
        FilePath beakerFileDir = new FilePath(build.getWorkspace(), "beaker/" + job.getJobId().replaceAll(":", "_"));
        try {
            beakerFileDir.mkdirs();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Beaker error: cannot create dir for Beaker files", e);
            BeakerBuilder.log(console, "[Beaker] ERROR: Cannot create dir for Beaker files: " + e.getMessage());
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.INFO, "Beaker error: creating dir for Beaker files interrupted", e);
            BeakerBuilder.log(console, "[Beaker] ERROR: Creating dir for Beaker files interrupted: " + e.getMessage());
        }
        BeakerBuilder.log(console, "[Beaker] INFO: Trying to download job file into " + beakerFileDir.getRemote());
        try {
            ArrayList files = job.getFiles();
            for (Map f : files) {
                FilePath fp = new FilePath(beakerFileDir, (String)f.get("filename"));
                BeakerBuilder.log(console, "[Beaker] INFO: Downloading " + (String)f.get("filename") + " into " + fp.getRemote());
                try {
                    fp.copyFrom(new URL((String)f.get("url")));
                }
                catch (IOException e) {
                    BeakerBuilder.log(console, "[Beaker] ERROR: Something went wrong when downloading " + (String)f.get("filename") + ", check Jenkins log for details.");
                    LOGGER.log(Level.INFO, "Beaker error: cannot donwload file " + (String)f.get("filename"), e);
                }
                catch (InterruptedException e) {
                    BeakerBuilder.log(console, "[Beaker] ERROR: Something went wrong when downloading " + (String)f.get("filename") + ", check Jenkins log for details.");
                    LOGGER.log(Level.INFO, "Beaker error: cannot donwload file " + (String)f.get("filename"), e);
                }
            }
        }
        catch (XmlRpcException e) {
            LOGGER.log(Level.INFO, "Beaker error: cannot download files from Beaker ", e);
            BeakerBuilder.log(console, "[Beaker] ERROR: Cannot download job files from Beaker: " + e.getMessage());
        }
    }

    private static void log(ConsoleLogger console, String message) {
        console.logAnnot(message);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String beakerURL;
        private String login;
        private String password;
        private transient BeakerClient beakerClient;
        private transient Identity identity;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute Beaker task";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            if (this.beakerURL.endsWith("/")) {
                this.beakerURL = this.beakerURL.substring(0, this.beakerURL.length() - 1);
            }
            this.save();
            this.beakerClient = null;
            this.identity = null;
            return super.configure(req, formData);
        }

        @Restricted(value={DoNotUse.class})
        public void setBeakerURL(String beakerURL) {
            this.beakerURL = beakerURL;
        }

        @Restricted(value={DoNotUse.class})
        public void setLogin(String login) {
            this.login = login;
        }

        @Restricted(value={DoNotUse.class})
        public void setPassword(String password) {
            this.password = password;
        }

        private void setupClient() {
            if (this.beakerClient != null) {
                return;
            }
            if (this.beakerURL != null && !"".equals(this.beakerURL.trim())) {
                this.beakerClient = BeakerServer.getXmlRpcClient((String)this.beakerURL);
                try {
                    this.identity = this.beakerClient.authenticate(new Identity(this.login, this.password));
                }
                catch (XmlRpcException e) {
                    this.beakerClient = null;
                    LOGGER.log(Level.WARNING, "Unable to create beaker client", e);
                }
            }
        }

        @Restricted(value={DoNotUse.class})
        public FormValidation doTestConnection(@QueryParameter(value="beakerURL") String beakerURL, @QueryParameter(value="login") String login, @QueryParameter(value="password") String password) {
            LOGGER.fine("Trying to get client for " + beakerURL);
            BeakerClient bc = BeakerServer.getXmlRpcClient((String)beakerURL);
            try {
                Identity ident = bc.authenticate(new Identity(login, password));
                return FormValidation.ok((String)("Connected as " + ident.whoAmI()));
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)("Cannot connect to " + beakerURL));
            }
        }

        public String getBeakerURL() {
            return this.beakerURL;
        }

        public String getLogin() {
            return this.login;
        }

        public String getPassword() {
            return this.password;
        }

        @CheckForNull
        public BeakerClient getBeakerClient() {
            this.setupClient();
            return this.beakerClient;
        }

        @CheckForNull
        public Identity getIdentity() {
            this.setupClient();
            return this.identity;
        }
    }
}

