/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bazaar;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.model.listeners.SCMListener;
import hudson.plugins.bazaar.BazaarChangeSet;
import hudson.plugins.bazaar.BazaarSCM;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.ChangeLogSet;
import hudson.util.ArgumentListBuilder;
import hudson.util.MultipartFormDataParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarTagAction
extends AbstractScmTagAction
implements Describable<BazaarTagAction> {
    private final List<BazaarRevision> revisions = new ArrayList<BazaarRevision>();
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    protected BazaarTagAction(AbstractBuild<?, ?> build) {
        super(build);
        new BazaarTagListener().register();
    }

    public String getIconFileName() {
        if (!this.isTagged() && !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        return "Tags";
    }

    public boolean isTagged() {
        if (!this.hasRevisions()) {
            return false;
        }
        for (BazaarRevision revision : this.revisions) {
            if (!revision.isTagged()) continue;
            return true;
        }
        return false;
    }

    public List<BazaarRevision> getRevisions() {
        return this.revisions;
    }

    public boolean hasRevisions() {
        return this.revisions != null && !this.revisions.isEmpty();
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
        HashMap<BazaarRevision, String> newTags = new HashMap<BazaarRevision, String>();
        int i = -1;
        for (BazaarRevision e : this.revisions) {
            if (parser.get("tag" + ++i) == null || parser.get("name" + i).isEmpty()) continue;
            newTags.put(e, parser.get("name" + i));
        }
        new TagWorkerThread(newTags, parser.get("force") != null).start();
        rsp.sendRedirect(".");
    }

    public synchronized void doDelete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        if (req.getParameter("tag") != null) {
            BazaarRevision revision = null;
            String tag = null;
            for (BazaarRevision e : this.revisions) {
                if (!e.getRevId().equals(req.getParameter("revid"))) continue;
                revision = e;
                tag = req.getParameter("tag");
            }
            new TagDeletionWorkerThread(revision, tag).start();
        }
        rsp.sendRedirect(".");
    }

    public Descriptor<BazaarTagAction> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<BazaarTagAction> {
        protected DescriptorImpl() {
            super(BazaarTagAction.class);
        }

        public String getDisplayName() {
            return null;
        }
    }

    private final class TagDeletionWorkerThread
    extends TaskThread {
        private final BazaarRevision revision;
        private final String tag;

        public TagDeletionWorkerThread(BazaarRevision revision, String tag) {
            super((TaskAction)BazaarTagAction.this, TaskThread.ListenerAndText.forMemory());
            this.revision = revision;
            this.tag = tag;
        }

        protected void perform(TaskListener listener) {
            try {
                PrintStream logger = listener.getLogger();
                Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
                BazaarSCM bazaarSCM = (BazaarSCM)BazaarTagAction.this.getBuild().getProject().getScm();
                logger.println("Removing tag " + this.tag);
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add(new String[]{bazaarSCM.getDescriptor().getBzrExe(), "tag"});
                args.add(new String[]{"-r", this.revision.getRevId()});
                args.add(new String[]{"-d", bazaarSCM.getSource()});
                args.add("--delete");
                args.add(this.tag);
                if (launcher.launch().cmds(args).envs((Map)BazaarTagAction.this.build.getEnvironment(listener)).stdout((OutputStream)listener.getLogger()).join() != 0) {
                    listener.error("Failed to delete tag");
                } else {
                    this.revision.removeTag(this.tag);
                }
                BazaarTagAction.this.getBuild().save();
            }
            catch (Throwable e) {
                e.printStackTrace(listener.fatalError(e.getMessage()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TagWorkerThread
    extends TaskThread {
        private final Map<BazaarRevision, String> tagSet;
        private final boolean force;

        public TagWorkerThread(Map<BazaarRevision, String> tagSet, boolean force) {
            super((TaskAction)BazaarTagAction.this, TaskThread.ListenerAndText.forMemory());
            this.tagSet = tagSet;
            this.force = force;
        }

        protected void perform(TaskListener listener) {
            try {
                PrintStream logger = listener.getLogger();
                Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
                BazaarSCM bazaarSCM = (BazaarSCM)BazaarTagAction.this.getBuild().getProject().getScm();
                for (Map.Entry<BazaarRevision, String> e : this.tagSet.entrySet()) {
                    logger.println("Tagging " + e.getKey() + " to " + e.getValue());
                    ArgumentListBuilder args = new ArgumentListBuilder();
                    args.add(new String[]{bazaarSCM.getDescriptor().getBzrExe(), "tag"});
                    args.add(new String[]{"-r", e.getKey().getRevId()});
                    args.add(new String[]{"-d", bazaarSCM.getSource()});
                    if (this.force) {
                        args.add("--force");
                    }
                    args.add(e.getValue());
                    if (launcher.launch().cmds(args).envs((Map)BazaarTagAction.this.build.getEnvironment(listener)).stdout((OutputStream)listener.getLogger()).join() != 0) {
                        listener.error("Failed to tag");
                        continue;
                    }
                    e.getKey().addTag(e.getValue());
                }
                BazaarTagAction.this.getBuild().save();
            }
            catch (Throwable e) {
                e.printStackTrace(listener.fatalError(e.getMessage()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BazaarTagListener
    extends SCMListener {
        private BazaarTagListener() {
        }

        public void onChangeLogParsed(AbstractBuild<?, ?> build, BuildListener listener, ChangeLogSet<?> changelog) throws Exception {
            for (ChangeLogSet.Entry changelogEntry : changelog) {
                if (!(changelogEntry instanceof BazaarChangeSet)) continue;
                BazaarChangeSet changeset = (BazaarChangeSet)changelogEntry;
                BazaarTagAction.this.revisions.add(new BazaarRevision(changeset.getRevid(), changeset.getRevno(), changeset.getTags()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BazaarRevision
    implements Serializable {
        private String revId;
        private String revNo;
        private List<String> tags = new ArrayList<String>();

        public BazaarRevision(String revId, String revNo, List<String> tags) {
            this.revId = revId;
            this.revNo = revNo;
            this.tags = tags;
        }

        public String getRevId() {
            return this.revId;
        }

        public String getRevNo() {
            return this.revNo;
        }

        public List<String> getTags() {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            return this.tags;
        }

        public void addTag(String tag) {
            this.getTags().add(tag);
        }

        public void removeTag(String tag) {
            this.getTags().remove(tag);
        }

        public boolean isTagged() {
            return !this.getTags().isEmpty();
        }

        public String toString() {
            return this.revNo + " (revid: " + this.revId + ")";
        }
    }
}

