/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bazaar;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.bazaar.BazaarChangeLogParser;
import hudson.plugins.bazaar.BazaarRepositoryBrowser;
import hudson.plugins.bazaar.BazaarRevisionState;
import hudson.plugins.bazaar.BazaarTagAction;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.framework.io.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarSCM
extends SCM
implements Serializable {
    private final String source;
    private final boolean cleantree;
    private final BazaarRepositoryBrowser browser;
    private final boolean checkout;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(BazaarSCM.class.getName());

    @DataBoundConstructor
    public BazaarSCM(String source, boolean cleantree, BazaarRepositoryBrowser browser, boolean checkout) {
        this.source = source;
        this.cleantree = cleantree;
        this.browser = browser;
        this.checkout = checkout;
    }

    public BazaarSCM(String source, boolean cleantree, BazaarRepositoryBrowser browser) {
        this(source, cleantree, browser, false);
    }

    public String getSource() {
        return this.source;
    }

    public boolean isCleanTree() {
        return this.cleantree;
    }

    public boolean isCheckout() {
        return this.checkout;
    }

    @Exported
    public BazaarRepositoryBrowser getBrowser() {
        return this.browser;
    }

    private BazaarRevisionState getRevisionState(Launcher launcher, TaskListener listener, String root) throws InterruptedException {
        BazaarRevisionState rev = null;
        try {
            if (launcher == null) {
                launcher = new Launcher.LocalLauncher(listener);
            }
            PrintStream output = listener.getLogger();
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            ByteArrayOutputStream stderr = new ByteArrayOutputStream();
            String bzr_cmd = this.getDescriptor().getBzrExe();
            Launcher.ProcStarter starter = launcher.launch();
            starter = starter.cmds(new String[]{bzr_cmd, "revision-info", "-d", root});
            starter = starter.stdout((OutputStream)stdout);
            starter = starter.stderr((OutputStream)stderr);
            int ret = starter.join();
            String info_output = "bzr revision-info -d " + root + " returned " + ret + ". Command output: \"" + stdout.toString() + "\" stderr: \"" + stderr.toString() + "\"";
            if (ret != 0) {
                logger.warning(info_output);
            } else {
                String[] infos = stdout.toString().trim().split("\\s");
                if (infos.length == 2) {
                    rev = new BazaarRevisionState(infos[0], infos[1]);
                } else {
                    logger.log(Level.WARNING, "Issue splitting: {0}", stdout.toString().trim());
                }
            }
            output.printf("info result: %s\n", info_output);
        }
        catch (IOException e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            logger.log(Level.WARNING, "Failed to poll repository: ", e);
        }
        if (rev == null) {
            logger.log(Level.WARNING, "Failed to get revision state for: {0}", root);
        }
        return rev;
    }

    private void getLog(Launcher launcher, FilePath workspace, BazaarRevisionState oldRevisionState, BazaarRevisionState newRevisionState, File changeLog) throws InterruptedException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String version = "revid:" + oldRevisionState.getRevId() + "..revid:" + newRevisionState.getRevId();
            int ret = launcher.launch().cmds(new String[]{this.getDescriptor().getBzrExe(), "log", "-v", "-r", version, "--long", "--show-ids"}).envs(EnvVars.masterEnvVars).stdout((OutputStream)baos).pwd(workspace).join();
            if (ret != 0) {
                logger.log(Level.WARNING, "bzr log -v -r returned {0}", ret);
            } else {
                FileOutputStream fos = new FileOutputStream(changeLog);
                fos.write(baos.toByteArray());
                fos.close();
            }
        }
        catch (IOException e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            logger.log(Level.WARNING, "Failed to poll repository: ", e);
        }
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        PollingResult.Change change;
        PrintStream output = listener.getLogger();
        output.printf("Getting current remote revision...", new Object[0]);
        BazaarRevisionState remote = this.getRevisionState(launcher, listener, this.source);
        output.println((Object)remote);
        output.printf("Baseline is %s.\n", baseline);
        if (remote == null) {
            output.printf("Failed to get current remote revision, assuming no change.\n", new Object[0]);
            change = PollingResult.Change.NONE;
        } else {
            change = baseline == SCMRevisionState.NONE || baseline.getClass() != BazaarRevisionState.class || !remote.equals(baseline) ? PollingResult.Change.SIGNIFICANT : PollingResult.Change.NONE;
        }
        return new PollingResult(baseline, (SCMRevisionState)remote, change);
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        PrintStream output = listener.getLogger();
        output.println("Getting local revision...");
        BazaarRevisionState local = this.getRevisionState(launcher, listener, build.getWorkspace().getRemote());
        output.println((Object)local);
        return local;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean canUpdate = (Boolean)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
            private static final long serialVersionUID = 1L;

            public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
                File file = new File(ws, ".bzr");
                return file.exists();
            }
        });
        boolean result = true;
        result = canUpdate ? this.update(this.cleantree, build, launcher, workspace, listener, changelogFile) : this.clone(build, launcher, workspace, listener, changelogFile);
        build.addAction((Action)new BazaarTagAction(build));
        return result;
    }

    private boolean update(boolean cleantree, AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException, IOException {
        BazaarRevisionState oldRevisionState = this.getRevisionState(launcher, (TaskListener)listener, workspace.getRemote());
        boolean hasProblemOccured = false;
        if (cleantree) {
            this.cleantree(build, launcher, workspace, listener);
        }
        boolean bl = hasProblemOccured = !this.pull(build, launcher, workspace, listener);
        if (hasProblemOccured) {
            return false;
        }
        BazaarRevisionState newRevisionState = this.getRevisionState(launcher, (TaskListener)listener, workspace.getRemote());
        if (oldRevisionState != null && newRevisionState != null) {
            this.getLog(launcher, workspace, oldRevisionState, newRevisionState, changelogFile);
        }
        return true;
    }

    private boolean revert(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) throws InterruptedException {
        block4: {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{this.getDescriptor().getBzrExe(), "revert"});
            try {
                if (launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((OutputStream)listener.getLogger()).pwd(workspace).join() == 0) break block4;
                listener.error("Failed to run bzr revert");
                try {
                    listener.getLogger().println("Since BZR itself isn't crash safe, we'll clean the workspace so that on the next try we'll do a clean pull...");
                    workspace.deleteRecursive();
                }
                catch (IOException e) {
                    e.printStackTrace(listener.error("Failed to clean the workspace"));
                    return false;
                }
                return false;
            }
            catch (IOException e) {
                listener.error("Failed to run bzr revert");
                return false;
            }
        }
        return true;
    }

    private boolean cleantree(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) throws InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getDescriptor().getBzrExe(), "clean-tree", "--quiet", "--ignored", "--unknown", "--detritus", "--force"});
        try {
            if (launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((OutputStream)listener.getLogger()).pwd(workspace).join() != 0) {
                listener.error("Failed to run bzr clean-tree");
                return false;
            }
        }
        catch (IOException e) {
            listener.error("Failed to run bzr clean-tree");
            return false;
        }
        return true;
    }

    private boolean pull(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) throws InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        String verb = null;
        boolean result = true;
        if (this.isCheckout()) {
            block11: {
                ArgumentListBuilder update_args = new ArgumentListBuilder();
                update_args.add(new String[]{this.getDescriptor().getBzrExe(), "update"});
                try {
                    if (launcher.launch().cmds(update_args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((OutputStream)listener.getLogger()).pwd(workspace).join() == 0) break block11;
                    listener.error("Failed to bzr update");
                    try {
                        listener.getLogger().println("Since BZR itself isn't crash safe, we'll clean the workspace so that on the next try we'll do a clean pull...");
                        workspace.deleteRecursive();
                    }
                    catch (IOException e) {
                        e.printStackTrace(listener.error("Failed to clean the workspace"));
                        return false;
                    }
                    return false;
                }
                catch (IOException e) {
                    listener.error("Failed to bzr update");
                    return false;
                }
            }
            verb = "switch";
            args.add(new String[]{this.getDescriptor().getBzrExe(), verb, this.source});
        } else {
            verb = "pull";
            args.add(new String[]{this.getDescriptor().getBzrExe(), verb, "--overwrite", this.source});
        }
        try {
            if (launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((OutputStream)listener.getLogger()).pwd(workspace).join() != 0) {
                listener.error("Failed to " + verb);
                try {
                    listener.getLogger().println("Since BZR itself isn't crash safe, we'll clean the workspace so that on the next try we'll do a clean pull...");
                    workspace.deleteRecursive();
                }
                catch (IOException e) {
                    e.printStackTrace(listener.error("Failed to clean the workspace"));
                    return false;
                }
                return false;
            }
            result = this.revert(build, launcher, workspace, listener);
        }
        catch (IOException e) {
            listener.error("Failed to " + verb);
            return false;
        }
        return result;
    }

    private boolean clone(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException {
        if (!this.branch(build, launcher, workspace, listener)) {
            return false;
        }
        return this.createEmptyChangeLog(changelogFile, listener, "changelog");
    }

    private boolean branch(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) throws InterruptedException {
        try {
            listener.getLogger().println("Cleaning workspace...");
            workspace.deleteRecursive();
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clean the workspace"));
            return false;
        }
        String verb = this.isCheckout() ? "checkout" : "branch";
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getDescriptor().getBzrExe(), verb});
        if (this.isCheckout()) {
            args.add("--lightweight");
        }
        args.add(new String[]{this.source, workspace.getRemote()});
        try {
            if (launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((OutputStream)listener.getLogger()).join() != 0) {
                listener.error("Failed to " + verb + " " + this.source);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to " + verb + " " + this.source));
            return false;
        }
        return true;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        BazaarRevisionState revisionState = (BazaarRevisionState)build.getAction(SCMRevisionState.class);
        if (revisionState != null) {
            if (revisionState.getRevNo() != null) {
                env.put("BZR_REVISION", revisionState.getRevNo());
            }
            if (revisionState.getRevId() != null) {
                env.put("BZR_REVID", revisionState.getRevId());
            }
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new BazaarChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<BazaarSCM> {
        @Extension
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private String bzrExe;
        private transient String version;
        private static final Pattern UUID_VERSION_STRING = Pattern.compile("\\(version ([0-9a-f]+)");

        private DescriptorImpl() {
            super(BazaarSCM.class, BazaarRepositoryBrowser.class);
            this.load();
        }

        public String getDisplayName() {
            return "Bazaar";
        }

        public String getBzrExe() {
            return this.bzrExe == null ? "bzr" : this.bzrExe;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            BazaarSCM scm = (BazaarSCM)req.bindJSON(BazaarSCM.class, formData);
            return scm;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.bzrExe = req.getParameter("bazaar.bzrExe");
            this.version = null;
            this.save();
            return true;
        }

        public FormValidation doBzrExeCheck(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateExecutable((String)value, (FormValidation.FileValidator)new FormValidation.FileValidator(){

                public FormValidation validate(File exe) {
                    try {
                        ByteBuffer baos = new ByteBuffer();
                        if (Hudson.getInstance().createLauncher(TaskListener.NULL).launch().cmds(new String[]{DescriptorImpl.this.getBzrExe(), "--version"}).stdout((OutputStream)baos).join() == 0) {
                            return FormValidation.ok();
                        }
                        return FormValidation.warning((String)"Could not locate the executable in path");
                    }
                    catch (IOException e) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return FormValidation.error((String)"Unable to check bazaar version");
                }
            });
        }
    }
}

