/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.plugins.batch_task.BatchTask;
import hudson.plugins.batch_task.BatchTaskProperty;
import hudson.plugins.batch_task.DownstreamTasksAction;
import hudson.plugins.batch_task.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BatchTaskInvoker
extends Notifier {
    private final Config[] configs;
    private Result threshold;

    private Object readResolve() {
        if (this.threshold == null) {
            this.threshold = Result.UNSTABLE;
        }
        return this;
    }

    @DataBoundConstructor
    public BatchTaskInvoker(Config[] configs, boolean evenIfUnstable) {
        this(configs, evenIfUnstable ? Result.UNSTABLE : Result.SUCCESS);
    }

    public BatchTaskInvoker(Config[] configs, Result threshold) {
        this.configs = configs;
        this.threshold = threshold;
    }

    public List<Config> getConfigs() {
        return Collections.unmodifiableList(Arrays.asList(this.configs));
    }

    public Result getThreshold() {
        return this.threshold;
    }

    public boolean isEvenIfUnstable() {
        return this.threshold.isWorseOrEqualTo(Result.UNSTABLE);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        HashSet<String> seenJobs = new HashSet<String>();
        if (build.getResult().isBetterOrEqualTo(this.threshold)) {
            for (Config config : this.configs) {
                config.invoke(build, listener, seenJobs);
            }
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singletonList(new DownstreamTasksAction(this));
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.BatchTaskInvoker_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }

    public static final class Config
    extends AbstractDescribableImpl<Config> {
        public final String project;
        public final String task;

        @DataBoundConstructor
        public Config(String project, String task) {
            this.project = project;
            this.task = task;
        }

        public BatchTaskProperty resolveProperty(ItemGroup context) {
            AbstractProject p = (AbstractProject)Jenkins.getInstance().getItem(this.project, context, AbstractProject.class);
            if (p == null) {
                return null;
            }
            return (BatchTaskProperty)p.getProperty(BatchTaskProperty.class);
        }

        public BatchTask resolve(ItemGroup context) {
            BatchTaskProperty bp = this.resolveProperty(context);
            if (bp == null) {
                return null;
            }
            return bp.getTask(this.task);
        }

        public BatchTask resolve() {
            return this.resolve((ItemGroup)Jenkins.getInstance());
        }

        public BatchTaskProperty resolveProperty() {
            return this.resolveProperty(null);
        }

        public boolean invoke(AbstractBuild<?, ?> build, BuildListener listener, HashSet<String> seenJobs) {
            PrintStream logger = listener.getLogger();
            AbstractProject p = (AbstractProject)Jenkins.getInstance().getItem(this.project, (Item)build.getProject(), AbstractProject.class);
            if (p == null) {
                listener.error(Messages.BatchTaskInvoker_NoSuchProject(this.project));
                return false;
            }
            BatchTaskProperty bp = (BatchTaskProperty)p.getProperty(BatchTaskProperty.class);
            if (bp == null) {
                listener.error(Messages.BatchTaskInvoker_NoBatchTaskExists(this.task));
                return false;
            }
            BatchTask taskObj = bp.getTask(this.task);
            if (taskObj == null) {
                listener.error(Messages.BatchTaskInvoker_NoSuchTask(this.task, bp.findNearestTask((String)this.task).name));
                return false;
            }
            String buildNum = "";
            if (!seenJobs.contains(this.project)) {
                buildNum = " #" + taskObj.getNextBuildNumber();
                seenJobs.add(this.project);
            }
            logger.println(Messages.BatchTaskInvoker_Invoking(this.project, this.task, buildNum));
            Jenkins.getInstance().getQueue().schedule((Queue.Task)taskObj, 0, new Action[]{new CauseAction((Cause)new Cause.UpstreamCause(build))});
            return true;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<Config> {
            public String getDisplayName() {
                return "";
            }

            public ListBoxModel doFillTaskItems(@QueryParameter String project, @AncestorInPath AbstractProject context) {
                BatchTaskProperty bp;
                ListBoxModel r = new ListBoxModel();
                AbstractProject p = (AbstractProject)Jenkins.getInstance().getItem(project, (Item)context, AbstractProject.class);
                if (p != null && (bp = (BatchTaskProperty)p.getProperty(BatchTaskProperty.class)) != null) {
                    for (BatchTask task : bp.getTasks()) {
                        r.add(task.getDisplayName(), task.getName());
                    }
                }
                return r;
            }

            @Restricted(value={NoExternalUse.class})
            public FormValidation doCheckProject(@QueryParameter String project) {
                Item item;
                if (project.startsWith("/")) {
                    return FormValidation.warning((String)Messages.BatchTaskInvoker_ForwardSlash());
                }
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins != null && (item = jenkins.getItemByFullName(project)) == null) {
                    return FormValidation.warning((String)Messages.BatchTaskInvoker_NoSuchProject(project));
                }
                return FormValidation.ok();
            }

            @Restricted(value={NoExternalUse.class})
            public FormValidation doCheckTask(@QueryParameter String project, @QueryParameter String task) {
                if (!project.isEmpty() && task.isEmpty()) {
                    return FormValidation.warning((String)Messages.BatchTaskInvoker_NoBatchTaskExists(task));
                }
                return FormValidation.ok();
            }
        }
    }
}

