/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.backlog.BacklogProjectProperty;
import hudson.plugins.backlog.Messages;
import hudson.plugins.backlog.webdav.WebdavClient;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BacklogWebdavPublisher
extends Notifier {
    private static final Log LOG = LogFactory.getLog(BacklogWebdavPublisher.class);
    public final String sourceFiles;
    public final String remoteDirectory;
    public final String removePrefix;
    public final boolean remoteDirectorySDF;
    public final boolean deleteDirectoryBeforePublish;

    @DataBoundConstructor
    public BacklogWebdavPublisher(String sourceFiles, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean deleteDirectoryBeforePublish) {
        this.sourceFiles = sourceFiles;
        this.remoteDirectory = remoteDirectory;
        this.removePrefix = removePrefix;
        this.remoteDirectorySDF = remoteDirectorySDF;
        this.deleteDirectoryBeforePublish = deleteDirectoryBeforePublish;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().isWorseThan(Result.UNSTABLE)) {
            LOG.info((Object)"WebDAV Publisher is not performed because build is not success or unstable.");
            return true;
        }
        BacklogProjectProperty bpp = (BacklogProjectProperty)build.getProject().getProperty(BacklogProjectProperty.class);
        if (bpp == null || bpp.getSpaceURL() == null || bpp.getProject() == null || bpp.userId.isEmpty() || bpp.getPassword().isEmpty()) {
            LOG.warn((Object)"BacklogProjectProperty settings is required when publishing to files.");
            return true;
        }
        listener.getLogger().println(Messages.BacklogWebdavPublisher_StartPublish());
        WebdavClient client = new WebdavClient(bpp.getSpaceURL() + "dav/" + bpp.getProject() + "/", bpp.userId, bpp.getPassword());
        String prefix = build.getEnvironment((TaskListener)listener).expand(this.removePrefix);
        client.setRemovePrefix(prefix);
        String directory = this.getFormattedRemoteDirectory(build, listener, this.remoteDirectory);
        LOG.debug((Object)("remote directory : " + directory));
        if (this.deleteDirectoryBeforePublish && !directory.isEmpty() && client.delete(directory)) {
            LOG.debug((Object)("delete remote directory : " + directory));
        }
        String sources = build.getEnvironment((TaskListener)listener).expand(this.sourceFiles);
        FilePath[] filePaths = build.getWorkspace().list(sources);
        if (filePaths.length == 0) {
            listener.getLogger().println(Messages.BacklogWebdavPublisher_NoMatchFound(this.sourceFiles));
            return true;
        }
        for (FilePath filePath : filePaths) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("put file : " + filePath));
            }
            client.putWithParent(filePath, directory, build.getWorkspace());
        }
        return true;
    }

    private String getFormattedRemoteDirectory(AbstractBuild<?, ?> build, BuildListener listener, String remoteDirectory) throws IOException, InterruptedException {
        if (this.remoteDirectorySDF) {
            String expandRemoteDirectory = build.getEnvironment((TaskListener)listener).expand(remoteDirectory);
            SimpleDateFormat sdf = new SimpleDateFormat(expandRemoteDirectory);
            return sdf.format(build.getTime());
        }
        return remoteDirectory;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.BacklogWebdavPublisher_DisplayName();
        }

        public FormValidation doCheckSourceFiles(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }
    }
}

