/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.backlog.BacklogLinkAction;
import hudson.plugins.backlog.Messages;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public final class BacklogProjectProperty
extends JobProperty<Job<?, ?>> {
    public final String url;
    public final String userId;
    private final Secret password;
    private final Secret apiKey;

    @DataBoundConstructor
    public BacklogProjectProperty(String url, String userId, String password, String apiKey) {
        this.url = StringUtils.isNotEmpty((String)url) ? (url.contains("/projects/") ? url : (url.endsWith("/") ? url : url + '/')) : null;
        this.userId = userId;
        this.password = Secret.fromString((String)password);
        this.apiKey = Secret.fromString((String)apiKey);
    }

    public String getPassword() {
        return Secret.toString((Secret)this.password);
    }

    public String getApiKey() {
        return Secret.toString((Secret)this.apiKey);
    }

    public String getSpaceURL() {
        if (this.url == null) {
            return null;
        }
        if (this.url.contains("/projects/")) {
            return this.url.substring(0, this.url.indexOf("/projects/") + 1);
        }
        return this.url;
    }

    public String getProject() {
        if (this.url == null) {
            return null;
        }
        if (!this.url.contains("/projects/")) {
            return null;
        }
        return this.url.substring(this.url.indexOf("/projects/") + "/projects/".length());
    }

    public Action getJobAction(Job<?, ?> job) {
        return new BacklogLinkAction(this);
    }

    @Extension
    public static class Factory
    extends TransientActionFactory<WorkflowJob> {
        public Class<WorkflowJob> type() {
            return WorkflowJob.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull WorkflowJob target) {
            if (target.getParent() instanceof MultiBranchProject) {
                return Collections.emptySet();
            }
            return Collections.singleton(new BacklogLinkAction((BacklogProjectProperty)target.getProperty(BacklogProjectProperty.class)));
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(BacklogProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return ParameterizedJobMixIn.ParameterizedJob.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return Messages.BacklogProjectProperty_DisplayName();
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)Messages.BacklogSecurityRealm_Url_Error());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUserId(@QueryParameter String userId) {
            if (StringUtils.isEmpty((String)userId) || userId.matches("[A-Za-z0-9-_@.]+")) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.BacklogProjectProperty_UserId_Error());
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.isEmpty()) {
                return null;
            }
            BacklogProjectProperty bpp = (BacklogProjectProperty)((Object)req.bindJSON(BacklogProjectProperty.class, formData.getJSONObject("backlog")));
            return bpp;
        }
    }
}

