/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class MsiTokenCredentials
extends AzureTokenCredentials {
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private Map<String, Token> tokens = new HashMap<String, Token>();
    private volatile String tenantId;
    private int msiPort;

    public MsiTokenCredentials(int msiPort, AzureEnvironment environment) {
        super(environment, null);
        this.msiPort = msiPort;
    }

    public synchronized String getToken(String resource) throws IOException {
        Token authenticationResult = this.tokens.get(resource);
        if (authenticationResult == null || authenticationResult.isExpired()) {
            authenticationResult = this.acquireAccessToken(resource);
            this.tokens.put(resource, authenticationResult);
        }
        return authenticationResult.getAccessToken();
    }

    private Token acquireAccessToken(String resource) throws IOException {
        FormBody body = new FormBody.Builder().add("resource", resource).build();
        Request request = new Request.Builder().addHeader("Metadata", "true").url("http://localhost:" + this.msiPort + "/oauth2/token").post((RequestBody)body).build();
        Response response = new OkHttpClient().newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new RuntimeException("http response: " + response.code() + " " + response.message());
        }
        String responseBody = response.body().string();
        return this.parseToken(responseBody);
    }

    private Token parseToken(String responseBody) throws IOException {
        Token token = (Token)this.mapper.readValue(responseBody, Token.class);
        if (token == null) {
            throw new RuntimeException("Failed to parse the response.");
        }
        if (StringUtils.isEmpty((CharSequence)token.getAccessToken())) {
            throw new RuntimeException("The access token isn't included in the response.");
        }
        if (StringUtils.isEmpty((CharSequence)this.tenantId)) {
            String rawJwt = token.getAccessToken();
            DecodedJWT jwt = JWT.decode((String)rawJwt);
            this.tenantId = jwt.getClaim("tid").asString();
        }
        return token;
    }

    public String domain() {
        return this.tenantId;
    }

    public static final class Token {
        private String resource;
        @JsonProperty(value="expires_in")
        private long expiresIn;
        @JsonProperty(value="expires_on")
        private long expiresOn;
        @JsonProperty(value="access_token")
        private String accessToken;
        @JsonProperty(value="refresh_token")
        private String refreshToken;
        @JsonProperty(value="token_type")
        private String tokenType;

        public Token() {
        }

        public Token(String resource, long expiresIn, long expiresOn, String accessToken, String refreshToken, String tokenType) {
            this.resource = resource;
            this.expiresIn = expiresIn;
            this.expiresOn = expiresOn;
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.tokenType = tokenType;
        }

        public String getResource() {
            return this.resource;
        }

        public long getExpiresIn() {
            return this.expiresIn;
        }

        public long getExpiresOn() {
            return this.expiresOn;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public void setExpiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
        }

        public void setExpiresOn(long expiresOn) {
            this.expiresOn = expiresOn;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        boolean isExpired() {
            long now = TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            return this.expiresOn < now;
        }
    }
}

