/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.util;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.resources.Provider;
import com.microsoft.azure.management.resources.ProviderResourceType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class LocationCache {
    private static Map<String, Set<String>> regions = new HashMap<String, Set<String>>();
    private static final long EXPIRE_TIME_IN_MILLIS = TimeUnit.HOURS.toMillis(24L);
    private static Map<String, Long> achieveTimeInMillis = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getLocation(Azure azureClient, String key) throws Exception {
        if (regions.containsKey(key) && !regions.get(key).isEmpty() && System.currentTimeMillis() < achieveTimeInMillis.get(key) + EXPIRE_TIME_IN_MILLIS) {
            return regions.get(key);
        }
        Class<LocationCache> clazz = LocationCache.class;
        synchronized (LocationCache.class) {
            if (regions.containsKey(key) && !regions.get(key).isEmpty() && System.currentTimeMillis() < achieveTimeInMillis.get(key) + EXPIRE_TIME_IN_MILLIS) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return regions.get(key);
            }
            HashSet<String> locations = new HashSet<String>();
            PagedList providers = azureClient.providers().list();
            for (Provider provider : providers) {
                List resourceTypes = provider.resourceTypes();
                for (ProviderResourceType resourceType : resourceTypes) {
                    if (!resourceType.resourceType().equalsIgnoreCase("virtualMachines")) continue;
                    for (String location : resourceType.locations()) {
                        if (locations.contains(location)) continue;
                        try {
                            if (azureClient.virtualMachines().sizes().listByRegion(location).isEmpty()) continue;
                            locations.add(location);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            achieveTimeInMillis.put(key, System.currentTimeMillis());
            regions.put(key, locations);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return locations;
        }
    }

    private LocationCache() {
    }
}

