/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.util;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;

public final class AzureUtil {
    private static final String STORAGE_ACCOUNT_NAME_PATTERN = "^[a-z0-9]+$";
    private static final String NOT_A_NUMBER_FORMAT = ".*[^0-9].*";
    public static final String VAL_CLOUD_SERVICE_NAME = "^(([a-z\\d]((-(?=[a-z\\d]))|([a-z\\d])){2,62}))$";
    public static final String VAL_DIGIT_REGEX = "(?=.*[0-9]).{1,}";
    public static final String VAL_LOWER_CASE_REGEX = "(?=.*[a-z]).{1,}";
    public static final String VAL_UPPER_CASE_REGEX = "(?=.*[A-Z]).{1,}";
    public static final String VAL_SPECIAL_CHAR_REGEX = "(?=.*[@#\\$%\\^&\\*-_!+=\\[\\]{}|\\\\:`,\\.\\?/~\"\\(\\);']).{1,}";
    public static final String VAL_PASSWORD_REGEX = "([0-9a-zA-Z@#\\$%\\^&\\*-_!+=\\[\\]{}|\\\\:`,\\.\\?/~\"\\(\\);']{8,123})";
    public static final String VAL_ADMIN_USERNAME = "([a-zA-Z0-9_-]{3,15})";
    public static final String VAL_TEMPLATE = "^[a-z][a-z0-9-]*[a-z0-9]$";
    public static final int STORAGE_ACCOUNT_MIN_LENGTH = 3;
    public static final int STORAGE_ACCOUNT_MAX_LENGTH = 24;
    public static final int PASSWORD_MIN_COMBINATION = 3;
    public static final int PASSWORD_MIN_LENGTH = 12;
    public static final int PASSWORD_MAX_LENGTH = 123;
    public static final int TEMPLATE_NAME_MAX_LENGTH_LINUX = 63;
    public static final int TEMPLATE_NAME_MAX_LENGTH_WIN = 15;
    public static final int TEMPLATE_NAME_MAX_LENGTH_DEPLOYMENT = 64;

    public static String hexify(byte[] bytes) {
        int byteHigherHalfMask = 240;
        int byteLowerHalfMask = 15;
        int byteHalfLength = 4;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }

    public static boolean validateStorageAccountName(String storageAccountName) {
        if (storageAccountName.length() < 3 || storageAccountName.length() > 24) {
            return false;
        }
        return storageAccountName.matches(STORAGE_ACCOUNT_NAME_PATTERN);
    }

    public static boolean validateNumberFormat(String value) {
        return !value.matches(NOT_A_NUMBER_FORMAT);
    }

    public static boolean validateCloudServiceName(String cloudServiceName) {
        boolean isValid = false;
        if (cloudServiceName != null && cloudServiceName.matches(VAL_CLOUD_SERVICE_NAME)) {
            isValid = true;
        }
        return isValid;
    }

    public static boolean isValidPassword(String value) {
        int matchCount = 0;
        if (value.matches(VAL_DIGIT_REGEX)) {
            ++matchCount;
        }
        if (value.matches(VAL_LOWER_CASE_REGEX)) {
            ++matchCount;
        }
        if (value.matches(VAL_UPPER_CASE_REGEX)) {
            ++matchCount;
        }
        if (value.matches(VAL_SPECIAL_CHAR_REGEX)) {
            ++matchCount;
        }
        if (matchCount < 3) {
            return false;
        }
        return value.length() >= 12 && value.matches(VAL_PASSWORD_REGEX) && value.length() < 123;
    }

    public static boolean isValidUserName(String value) {
        if (value == null || value.trim().length() == 0) {
            return false;
        }
        return value.matches(VAL_ADMIN_USERNAME);
    }

    public static int isPositiveInteger(String value) throws IllegalArgumentException {
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException("value is null or empty");
        }
        try {
            int number = Integer.parseInt(value);
            if (number > 0) {
                return number;
            }
            throw new IllegalArgumentException("Not a positive number");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid number");
        }
    }

    public static int isNonNegativeInteger(String value) throws IllegalArgumentException {
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException("value is null or empty");
        }
        try {
            int number = Integer.parseInt(value);
            if (number >= 0) {
                return number;
            }
            throw new IllegalArgumentException("Not a Non-Negative number");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid number");
        }
    }

    public static boolean isValidJvmOption(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            return value.trim().startsWith("-");
        }
        return false;
    }

    public static boolean isConflictError(String errorMessage) {
        if (StringUtils.isBlank((String)errorMessage)) {
            return false;
        }
        return errorMessage.contains("ServiceException") && errorMessage.contains("ConflictError");
    }

    public static boolean isHostNotFound(String errorMessage) {
        if (StringUtils.isBlank((String)errorMessage)) {
            return false;
        }
        return errorMessage.contains("UnknownHostException");
    }

    public static boolean isBadRequestOrForbidden(String errorMessage) {
        if (StringUtils.isBlank((String)errorMessage)) {
            return false;
        }
        return errorMessage.contains("ServiceException") && (errorMessage.contains("BadRequest") || errorMessage.contains("Forbidden"));
    }

    public static boolean isDeploymentNotFound(String errorMessage, String deploymentName) {
        if (StringUtils.isBlank((String)errorMessage) || StringUtils.isBlank((String)deploymentName)) {
            return false;
        }
        return errorMessage.contains("ServiceException") && errorMessage.contains("ResourceNotFound") && errorMessage.contains("The deployment name '" + deploymentName + "' does not exist");
    }

    public static boolean isDeploymentAlreadyOccupied(String errorMessage) {
        if (StringUtils.isBlank((String)errorMessage)) {
            return false;
        }
        return errorMessage.contains("The specified deployment slot Production is occupied");
    }

    public static String getCloudName(String credentialId, String resourceGroupName) {
        return "AzureVMAgents-" + credentialId + "-" + resourceGroupName;
    }

    private static String getShortenedTemplateName(String templateName, String usageType, int dateDigits, int extraSuffixDigits) {
        int maxLength;
        if (!AzureUtil.isValidTemplateName(templateName)) {
            throw new IllegalArgumentException("Template name is not valid");
        }
        if (usageType.equals("Linux")) {
            maxLength = 63;
        } else if (usageType.equals("Windows")) {
            maxLength = 15;
        } else if (usageType.equals("Deployment")) {
            maxLength = 64;
        } else {
            throw new IllegalArgumentException("Unknown OS/Usage type");
        }
        maxLength -= dateDigits;
        String shortenedName = templateName.substring(0, Math.min(templateName.length(), maxLength -= extraSuffixDigits));
        if (StringUtils.isNumeric((String)shortenedName.substring(shortenedName.length() - 1))) {
            shortenedName = shortenedName.substring(0, Math.min(templateName.length(), maxLength - 1));
            shortenedName = shortenedName + '-';
        }
        return shortenedName;
    }

    public static boolean isValidTemplateName(String templateName) {
        return templateName.matches(VAL_TEMPLATE);
    }

    public static String getDeploymentName(String templateName, Date timestamp) {
        if (!AzureUtil.isValidTemplateName(templateName)) {
            throw new IllegalArgumentException("Invalid template name");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MMddHHmmssSSS");
        return String.format("%s%s", AzureUtil.getShortenedTemplateName(templateName, "Deployment", "MMddHHmmssSSS".length(), 0), formatter.format((Object)timestamp));
    }

    public static String getVMBaseName(String templateName, String deploymentName, String osType, int numberOfVMs) {
        if (!AzureUtil.isValidTemplateName(templateName)) {
            throw new IllegalArgumentException("Invalid template name");
        }
        int numberOfDigits = (int)Math.floor(Math.log10(numberOfVMs)) + 1;
        Integer deploymentHashCode = deploymentName.hashCode();
        String deploymentHashString = Integer.toHexString(deploymentHashCode);
        String shortenedDeploymentHash = null;
        shortenedDeploymentHash = deploymentHashString.length() <= 5 ? deploymentHashString : deploymentHashString.substring(deploymentHashString.length() - 5);
        return String.format("%s%s", AzureUtil.getShortenedTemplateName(templateName, osType, 6, numberOfDigits), shortenedDeploymentHash);
    }

    public static StandardUsernamePasswordCredentials getCredentials(String credentialsId) throws AzureCloudException {
        StandardUsernamePasswordCredentials creds = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (creds == null) {
            throw AzureCloudException.create("Could not find credentials with id: " + credentialsId);
        }
        return creds;
    }

    public static boolean isValidResourceGroupName(String resourceGroupName) {
        return resourceGroupName.matches("^[a-zA-Z0-9][a-zA-Z\\-_0-9]{0,62}[a-zA-Z0-9]$");
    }

    public static boolean isValidMAxVMLimit(String maxVMLimit) {
        return !StringUtils.isBlank((String)maxVMLimit) && maxVMLimit.matches("\\d+");
    }

    public static boolean isValidTimeOut(String deploymentTimeout) {
        return !StringUtils.isBlank((String)deploymentTimeout) && deploymentTimeout.matches("\\d+") && Integer.parseInt(deploymentTimeout) >= 1200;
    }

    public static String getLocationNameByLabel(String label) {
        return label.toLowerCase().replace(" ", "");
    }

    private AzureUtil() {
    }

    public static class DeploymentTag {
        private final String instanceId;
        private final long timestamp;

        public DeploymentTag() {
            this(System.currentTimeMillis() / 1000L);
        }

        public DeploymentTag(String tag) {
            String id = "";
            long ts = 0L;
            if (tag != null && !tag.isEmpty()) {
                String[] parts = tag.split("/");
                if (parts.length >= 1) {
                    id = parts[0];
                }
                if (parts.length >= 2) {
                    try {
                        ts = Long.parseLong(parts[1]);
                        ts = ts < 0L ? 0L : ts;
                    }
                    catch (Exception e) {
                        ts = 0L;
                    }
                }
            }
            this.instanceId = id;
            this.timestamp = ts;
        }

        public String get() {
            return this.instanceId + "/" + Long.toString(this.timestamp);
        }

        public boolean matches(DeploymentTag rhs) {
            return this.matches(rhs, 7200L);
        }

        public boolean matches(DeploymentTag rhs, long timeout) {
            if (!this.instanceId.equals(rhs.instanceId)) {
                return false;
            }
            return Math.abs(this.timestamp - rhs.timestamp) > timeout;
        }

        public boolean isFromSameInstance(DeploymentTag rhs) {
            return this.instanceId.equals(rhs.instanceId);
        }

        protected DeploymentTag(long timestamp) {
            String id = "";
            try {
                id = Jenkins.getInstance().getLegacyInstanceId();
            }
            catch (Exception e) {
                id = "AzureJenkins000";
            }
            this.instanceId = id;
            this.timestamp = timestamp;
        }
    }
}

