/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.util;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureCredentialUtil;
import com.microsoft.azure.vmagent.AzureVMAgentPlugin;
import com.microsoft.jenkins.azurecommons.core.AzureClientFactory;
import com.microsoft.jenkins.azurecommons.core.credentials.TokenCredentialData;
import java.util.logging.Logger;
import okhttp3.Interceptor;

public final class AzureClientUtil {
    private static final Logger LOGGER = Logger.getLogger(AzureClientUtil.class.getName());

    public static TokenCredentialData getToken(String credentialId) {
        AzureBaseCredentials credential = AzureCredentialUtil.getCredential2((String)credentialId);
        if (credential == null) {
            throw new NullPointerException("Can't find credential with id: " + credentialId);
        }
        return TokenCredentialData.deserialize((byte[])credential.serializeToTokenData());
    }

    public static Azure getClient(String credentialId) {
        TokenCredentialData token = AzureClientUtil.getToken(credentialId);
        return AzureClientUtil.getClient(token);
    }

    public static Azure getClient(TokenCredentialData token) {
        return AzureClientFactory.getClient((TokenCredentialData)token, (AzureClientFactory.Configurer)new AzureClientFactory.Configurer(){

            public Azure.Configurable configure(Azure.Configurable configurable) {
                return (Azure.Configurable)((Azure.Configurable)configurable.withInterceptor((Interceptor)new AzureVMAgentPlugin.AzureTelemetryInterceptor())).withUserAgent(AzureClientFactory.getUserAgent((String)"AzureJenkinsVMAgent", (String)AzureClientUtil.class.getPackage().getImplementationVersion()));
            }
        });
    }

    private AzureClientUtil() {
    }
}

