/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.util;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.util.AzureClientUtil;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public final class AzureClientHolder {
    private static String cachedId;
    private static Azure cachedClient;

    private AzureClientHolder() {
    }

    @Nonnull
    public static synchronized Azure get(String credentialId) {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is null!");
        }
        if (!StringUtils.equals((String)cachedId, (String)credentialId)) {
            cachedId = credentialId;
            cachedClient = AzureClientUtil.getClient(credentialId);
        }
        return cachedClient;
    }

    public static AzureVMManagementServiceDelegate getDelegate(String credentialId) {
        return AzureVMManagementServiceDelegate.getInstance(AzureClientHolder.get(credentialId));
    }
}

