/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.retry;

import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.retry.DefaultRetryStrategy;
import com.microsoft.azure.vmagent.retry.RetryStrategy;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RetryTask<T>
implements Callable<T> {
    private static final Logger LOGGER = Logger.getLogger(RetryTask.class.getName());
    private final Callable<T> task;
    private final RetryStrategy retryStrategy;

    public RetryTask(Callable<T> task) {
        this.task = task;
        this.retryStrategy = new DefaultRetryStrategy();
    }

    public RetryTask(Callable<T> task, RetryStrategy retryStrategy) {
        this.task = task;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public T call() throws AzureCloudException {
        while (true) {
            try {
                return this.task.call();
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Handle retry due to: ", e);
                this.retryStrategy.handleRetry(e);
                continue;
            }
            break;
        }
    }
}

