/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.remote;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMAgentPlugin;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.util.AzureUtil;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import com.microsoft.azure.vmagent.util.FailureStage;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.Localizable;

public class AzureVMAgentSSHLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(AzureVMAgentSSHLauncher.class.getName());
    private static final String REMOTE_INIT_FILE_NAME = "init.sh";
    private static final String REMOTE_INIT_FILE_NAME_WINDOWS = "/init.ps1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(SlaveComputer agentComputer, TaskListener listener) {
        Session session;
        boolean successful;
        PrintStream logger;
        boolean isUnix;
        AzureVMAgent agent;
        AzureVMComputer computer;
        block32: {
            if (agentComputer == null || !(agentComputer instanceof AzureVMComputer)) {
                LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: launch: AgentComputer is invalid {0}", agentComputer);
                return;
            }
            computer = (AzureVMComputer)agentComputer;
            agent = (AzureVMAgent)computer.getNode();
            if (agent == null) {
                LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: launch: Agent Node is null");
                return;
            }
            LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: launch: launch method called for agent {0}", computer.getName());
            isUnix = agent.getOsType().equals((Object)OperatingSystemTypes.LINUX);
            try {
                if (!agent.isVMAliveOrHealthy()) {
                    LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: launch: Agent {0} is shut down, deleted, etc. Not attempting to connect", computer.getName());
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            agent.blockCleanUpAction();
            logger = listener.getLogger();
            successful = false;
            session = null;
            try {
                session = this.connectToSsh(agent);
            }
            catch (UnknownHostException e) {
                LOGGER.log(Level.SEVERE, "AzureVMAgentSSHLauncher: launch: Got unknown host exception. Virtual machine might have been deleted already", e);
            }
            catch (ConnectException e) {
                LOGGER.log(Level.SEVERE, "AzureVMAgentSSHLauncher: launch: Got connect exception. Might be due to firewall rules", e);
                this.handleLaunchFailure(agent, "Post Provisioning Failure: Not able to connect to agent machine. Ensure that ssh server is configured properly");
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().equalsIgnoreCase("Auth fail")) {
                    LOGGER.log(Level.SEVERE, "AzureVMAgentSSHLauncher: launch: Authentication failure. Image may not be supporting password authentication", e);
                    this.handleLaunchFailure(agent, "Post Provisioning Failure: Not able to authenticate via username and  Image may not be supporting password authentication , marking template has disabled");
                }
                LOGGER.log(Level.SEVERE, "AzureVMAgentSSHLauncher: launch: Got  exception", e);
                this.handleLaunchFailure(agent, "Post Provisioning Failure: Not able to connect to agent machine. Ensure that ssh server is configured properly" + e.getMessage());
            }
            finally {
                if (session != null) break block32;
                agent.getComputer().setAcceptingTasks(false);
                agent.setCleanUpAction(CleanUpAction.DELETE, Messages._Agent_Failed_To_Connect());
                return;
            }
        }
        Localizable cleanUpReason = null;
        try {
            final Session cleanupSession = session;
            String initScript = agent.getInitScript();
            String command = isUnix ? "test -e ~/.azure-agent-init" : "dir C:\\.azure-agent-init";
            if (StringUtils.isNotBlank((String)initScript) && this.executeRemoteCommand(session, command, logger, isUnix) != 0) {
                LOGGER.info("AzureVMAgentSSHLauncher: launch: Init script is not null, preparing to execute script remotely");
                if (isUnix) {
                    this.copyFileToRemote(session, new ByteArrayInputStream(initScript.getBytes(StandardCharsets.UTF_8)), REMOTE_INIT_FILE_NAME);
                } else {
                    this.copyFileToRemote(session, new ByteArrayInputStream(initScript.getBytes(StandardCharsets.UTF_8)), REMOTE_INIT_FILE_NAME_WINDOWS);
                }
                StandardUsernamePasswordCredentials creds = AzureUtil.getCredentials(agent.getVMCredentialsId());
                command = isUnix ? "sh init.sh" : "powershell /init.ps1";
                int exitStatus = this.executeRemoteCommand(session, command, logger, isUnix, agent.getExecuteInitScriptAsRoot(), creds.getPassword().getPlainText());
                if (exitStatus != 0) {
                    if (agent.getDoNotUseMachineIfInitFails()) {
                        LOGGER.log(Level.SEVERE, "AzureVMAgentSSHLauncher: launch: init script failed: exit code={0} (marking agent for deletion)", exitStatus);
                        cleanUpReason = Messages._Agent_Failed_Init_Script();
                        return;
                    }
                    LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: launch: init script failed: exit code={0} (ignoring)", exitStatus);
                } else {
                    LOGGER.info("AzureVMAgentSSHLauncher: launch: init script got executed successfully");
                }
                if (!isUnix) {
                    this.executeRemoteCommand(session, "powershell -ExecutionPolicy Bypass Restart-Service sshd", logger, isUnix);
                }
                session.disconnect();
                session = this.connectToSsh(agent);
                command = isUnix ? "touch ~/.azure-agent-init" : "copy NUL C:\\.azure-agent-init";
                this.executeRemoteCommand(session, command, logger, isUnix);
            }
            LOGGER.info("AzureVMAgentSSHLauncher: launch: checking for java runtime");
            if (this.executeRemoteCommand(session, "java -fullversion", logger, isUnix) != 0) {
                LOGGER.info("AzureVMAgentSSHLauncher: launch: Java not found. At a minimum init script should ensure that java runtime is installed");
                this.handleLaunchFailure(agent, "Post Provisioning Failure: Java runtime not found. At a minimum init script  should ensure that java runtime is installed");
                return;
            }
            LOGGER.info("AzureVMAgentSSHLauncher: launch: java runtime present, copying slave.jar to remote");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Jenkins.getInstance().getJnlpJars("slave.jar").readFully());
            this.copyFileToRemote(session, inputStream, "slave.jar");
            String jvmopts = agent.getJvmOptions();
            String execCommand = "java " + (StringUtils.isNotBlank((String)jvmopts) ? jvmopts : "") + " -jar slave.jar";
            LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: launch: launching agent: {0}", execCommand);
            final ChannelExec jschChannel = (ChannelExec)session.openChannel("exec");
            jschChannel.setCommand(execCommand);
            jschChannel.connect();
            LOGGER.info("AzureVMAgentSSHLauncher: launch: Connected successfully");
            computer.setChannel(jschChannel.getInputStream(), jschChannel.getOutputStream(), logger, new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    if (jschChannel != null) {
                        jschChannel.disconnect();
                    }
                    if (cleanupSession != null) {
                        cleanupSession.disconnect();
                    }
                }
            });
            LOGGER.info("AzureVMAgentSSHLauncher: launch: launched agent successfully");
            agent.clearCleanUpAction();
            successful = true;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("OSType", agent.getOsType().toString());
            AzureVMAgentPlugin.sendEvent("VMAgent", "SSHLaunch", properties);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "AzureVMAgentSSHLauncher: launch: got exception ", e);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("OSType", agent.getOsType().toString());
            properties.put("Message", e.getMessage());
            AzureVMAgentPlugin.sendEvent("VMAgent", "SSHLaunchFailed", properties);
        }
        finally {
            if (!successful) {
                session.disconnect();
                if (cleanUpReason == null) {
                    cleanUpReason = Messages._Agent_Failed_To_Connect();
                }
                agent.getComputer().setAcceptingTasks(false);
                agent.setCleanUpAction(CleanUpAction.DELETE, cleanUpReason);
            }
        }
    }

    private Session getRemoteSession(String userName, String password, String dnsName, int sshPort) throws JSchException {
        LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: getRemoteSession: getting remote session for user {0} to host {1}:{2}", new Object[]{userName, dnsName, sshPort});
        JSch remoteClient = new JSch();
        try {
            Session session = remoteClient.getSession(userName, dnsName, sshPort);
            session.setConfig("StrictHostKeyChecking", "no");
            session.setPassword(password);
            int serverAliveIntervalInMillis = 60000;
            session.setServerAliveInterval(60000);
            session.connect();
            LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: getRemoteSession: Got remote session for user {0} to host {1}:{2}", new Object[]{userName, dnsName, sshPort});
            return session;
        }
        catch (JSchException e) {
            LOGGER.log(Level.SEVERE, String.format("AzureVMAgentSSHLauncher: getRemoteSession: Got exception while connecting to remote host %s:%s", dnsName, sshPort), e);
            throw e;
        }
    }

    private void copyFileToRemote(Session jschSession, InputStream stream, String remotePath) throws Exception {
        LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: copyFileToRemote: Initiating file transfer to {0}", remotePath);
        ChannelSftp sftpChannel = null;
        try {
            sftpChannel = (ChannelSftp)jschSession.openChannel("sftp");
            sftpChannel.connect();
            sftpChannel.put(stream, remotePath);
            if (!sftpChannel.isClosed()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: copyFileToRemote: copied file Successfully to {0}", remotePath);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "AzureVMAgentSSHLauncher: copyFileToRemote: Error occurred while copying file to remote host", e);
            throw e;
        }
        finally {
            try {
                if (sftpChannel != null) {
                    sftpChannel.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    private int executeRemoteCommand(Session jschSession, String command, PrintStream logger, boolean isUnix) {
        return this.executeRemoteCommand(jschSession, command, logger, isUnix, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeRemoteCommand(Session jschSession, String command, PrintStream logger, boolean isUnix, boolean executeAsRoot, String passwordIfRoot) {
        ChannelExec channel = null;
        try {
            String finalCommand = null;
            finalCommand = isUnix && executeAsRoot ? "sudo -S -p '' " + command : command;
            LOGGER.log(Level.INFO, "AzureVMAgentSSHLauncher: executeRemoteCommand: starting {0}", command);
            channel = (ChannelExec)jschSession.openChannel("exec");
            channel.setCommand(finalCommand);
            channel.setInputStream(null);
            channel.setErrStream((OutputStream)System.err);
            InputStream inputStream = channel.getInputStream();
            InputStream errorStream = channel.getErrStream();
            OutputStream outputStream = channel.getOutputStream();
            int connectTimeoutInMillis = 60000;
            channel.connect(60000);
            if (isUnix && executeAsRoot) {
                outputStream.write((passwordIfRoot + "\n").getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            }
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)logger);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            try {
                IOUtils.copy((InputStream)errorStream, (OutputStream)logger);
            }
            finally {
                IOUtils.closeQuietly((InputStream)errorStream);
            }
            if (!channel.isClosed()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            LOGGER.info("AzureVMAgentSSHLauncher: executeRemoteCommand: executed successfully");
            int n = channel.getExitStatus();
            return n;
        }
        catch (JSchException jse) {
            LOGGER.log(Level.SEVERE, "AzureVMAgentSSHLauncher: executeRemoteCommand: got exception while executing remote command\n" + command, jse);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "IO failure running {0}", command);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("Unexpected exception running %s", command), e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return -1;
    }

    private Session connectToSsh(AzureVMAgent agent) throws Exception {
        LOGGER.info("AzureVMAgentSSHLauncher: connectToSsh: start");
        Session session = null;
        int maxRetryCount = 6;
        int currRetryCount = 0;
        while (true) {
            ++currRetryCount;
            try {
                StandardUsernamePasswordCredentials creds = AzureUtil.getCredentials(agent.getVMCredentialsId());
                session = this.getRemoteSession(creds.getUsername(), creds.getPassword().getPlainText(), agent.getPublicDNSName(), agent.getSshPort());
                LOGGER.info("AzureVMAgentSSHLauncher: connectToSsh: Got remote connection");
            }
            catch (Exception e) {
                if (currRetryCount >= 6) {
                    throw e;
                }
                LOGGER.log(Level.SEVERE, "AzureVMAgentSSHLauncher: connectToSsh: Got exception while connecting to remote host. Will be trying again after 1 minute ", e);
                int sleepInMills = 60000;
                Thread.sleep(60000L);
                continue;
            }
            break;
        }
        return session;
    }

    private void handleLaunchFailure(AzureVMAgent agent, String message) {
        AzureVMAgentTemplate agentTemplate;
        AzureVMCloud azureCloud = agent.getCloud();
        if (azureCloud != null && (agentTemplate = azureCloud.getAzureAgentTemplate(agent.getTemplateName())) != null) {
            agentTemplate.handleTemplateProvisioningFailure(message, FailureStage.POSTPROVISIONING);
        }
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

