/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.builders;

import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.builders.AzureVMTemplateFluent;

public class AzureVMTemplateBuilder
extends AzureVMTemplateFluent<AzureVMTemplateBuilder> {
    private AzureVMTemplateFluent<?> fluent;

    public AzureVMTemplateBuilder() {
        this.fluent = this;
    }

    public AzureVMTemplateBuilder(AzureVMAgentTemplate template) {
        this.fluent = this;
        this.fluent.withName(template.getTemplateName());
        this.fluent.withDescription(template.getTemplateDesc());
        this.fluent.withLabels(template.getLabels());
        this.fluent.withLocation(template.getLocation());
        this.fluent.withAvailability(template.getAvailabilityInside());
        this.fluent.withVirtualMachineSize(template.getVirtualMachineSize());
        if (template.getStorageAccountNameReferenceType().equalsIgnoreCase("new")) {
            this.fluent.withNewStorageAccount(template.getNewStorageAccountName());
        } else {
            this.fluent.withExistingStorageAccount(template.getExistingStorageAccountName());
        }
        this.fluent.withStorageAccountType(template.getStorageAccountType());
        this.fluent.withDiskType(template.getDiskType());
        this.fluent.withOsDiskSize(template.getOsDiskSize());
        this.fluent.withRetentionStrategy(template.getRetentionStrategy());
        this.fluent.withUsageMode(template.getUsageMode());
        this.fluent.withAdminCredential(template.getCredentialsId());
        this.fluent.withWorkspace(template.getAgentWorkspace());
        this.fluent.withShutdownOnIdle(template.isShutdownOnIdle());
        if (template.getImageTopLevelType().equalsIgnoreCase("basic")) {
            this.fluent.withBuiltInImage(template.getBuiltInImageInside());
        } else {
            this.fluent.withAdvancedImage(template.getAdvancedImageInside());
        }
    }

    public AzureVMTemplateBuilder(AzureVMTemplateFluent<?> fluent) {
        this.fluent = fluent;
    }

    public AzureVMTemplateBuilder(AzureVMTemplateFluent<?> fluent, AzureVMAgentTemplate template) {
        this.fluent = fluent;
        fluent.withName(template.getTemplateName());
        fluent.withDescription(template.getTemplateDesc());
        fluent.withLabels(template.getLabels());
        fluent.withLocation(template.getLocation());
        fluent.withAvailability(template.getAvailabilityInside());
        fluent.withVirtualMachineSize(template.getVirtualMachineSize());
        if (template.getStorageAccountNameReferenceType().equalsIgnoreCase("new")) {
            fluent.withNewStorageAccount(template.getNewStorageAccountName());
        } else {
            fluent.withExistingStorageAccount(template.getExistingStorageAccountName());
        }
        fluent.withStorageAccountType(template.getStorageAccountType());
        fluent.withDiskType(template.getDiskType());
        fluent.withOsDiskSize(template.getOsDiskSize());
        fluent.withRetentionStrategy(template.getRetentionStrategy());
        fluent.withUsageMode(template.getUsageMode());
        fluent.withAdminCredential(template.getCredentialsId());
        fluent.withWorkspace(template.getAgentWorkspace());
        fluent.withShutdownOnIdle(template.isShutdownOnIdle());
        if (template.getImageTopLevelType().equalsIgnoreCase("basic")) {
            fluent.withBuiltInImage(template.getBuiltInImageInside());
        } else {
            fluent.withAdvancedImage(template.getAdvancedImageInside());
        }
    }

    public AzureVMAgentTemplate build() {
        return new AzureVMAgentTemplate(this.fluent.getName(), this.fluent.getDescription(), this.fluent.getLabels(), this.fluent.getLocation(), new AzureVMAgentTemplate.AvailabilityTypeClass(this.fluent.getAvailability().getAvailabilitySet()), this.fluent.getVirtualMachineSize(), this.fluent.getStorageAccountNameReferenceType(), this.fluent.getStorageAccountType(), this.fluent.getNewStorageAccountName(), this.fluent.getExistingStorageAccountName(), this.fluent.getDiskType(), this.fluent.getOsDiskSize(), this.fluent.getAdvancedImage().getNoOfParallelJobs(), this.fluent.getUsageMode(), this.fluent.getBuiltInImage().getBuiltInImage(), this.fluent.getBuiltInImage().isInstallGit(), this.fluent.getBuiltInImage().isInstallMaven(), this.fluent.getBuiltInImage().isInstallDocker(), this.fluent.getAdvancedImage().getOsType(), this.fluent.getImageTopLevelType(), false, new AzureVMAgentTemplate.ImageReferenceTypeClass(this.fluent.getAdvancedImage().getImage(), this.fluent.getAdvancedImage().getImageId(), this.fluent.getAdvancedImage().getImagePublisher(), this.fluent.getAdvancedImage().getImageOffer(), this.fluent.getAdvancedImage().getImageSku(), this.fluent.getAdvancedImage().getImageVersion()), this.fluent.getAdvancedImage().getAgentLaunchMethod(), this.fluent.getAdvancedImage().isPreInstallSsh(), this.fluent.getAdvancedImage().getInitScript(), this.fluent.getCredentialsId(), this.fluent.getAdvancedImage().getVirtualNetworkName(), this.fluent.getAdvancedImage().getVirtualNetworkResourceGroupName(), this.fluent.getAdvancedImage().getSubnetName(), this.fluent.getAdvancedImage().isUsePrivateIP(), this.fluent.getAdvancedImage().getNsgName(), this.fluent.getWorkspace(), this.fluent.getAdvancedImage().getJvmOptions(), this.fluent.getRetentionStrategy(), this.fluent.isShutdownOnIdle(), this.fluent.getAdvancedImage().isTemplateDisabled(), null, this.fluent.getAdvancedImage().isExecuteInitScriptAsRoot(), this.fluent.getAdvancedImage().isDoNotUseMachineIfInitFails(), this.fluent.getAdvancedImage().isEnableMSI());
    }
}

