/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.builders;

import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.builders.AzureVMTemplateBuilder;
import com.microsoft.azure.vmagent.builders.AzureVMTemplateFluent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AzureVMCloudBuilder {
    private String cloudName;
    private String azureCredentialsId;
    private String maxVirtualMachinesLimit;
    private String deploymentTimeout;
    private String resourceGroupReferenceType;
    private String newResourceGroupName;
    private String existingResourceGroupName;
    private List<AzureVMAgentTemplate> vmTemplates;

    public AzureVMCloudBuilder() {
        this.maxVirtualMachinesLimit = "10";
        this.deploymentTimeout = "1200";
        this.resourceGroupReferenceType = "new";
        this.vmTemplates = new ArrayList<AzureVMAgentTemplate>();
    }

    public AzureVMCloudBuilder(AzureVMCloud cloud) {
        this.cloudName = cloud.getCloudName();
        this.azureCredentialsId = cloud.getAzureCredentialsId();
        this.maxVirtualMachinesLimit = String.valueOf(cloud.getMaxVirtualMachinesLimit());
        this.deploymentTimeout = String.valueOf(cloud.getDeploymentTimeout());
        this.resourceGroupReferenceType = cloud.getResourceGroupReferenceType();
        this.newResourceGroupName = cloud.getNewResourceGroupName();
        this.existingResourceGroupName = cloud.getExistingResourceGroupName();
        this.vmTemplates = new ArrayList<AzureVMAgentTemplate>();
        for (AzureVMAgentTemplate template : cloud.getVmTemplates()) {
            this.vmTemplates.add(template);
        }
    }

    public AzureVMCloudBuilder withCloudName(String cloudName) {
        this.cloudName = cloudName;
        return this;
    }

    public AzureVMCloudBuilder withAzureCredentialsId(String azureCredentialsId) {
        this.azureCredentialsId = azureCredentialsId;
        return this;
    }

    public AzureVMCloudBuilder withMaxVirtualMachinesLimit(String maxVirtualMachinesLimit) {
        this.maxVirtualMachinesLimit = maxVirtualMachinesLimit;
        return this;
    }

    public AzureVMCloudBuilder withDeploymentTimeout(String deploymentTimeout) {
        this.deploymentTimeout = deploymentTimeout;
        return this;
    }

    public AzureVMCloudBuilder withNewResourceGroupName(String resourceGroupName) {
        this.resourceGroupReferenceType = "new";
        this.newResourceGroupName = resourceGroupName;
        return this;
    }

    public AzureVMCloudBuilder withExistingResourceGroupName(String resourceGroupName) {
        this.resourceGroupReferenceType = "existing";
        this.existingResourceGroupName = resourceGroupName;
        return this;
    }

    public AzureVMCloudBuilder withTemplates(List<AzureVMAgentTemplate> templates) {
        this.vmTemplates.clear();
        this.vmTemplates.addAll(templates);
        return this;
    }

    public AzureVMCloudBuilder addToTemplates(List<AzureVMAgentTemplate> templates) {
        this.vmTemplates.addAll(templates);
        return this;
    }

    public AzureVMCloudBuilder addToTemplates(AzureVMAgentTemplate ... templates) {
        Collections.addAll(this.vmTemplates, templates);
        return this;
    }

    public AzureVMTemplateNested addNewTemplate() {
        return new AzureVMTemplateNested();
    }

    public AzureVMTemplateNested addNewTemplateLike(AzureVMAgentTemplate template) {
        return new AzureVMTemplateNested(template);
    }

    public AzureVMCloud build() {
        return new AzureVMCloud(StringUtils.defaultString((String)this.cloudName), "", StringUtils.defaultString((String)this.azureCredentialsId), this.maxVirtualMachinesLimit, this.deploymentTimeout, this.resourceGroupReferenceType, StringUtils.defaultString((String)this.newResourceGroupName), StringUtils.defaultString((String)this.existingResourceGroupName), this.vmTemplates);
    }

    public class AzureVMTemplateNested
    extends AzureVMTemplateFluent<AzureVMTemplateNested> {
        private final AzureVMTemplateBuilder builder;

        AzureVMTemplateNested() {
            this.builder = new AzureVMTemplateBuilder(this);
        }

        AzureVMTemplateNested(AzureVMAgentTemplate template) {
            this.builder = new AzureVMTemplateBuilder(this, template);
        }

        public AzureVMCloudBuilder endTemplate() {
            return AzureVMCloudBuilder.this.addToTemplates(this.builder.build());
        }
    }
}

