/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.builders;

import com.microsoft.azure.vmagent.ImageReferenceType;
import com.microsoft.azure.vmagent.builders.AdvancedImage;
import com.microsoft.azure.vmagent.builders.AdvancedImageFluent;

public class AdvancedImageBuilder
extends AdvancedImageFluent<AdvancedImageBuilder> {
    private AdvancedImageFluent<?> fluent;

    public AdvancedImageBuilder(AdvancedImageFluent<?> fluent) {
        this.fluent = fluent;
    }

    public AdvancedImageBuilder(AdvancedImageFluent<?> fluent, AdvancedImage image) {
        this.fluent = fluent;
        if (ImageReferenceType.CUSTOM.getName().equals(image.getImageReferenceType())) {
            fluent.withCustomImage(image.getImage());
        } else if (ImageReferenceType.CUSTOM_IMAGE.getName().equals(image.getImageReferenceType())) {
            fluent.withCustomManagedImage(image.getImageId());
        } else {
            fluent.withReferenceImage(image.getImagePublisher(), image.getImageOffer(), image.getImageSku(), image.getImageVersion());
        }
        fluent.withNumberOfExecutors(String.valueOf(image.getNoOfParallelJobs()));
        fluent.withOsType(image.getOsType());
        fluent.withLaunchMethod(image.getAgentLaunchMethod());
        fluent.withPreInstallSsh(image.isPreInstallSsh());
        fluent.withInitScript(image.getInitScript());
        fluent.withVirtualNetworkName(image.getVirtualNetworkName());
        fluent.withVirtualNetworkResourceGroupName(image.getVirtualNetworkResourceGroupName());
        fluent.withSubnetName(image.getSubnetName());
        fluent.withUsePrivateIP(image.isUsePrivateIP());
        fluent.withNetworkSecurityGroupName(image.getNsgName());
        fluent.withJvmOptions(image.getJvmOptions());
        fluent.withDisableTemplate(image.isTemplateDisabled());
        fluent.withRunScriptAsRoot(image.isExecuteInitScriptAsRoot());
        fluent.withDoNotUseMachineIfInitFails(image.isDoNotUseMachineIfInitFails());
    }

    public AdvancedImageBuilder() {
        this.fluent = this;
    }

    public AdvancedImageBuilder(AdvancedImage image) {
        this.fluent = this;
        if (ImageReferenceType.CUSTOM.getName().equals(image.getImageReferenceType())) {
            this.fluent.withCustomImage(image.getImage());
        } else if (ImageReferenceType.CUSTOM_IMAGE.getName().equals(image.getImageReferenceType())) {
            this.fluent.withCustomManagedImage(image.getImageId());
        } else {
            this.fluent.withReferenceImage(image.getImagePublisher(), image.getImageOffer(), image.getImageSku(), image.getImageVersion());
        }
        this.fluent.withNumberOfExecutors(String.valueOf(image.getNoOfParallelJobs()));
        this.fluent.withOsType(image.getOsType());
        this.fluent.withLaunchMethod(image.getAgentLaunchMethod());
        this.fluent.withPreInstallSsh(image.isPreInstallSsh());
        this.fluent.withInitScript(image.getInitScript());
        this.fluent.withVirtualNetworkName(image.getVirtualNetworkName());
        this.fluent.withVirtualNetworkResourceGroupName(image.getVirtualNetworkResourceGroupName());
        this.fluent.withSubnetName(image.getSubnetName());
        this.fluent.withUsePrivateIP(image.isUsePrivateIP());
        this.fluent.withNetworkSecurityGroupName(image.getNsgName());
        this.fluent.withJvmOptions(image.getJvmOptions());
        this.fluent.withDisableTemplate(image.isTemplateDisabled());
        this.fluent.withRunScriptAsRoot(image.isExecuteInitScriptAsRoot());
        this.fluent.withDoNotUseMachineIfInitFails(image.isDoNotUseMachineIfInitFails());
    }

    public AdvancedImage build() {
        return new AdvancedImage(this.fluent.getImageReferenceType(), this.fluent.getImage(), this.fluent.getOsType(), this.fluent.getImageId(), this.fluent.getImagePublisher(), this.fluent.getImageOffer(), this.fluent.getImageSku(), this.fluent.getImageVersion(), this.fluent.getAgentLaunchMethod(), this.fluent.isPreInstallSsh(), this.fluent.getInitScript(), this.fluent.isExecuteInitScriptAsRoot(), this.fluent.isDoNotUseMachineIfInitFails(), this.fluent.isEnableMSI(), this.fluent.getVirtualNetworkName(), this.fluent.getVirtualNetworkResourceGroupName(), this.fluent.getSubnetName(), this.fluent.isUsePrivateIP(), this.fluent.getNsgName(), this.fluent.getJvmOptions(), this.fluent.getNoOfParallelJobs(), this.fluent.isTemplateDisabled());
    }
}

