/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import java.util.HashMap;
import java.util.Map;

public enum ImageReferenceType {
    UNKNOWN("unknown"),
    CUSTOM("custom"),
    CUSTOM_IMAGE("customImage"),
    REFERENCE("reference");

    private String name;
    private static final Map<String, ImageReferenceType> LOOKUP;

    private ImageReferenceType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static ImageReferenceType get(String name) {
        ImageReferenceType result;
        try {
            result = LOOKUP.get(name);
        }
        catch (Exception e) {
            return UNKNOWN;
        }
        return result;
    }

    static {
        LOOKUP = new HashMap<String, ImageReferenceType>();
        for (ImageReferenceType ref : ImageReferenceType.values()) {
            LOOKUP.put(ref.getName(), ref);
        }
    }
}

