/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.PowerState;
import com.microsoft.azure.management.compute.PurchasePlan;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineCustomImage;
import com.microsoft.azure.management.compute.VirtualMachineImage;
import com.microsoft.azure.management.compute.VirtualMachineOffer;
import com.microsoft.azure.management.compute.VirtualMachinePublisher;
import com.microsoft.azure.management.compute.VirtualMachineSize;
import com.microsoft.azure.management.compute.VirtualMachineSku;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.resources.Deployment;
import com.microsoft.azure.management.resources.DeploymentMode;
import com.microsoft.azure.management.resources.GenericResource;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.ExpandableStringEnum;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.storage.CheckNameAvailabilityResult;
import com.microsoft.azure.management.storage.Reason;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudPageBlob;
import com.microsoft.azure.storage.core.PathUtility;
import com.microsoft.azure.vmagent.AvailabilityType;
import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMAgentCleanUpTask;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMCloudBaseRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMDeploymentInfo;
import com.microsoft.azure.vmagent.ImageReferenceType;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.retry.ExponentialRetryStrategy;
import com.microsoft.azure.vmagent.retry.NoRetryStrategy;
import com.microsoft.azure.vmagent.util.AzureUtil;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import com.microsoft.azure.vmagent.util.ExecutionEngine;
import com.microsoft.azure.vmagent.util.LocationCache;
import hudson.model.Descriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;

public final class AzureVMManagementServiceDelegate {
    private static final Logger LOGGER = Logger.getLogger(AzureVMManagementServiceDelegate.class.getName());
    private static final String EMBEDDED_TEMPLATE_FILENAME = "/referenceImageTemplate.json";
    private static final String EMBEDDED_TEMPLATE_WITH_SCRIPT_FILENAME = "/referenceImageTemplateWithScript.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_FILENAME = "/customImageTemplate.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_WITH_SCRIPT_FILENAME = "/customImageTemplateWithScript.json";
    private static final String EMBEDDED_TEMPLATE_WITH_MANAGED_FILENAME = "/referenceImageTemplateWithManagedDisk.json";
    private static final String EMBEDDED_TEMPLATE_WITH_SCRIPT_MANAGED_FILENAME = "/referenceImageTemplateWithScriptAndManagedDisk.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_WITH_MANAGED_FILENAME = "/customImageTemplateWithManagedDisk.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_WITH_SCRIPT_MANAGED_FILENAME = "/customImageTemplateWithScriptAndManagedDisk.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_ID_WITH_MANAGED_FILENAME = "/referenceImageIDTemplateWithManagedDisk.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_ID_WITH_SCRIPT_MANAGED_FILENAME = "/referenceImageIDTemplateWithScriptAndManagedDisk.json";
    private static final String VIRTUAL_NETWORK_TEMPLATE_FRAGMENT_FILENAME = "/virtualNetworkFragment.json";
    private static final String PUBLIC_IP_FRAGMENT_FILENAME = "/publicIPFragment.json";
    private static final Map<String, List<String>> AVAILABLE_ROLE_SIZES = AzureVMManagementServiceDelegate.getAvailableRoleSizes();
    private static final Set<String> AVAILABLE_LOCATIONS_STD = AzureVMManagementServiceDelegate.getAvailableLocationsStandard();
    private static final Set<String> AVAILABLE_LOCATIONS_CHINA = AzureVMManagementServiceDelegate.getAvailableLocationsChina();
    private static final List<String> DEFAULT_VM_SIZES = Arrays.asList("Standard_A0", "Standard_A1", "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6", "Standard_A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_DS1_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2", "Standard_DS1", "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s", "Standard_F16s", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11", "Standard_D12", "Standard_D13", "Standard_D14", "Standard_A1_v2", "Standard_A2m_v2", "Standard_A2_v2", "Standard_A4m_v2", "Standard_A4_v2", "Standard_A8m_v2", "Standard_A8_v2", "Standard_D1_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2", "Standard_F1", "Standard_F2", "Standard_F4", "Standard_F8", "Standard_F16");
    public static final Map<String, Map<String, String>> DEFAULT_IMAGE_PROPERTIES = AzureVMManagementServiceDelegate.getDefaultImageProperties();
    public static final Map<String, Map<String, String>> PRE_INSTALLED_TOOLS_SCRIPT = AzureVMManagementServiceDelegate.getPreInstalledToolsScript();
    private static final String INSTALL_JNLP_WINDOWS_FILENAME = "/scripts/windowsInstallJnlpScript.ps1";
    private static final String INSTALL_GIT_WINDOWS_FILENAME = "/scripts/windowsInstallGitScript.ps1";
    private static final String INSTALL_JAVA_WINDOWS_FILENAME = "/scripts/windowsInstallJavaScript.ps1";
    private static final String INSTALL_MAVEN_WINDOWS_FILENAME = "/scripts/windowsInstallMavenScript.ps1";
    private static final String INSTALL_GIT_UBUNTU_FILENAME = "/scripts/ubuntuInstallGitScript.sh";
    private static final String INSTALL_JAVA_UBUNTU_FILENAME = "/scripts/ubuntuInstallJavaScript.sh";
    private static final String INSTALL_MAVEN_UBUNTU_FILENAME = "/scripts/ubuntuInstallMavenScript.sh";
    private static final String INSTALL_DOCKER_UBUNTU_FILENAME = "/scripts/ubuntuInstallDockerScript.sh";
    private static final String PRE_INSTALL_SSH_FILENAME = "/scripts/sshInit.ps1";
    private final Azure azureClient;

    public static AzureVMManagementServiceDelegate getInstance(AzureVMCloud cloud) {
        return cloud.getServiceDelegate();
    }

    public static AzureVMManagementServiceDelegate getInstance(Azure azureClient) {
        if (azureClient == null) {
            throw new NullPointerException("the azure client is null!");
        }
        return new AzureVMManagementServiceDelegate(azureClient);
    }

    public AzureVMDeploymentInfo createDeployment(AzureVMAgentTemplate template, int numberOfAgents) throws AzureCloudException, IOException {
        return this.createDeployment(template, numberOfAgents, AzureVMAgentCleanUpTask.DeploymentRegistrar.getInstance());
    }

    public AzureVMDeploymentInfo createDeployment(AzureVMAgentTemplate template, int numberOfAgents, AzureVMAgentCleanUpTask.DeploymentRegistrar deploymentRegistrar) throws AzureCloudException, IOException {
        String scriptUri = null;
        try (InputStream embeddedTemplate = null;){
            boolean isImageParameterValid;
            String templateLocation;
            String msg;
            boolean useCustomImage;
            LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: createDeployment: Initializing deployment for agentTemplate {0}", template.getTemplateName());
            Map<String, Object> properties = AzureVMAgentTemplate.getTemplateProperties(template);
            Date timestamp = new Date(System.currentTimeMillis());
            String deploymentName = AzureUtil.getDeploymentName(template.getTemplateName(), timestamp);
            String vmBaseName = AzureUtil.getVMBaseName(template.getTemplateName(), deploymentName, (String)properties.get("osType"), numberOfAgents);
            String locationName = AzureUtil.getLocationNameByLabel(template.getLocation());
            String storageAccountName = template.getStorageAccountName();
            String storageAccountType = template.getStorageAccountType();
            String diskType = template.getDiskType();
            int osDiskSize = template.getOsDiskSize();
            String availabilityType = template.getAvailabilityType();
            String availabilitySet = template.getAvailabilitySet();
            if (!template.getResourceGroupName().matches("^[a-zA-Z0-9][a-zA-Z\\-_0-9]{0,62}[a-zA-Z0-9]$")) {
                LOGGER.log(Level.SEVERE, "AzureVMManagementServiceDelegate: createDeployment: ResourceGroup Name {0} is invalid. It should be 1-64 alphanumeric characters", new Object[]{template.getResourceGroupName()});
                throw new Exception("ResourceGroup Name is invalid");
            }
            String resourceGroupName = template.getResourceGroupName();
            LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: createDeployment: Creating a new deployment {0} with VM base name {1}", new Object[]{deploymentName, vmBaseName});
            this.createAzureResourceGroup(this.azureClient, locationName, resourceGroupName);
            this.createStorageAccount(this.azureClient, storageAccountType, storageAccountName, locationName, resourceGroupName);
            StorageAccount storageAccount = this.getStorageAccount(this.azureClient, storageAccountName, resourceGroupName);
            String blobEndpointSuffix = AzureVMManagementServiceDelegate.getBlobEndpointSuffixForTemplate(storageAccount);
            Boolean isBasic = template.isTopLevelType("basic");
            ImageReferenceType referenceType = ImageReferenceType.get(template.getImageReferenceType());
            Boolean preInstallSshInWindows = properties.get("osType").equals("Windows") && properties.get("agentLaunchMethod").equals("SSH") && (isBasic != false || referenceType == ImageReferenceType.REFERENCE || template.getPreInstallSsh());
            boolean useCustomScriptExtension = preInstallSshInWindows != false || properties.get("osType").equals("Windows") && !StringUtils.isBlank((String)((String)properties.get("initScript"))) && ((String)properties.get("agentLaunchMethod")).equals("JNLP");
            boolean useManagedDisk = diskType.equals("managed");
            boolean bl = useCustomImage = isBasic == false && referenceType == ImageReferenceType.CUSTOM;
            if (useCustomScriptExtension) {
                if (useManagedDisk) {
                    msg = "AzureVMManagementServiceDelegate: createDeployment: Use embedded deployment template (with script and managed) {0}";
                    templateLocation = useCustomImage ? EMBEDDED_TEMPLATE_IMAGE_WITH_SCRIPT_MANAGED_FILENAME : (referenceType == ImageReferenceType.CUSTOM_IMAGE ? EMBEDDED_TEMPLATE_IMAGE_ID_WITH_SCRIPT_MANAGED_FILENAME : EMBEDDED_TEMPLATE_WITH_SCRIPT_MANAGED_FILENAME);
                } else {
                    msg = "AzureVMManagementServiceDelegate: createDeployment: Use embedded deployment template (with script) {0}";
                    templateLocation = useCustomImage ? EMBEDDED_TEMPLATE_IMAGE_WITH_SCRIPT_FILENAME : EMBEDDED_TEMPLATE_WITH_SCRIPT_FILENAME;
                }
            } else if (useManagedDisk) {
                msg = "AzureVMManagementServiceDelegate: createDeployment: Use embedded deployment template (with managed) {0}";
                templateLocation = useCustomImage ? EMBEDDED_TEMPLATE_IMAGE_WITH_MANAGED_FILENAME : (referenceType == ImageReferenceType.CUSTOM_IMAGE ? EMBEDDED_TEMPLATE_IMAGE_ID_WITH_MANAGED_FILENAME : EMBEDDED_TEMPLATE_WITH_MANAGED_FILENAME);
            } else {
                msg = "AzureVMManagementServiceDelegate: createDeployment: Use embedded deployment template {0}";
                templateLocation = useCustomImage ? EMBEDDED_TEMPLATE_IMAGE_FILENAME : EMBEDDED_TEMPLATE_FILENAME;
            }
            LOGGER.log(Level.INFO, msg, templateLocation);
            embeddedTemplate = AzureVMManagementServiceDelegate.class.getResourceAsStream(templateLocation);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode tmp = mapper.readTree(embeddedTemplate);
            ObjectNode count = mapper.createObjectNode();
            count.put("type", "int");
            count.put("defaultValue", numberOfAgents);
            ((ObjectNode)ObjectNode.class.cast(tmp.get("parameters"))).replace("count", (JsonNode)count);
            AzureVMManagementServiceDelegate.putVariable(tmp, "vmName", vmBaseName);
            AzureVMManagementServiceDelegate.putVariable(tmp, "location", locationName);
            AzureVMManagementServiceDelegate.putVariable(tmp, "jenkinsTag", "ManagedByAzureVMAgents");
            AzureVMManagementServiceDelegate.putVariable(tmp, "resourceTag", deploymentRegistrar.getDeploymentTag().get());
            AzureVMManagementServiceDelegate.putVariable(tmp, "cloudTag", template.getAzureCloud().getCloudName());
            if (!isBasic.booleanValue() && referenceType == ImageReferenceType.REFERENCE && (isImageParameterValid = this.checkImageParameter(template))) {
                String imageVersion = StringUtils.isNotEmpty((String)template.getImageVersion()) ? template.getImageVersion() : "latest";
                VirtualMachineImage image = this.azureClient.virtualMachineImages().getImage(locationName, template.getImagePublisher(), template.getImageOffer(), template.getImageSku(), imageVersion);
                if (image != null) {
                    PurchasePlan plan = image.plan();
                    if (plan != null) {
                        Iterator resources = (ArrayNode)tmp.get("resources");
                        Iterator iterator = resources.iterator();
                        while (iterator.hasNext()) {
                            JsonNode resource = (JsonNode)iterator.next();
                            String type = resource.get("type").asText();
                            if (!type.contains("virtualMachine")) continue;
                            ObjectNode planNode = mapper.createObjectNode();
                            planNode.put("name", plan.name());
                            planNode.put("publisher", plan.publisher());
                            planNode.put("product", plan.product());
                            ((ObjectNode)ObjectNode.class.cast(resource)).replace("plan", (JsonNode)planNode);
                        }
                    }
                } else {
                    LOGGER.log(Level.SEVERE, "Failed to find the image with publisher:{0} offer:{1} sku:{2} version:{3} when trying to add purchase plan to ARM template", new Object[]{template.getImagePublisher(), template.getImageOffer(), template.getImageSku(), imageVersion});
                }
            }
            boolean msiEnabled = template.isEnableMSI();
            boolean osDiskSizeChanged = osDiskSize > 0;
            boolean availabilitySetEnabled = AvailabilityType.AVAILABILITY_SET.getName().equals(availabilityType);
            if (msiEnabled || osDiskSizeChanged || availabilitySetEnabled) {
                ArrayNode resources = (ArrayNode)tmp.get("resources");
                for (JsonNode resource : resources) {
                    String type = resource.get("type").asText();
                    if (!type.contains("virtualMachine")) continue;
                    if (msiEnabled) {
                        ObjectNode identityNode = mapper.createObjectNode();
                        identityNode.put("type", "systemAssigned");
                        ((ObjectNode)ObjectNode.class.cast(resource)).replace("identity", (JsonNode)identityNode);
                    }
                    if (osDiskSizeChanged) {
                        JsonNode jsonNode = resource.get("properties").get("storageProfile").get("osDisk");
                        ((ObjectNode)ObjectNode.class.cast(jsonNode)).replace("diskSizeGB", (JsonNode)new IntNode(osDiskSize));
                    }
                    if (!availabilitySetEnabled) continue;
                    ObjectNode availabilitySetNode = mapper.createObjectNode();
                    availabilitySetNode.put("id", String.format("[resourceId('Microsoft.Compute/availabilitySets', '%s')]", availabilitySet));
                    JsonNode propertiesNode = resource.get("properties");
                    ((ObjectNode)ObjectNode.class.cast(propertiesNode)).replace("availabilitySet", (JsonNode)availabilitySetNode);
                }
            }
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "imageId");
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "imagePublisher");
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "imageOffer");
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "imageSku");
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "imageVersion");
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "osType");
            AzureVMManagementServiceDelegate.putVariableIfNotBlank(tmp, "image", template.getImage());
            if (useCustomScriptExtension) {
                AzureVMManagementServiceDelegate.putVariable(tmp, "jenkinsServerURL", Jenkins.getInstance().getRootUrl());
                ArrayNode clientSecretsNode = ((ObjectNode)ObjectNode.class.cast(tmp.get("variables"))).putArray("clientSecrets");
                for (int i = 0; i < numberOfAgents; ++i) {
                    clientSecretsNode.add(JnlpSlaveAgentProtocol.SLAVE_SECRET.mac(String.format("%s%d", vmBaseName, i)));
                }
                String scriptName = String.format("%s%s", deploymentName, "init.ps1");
                String initScript = preInstallSshInWindows != false ? IOUtils.toString((InputStream)AzureVMManagementServiceDelegate.class.getResourceAsStream(PRE_INSTALL_SSH_FILENAME), (String)"UTF-8") : (String)properties.get("initScript");
                scriptUri = this.uploadCustomScript(template, scriptName, initScript);
                AzureVMManagementServiceDelegate.putVariable(tmp, "startupScriptURI", scriptUri);
                AzureVMManagementServiceDelegate.putVariable(tmp, "startupScriptName", scriptName);
                List storageKeys = ((StorageAccount)this.azureClient.storageAccounts().getByResourceGroup(template.getResourceGroupName(), storageAccountName)).getKeys();
                if (storageKeys.isEmpty()) {
                    throw AzureCloudException.create("AzureVMManagementServiceDelegate: createDeployment: Exception occurred while fetching the storage account key");
                }
                String storageAccountKey = ((StorageAccountKey)storageKeys.get(0)).value();
                ObjectNode storageAccountKeyNode = mapper.createObjectNode();
                storageAccountKeyNode.put("type", "secureString");
                storageAccountKeyNode.put("defaultValue", storageAccountKey);
                ((ObjectNode)ObjectNode.class.cast(tmp.get("parameters"))).replace("storageAccountKey", (JsonNode)storageAccountKeyNode);
            }
            AzureVMManagementServiceDelegate.putVariable(tmp, "vmSize", template.getVirtualMachineSize());
            StandardUsernamePasswordCredentials creds = template.getVMCredentials();
            AzureVMManagementServiceDelegate.putVariable(tmp, "adminUsername", creds.getUsername());
            AzureVMManagementServiceDelegate.putVariable(tmp, "adminPassword", creds.getPassword().getPlainText());
            AzureVMManagementServiceDelegate.putVariableIfNotBlank(tmp, "storageAccountName", storageAccountName);
            AzureVMManagementServiceDelegate.putVariableIfNotBlank(tmp, "storageAccountType", storageAccountType);
            AzureVMManagementServiceDelegate.putVariableIfNotBlank(tmp, "blobEndpointSuffix", blobEndpointSuffix);
            if (!isBasic.booleanValue() && StringUtils.isNotBlank((String)((String)properties.get("virtualNetworkName")))) {
                AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "virtualNetworkName");
                AzureVMManagementServiceDelegate.copyVariable(tmp, properties, "subnetName");
                if (StringUtils.isNotBlank((String)((String)properties.get("virtualNetworkResourceGroupName")))) {
                    AzureVMManagementServiceDelegate.copyVariable(tmp, properties, "virtualNetworkResourceGroupName");
                } else {
                    AzureVMManagementServiceDelegate.putVariable(tmp, "virtualNetworkResourceGroupName", resourceGroupName);
                }
            } else {
                AzureVMManagementServiceDelegate.addDefaultVNetResourceNode(tmp, mapper, resourceGroupName);
            }
            if (!((Boolean)properties.get("usePrivateIP")).booleanValue()) {
                AzureVMManagementServiceDelegate.addPublicIPResourceNode(tmp, mapper);
            }
            if (StringUtils.isNotBlank((String)((String)properties.get("nsgName")))) {
                AzureVMManagementServiceDelegate.addNSGNode(tmp, mapper, (String)properties.get("nsgName"));
            }
            deploymentRegistrar.registerDeployment(template.getAzureCloud().getCloudName(), template.getResourceGroupName(), deploymentName, scriptUri);
            ((Deployment.DefinitionStages.WithTemplate)((Deployment.DefinitionStages.Blank)this.azureClient.deployments().define(deploymentName)).withExistingResourceGroup(template.getResourceGroupName())).withTemplate(tmp.toString()).withParameters("{}").withMode(DeploymentMode.INCREMENTAL).beginCreate();
            AzureVMDeploymentInfo azureVMDeploymentInfo = new AzureVMDeploymentInfo(deploymentName, vmBaseName, numberOfAgents);
            return azureVMDeploymentInfo;
        }
    }

    private boolean checkImageParameter(AzureVMAgentTemplate template) {
        if (StringUtils.isBlank((String)template.getImagePublisher()) || StringUtils.isBlank((String)template.getImageOffer()) || StringUtils.isBlank((String)template.getImageSku())) {
            LOGGER.log(Level.SEVERE, "Missing Image Reference information when trying to add purchase plan to ARM template");
            return false;
        }
        return true;
    }

    private static void putVariable(JsonNode template, String name, String value) {
        ((ObjectNode)ObjectNode.class.cast(template.get("variables"))).put(name, value);
    }

    private static void putVariableIfNotBlank(JsonNode template, String name, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            AzureVMManagementServiceDelegate.putVariable(template, name, value);
        }
    }

    private static void copyVariable(JsonNode template, Map<String, Object> properties, String name) {
        AzureVMManagementServiceDelegate.putVariable(template, name, (String)properties.get(name));
    }

    private static void copyVariableIfNotBlank(JsonNode template, Map<String, Object> properties, String name) {
        AzureVMManagementServiceDelegate.putVariableIfNotBlank(template, name, (String)properties.get(name));
    }

    private static void addPublicIPResourceNode(JsonNode template, ObjectMapper mapper) throws IOException {
        block14: {
            String ipName = "variables('vmName'), copyIndex(), 'IPName'";
            try (InputStream fragmentStream = AzureVMManagementServiceDelegate.class.getResourceAsStream(PUBLIC_IP_FRAGMENT_FILENAME);){
                JsonNode publicIPFragment = mapper.readTree(fragmentStream);
                ((ArrayNode)ArrayNode.class.cast(template.get("resources"))).add(publicIPFragment);
                ArrayNode resourcesNodes = (ArrayNode)ArrayNode.class.cast(template.get("resources"));
                Iterator resourcesNodesIter = resourcesNodes.elements();
                while (resourcesNodesIter.hasNext()) {
                    JsonNode resourcesNode = (JsonNode)resourcesNodesIter.next();
                    JsonNode typeNode = resourcesNode.get("type");
                    if (typeNode == null || !typeNode.asText().equals("Microsoft.Network/networkInterfaces")) continue;
                    ArrayNode dependsOnNode = (ArrayNode)ArrayNode.class.cast(resourcesNode.get("dependsOn"));
                    dependsOnNode.add("[concat('Microsoft.Network/publicIPAddresses/',variables('vmName'), copyIndex(), 'IPName')]");
                    ArrayNode ipConfigurationsNode = (ArrayNode)ArrayNode.class.cast(resourcesNode.get("properties").get("ipConfigurations"));
                    Iterator ipConfigNodeIter = ipConfigurationsNode.elements();
                    while (ipConfigNodeIter.hasNext()) {
                        JsonNode ipConfigNode = (JsonNode)ipConfigNodeIter.next();
                        JsonNode nameNode = ipConfigNode.get("name");
                        if (nameNode == null || !nameNode.asText().equals("ipconfig1")) continue;
                        ObjectNode propertiesNode = (ObjectNode)ObjectNode.class.cast(ipConfigNode.get("properties"));
                        ObjectNode publicIPIdNode = mapper.createObjectNode();
                        publicIPIdNode.put("id", "[resourceId('Microsoft.Network/publicIPAddresses', concat(variables('vmName'), copyIndex(), 'IPName'))]");
                        propertiesNode.set("publicIPAddress", (JsonNode)publicIPIdNode);
                        break block14;
                    }
                    break;
                }
            }
        }
    }

    private static void addNSGNode(JsonNode template, ObjectMapper mapper, String nsgName) throws IOException {
        ((ObjectNode)ObjectNode.class.cast(template.get("variables"))).put("nsgName", nsgName);
        ArrayNode resourcesNodes = (ArrayNode)ArrayNode.class.cast(template.get("resources"));
        Iterator resourcesNodesIter = resourcesNodes.elements();
        while (resourcesNodesIter.hasNext()) {
            JsonNode resourcesNode = (JsonNode)resourcesNodesIter.next();
            JsonNode typeNode = resourcesNode.get("type");
            if (typeNode == null || !typeNode.asText().equals("Microsoft.Network/networkInterfaces")) continue;
            ObjectNode nsgNode = mapper.createObjectNode();
            nsgNode.put("id", "[resourceId('Microsoft.Network/networkSecurityGroups', variables('nsgName'))]");
            ObjectNode propertiesNode = (ObjectNode)ObjectNode.class.cast(resourcesNode.get("properties"));
            propertiesNode.set("networkSecurityGroup", (JsonNode)nsgNode);
            break;
        }
    }

    private static void addDefaultVNetResourceNode(JsonNode template, ObjectMapper mapper, String resourceGroupName) throws IOException {
        try (InputStream fragmentStream = null;){
            String virtualNetworkName = "jenkinsarm-vnet";
            String subnetName = "jenkinsarm-snet";
            ((ObjectNode)ObjectNode.class.cast(template.get("variables"))).put("virtualNetworkName", "jenkinsarm-vnet");
            ((ObjectNode)ObjectNode.class.cast(template.get("variables"))).put("virtualNetworkResourceGroupName", resourceGroupName);
            ((ObjectNode)ObjectNode.class.cast(template.get("variables"))).put("subnetName", "jenkinsarm-snet");
            fragmentStream = AzureVMManagementServiceDelegate.class.getResourceAsStream(VIRTUAL_NETWORK_TEMPLATE_FRAGMENT_FILENAME);
            JsonNode virtualNetworkFragment = mapper.readTree(fragmentStream);
            ((ArrayNode)ArrayNode.class.cast(template.get("resources"))).add(virtualNetworkFragment);
            ArrayNode resourcesNodes = (ArrayNode)ArrayNode.class.cast(template.get("resources"));
            Iterator resourcesNodesIter = resourcesNodes.elements();
            while (resourcesNodesIter.hasNext()) {
                JsonNode resourcesNode = (JsonNode)resourcesNodesIter.next();
                JsonNode typeNode = resourcesNode.get("type");
                if (typeNode == null || !typeNode.asText().equals("Microsoft.Network/networkInterfaces")) continue;
                ArrayNode dependsOnNode = (ArrayNode)ArrayNode.class.cast(resourcesNode.get("dependsOn"));
                dependsOnNode.add("[concat('Microsoft.Network/virtualNetworks/', variables('virtualNetworkName'))]");
                break;
            }
        }
    }

    private static String paddedScriptForPageBlob(String sourceString) throws Exception {
        int currentStringLength;
        int pageSize = 512;
        int paddedStringLength = (currentStringLength + 512 - 1) / 512 * 512;
        StringBuilder fillString = new StringBuilder();
        for (currentStringLength = sourceString.getBytes(StandardCharsets.UTF_8).length; currentStringLength < paddedStringLength; ++currentStringLength) {
            fillString.append(' ');
        }
        return sourceString.concat(fillString.toString());
    }

    public String uploadCustomScript(AzureVMAgentTemplate template, String targetScriptName, String initScript) throws AzureCloudException {
        String targetStorageAccount = template.getStorageAccountName();
        String targetStorageAccountType = template.getStorageAccountType();
        String resourceGroupName = template.getResourceGroupName();
        String location = template.getLocation();
        try {
            this.createAzureResourceGroup(this.azureClient, location, resourceGroupName);
            this.createStorageAccount(this.azureClient, targetStorageAccountType, targetStorageAccount, location, resourceGroupName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got exception when checking the storage account for custom scripts", e);
        }
        int scriptLength = 0;
        try {
            CloudBlobContainer container = this.getCloudBlobContainer(this.azureClient, resourceGroupName, targetStorageAccount, "jenkinsconfig");
            container.createIfNotExists();
            CloudPageBlob blob = container.getPageBlobReference(targetScriptName);
            String scriptText = AzureVMManagementServiceDelegate.paddedScriptForPageBlob(initScript);
            scriptLength = scriptText.getBytes(StandardCharsets.UTF_8).length;
            blob.create((long)scriptLength);
            ByteArrayInputStream stream = new ByteArrayInputStream(scriptText.getBytes(StandardCharsets.UTF_8));
            blob.upload((InputStream)stream, (long)scriptText.length(), AccessCondition.generateEmptyCondition(), null, null);
            return blob.getUri().toString();
        }
        catch (Exception e) {
            throw AzureCloudException.create(String.format("Failed to create Page Blob with script's length: %d", scriptLength), e);
        }
    }

    public String uploadCustomScript(AzureVMAgentTemplate template, String targetScriptName) throws AzureCloudException {
        return this.uploadCustomScript(template, targetScriptName, template.getInitScript());
    }

    public void setVirtualMachineDetails(AzureVMAgent azureAgent, AzureVMAgentTemplate template) throws AzureCloudException {
        VirtualMachine vm = (VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(template.getResourceGroupName(), azureAgent.getNodeName());
        PublicIPAddress publicIP = vm.getPrimaryPublicIPAddress();
        String publicIPStr = "";
        String privateIP = vm.getPrimaryNetworkInterface().primaryPrivateIP();
        String fqdn = "";
        if (publicIP == null) {
            fqdn = privateIP;
            LOGGER.log(Level.INFO, "The Azure agent doesn't have a public IP. Will use the private IP");
        } else {
            fqdn = publicIP.fqdn();
            publicIPStr = publicIP.ipAddress();
        }
        azureAgent.setPublicDNSName(fqdn);
        azureAgent.setSshPort(22);
        azureAgent.setPublicIP(publicIPStr);
        azureAgent.setPrivateIP(privateIP);
        LOGGER.log(Level.INFO, "Azure agent details:\nnodeName{0}\nadminUserName={1}\nshutdownOnIdle={2}\nretentionTimeInMin={3}\nlabels={4}", new Object[]{azureAgent.getNodeName(), azureAgent.getVMCredentialsId(), azureAgent.isShutdownOnIdle(), azureAgent.getRetentionTimeInMin(), azureAgent.getLabelString()});
    }

    public void attachPublicIP(AzureVMAgent azureAgent, AzureVMAgentTemplate template) throws AzureCloudException {
        VirtualMachine vm = null;
        try {
            vm = (VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(template.getResourceGroupName(), azureAgent.getNodeName());
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
        LOGGER.log(Level.INFO, "Trying to attach a public IP to the agent {0}", azureAgent.getNodeName());
        if (vm != null) {
            if (vm.getPrimaryPublicIPAddress() == null) {
                try {
                    ((NetworkInterface.Update)vm.getPrimaryNetworkInterface().update()).withNewPrimaryPublicIPAddress((Creatable)((PublicIPAddress.DefinitionStages.WithCreate)((PublicIPAddress.DefinitionStages.WithGroup)((PublicIPAddress.DefinitionStages.Blank)this.azureClient.publicIPAddresses().define(azureAgent.getNodeName() + "IPName")).withRegion(template.getLocation())).withExistingResourceGroup(template.getResourceGroupName())).withLeafDomainLabel(azureAgent.getNodeName())).apply();
                }
                catch (Exception e) {
                    throw AzureCloudException.create(e);
                }
                this.setVirtualMachineDetails(azureAgent, template);
            } else {
                LOGGER.log(Level.INFO, "Agent {0} already has a public IP", azureAgent.getNodeName());
            }
        } else {
            LOGGER.log(Level.WARNING, "Could not find agent {0} in Azure", azureAgent.getNodeName());
        }
    }

    private boolean virtualMachineExists(String vmName, String resourceGroupName) throws AzureCloudException {
        LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: virtualMachineExists: check for {0}", vmName);
        VirtualMachine vm = null;
        try {
            vm = (VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(resourceGroupName, vmName);
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
        if (vm != null) {
            LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: virtualMachineExists: {0} exists", vmName);
            return true;
        }
        LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: virtualMachineExists: {0} doesn't exist", vmName);
        return false;
    }

    public static boolean virtualMachineExists(AzureVMAgent agent) {
        try {
            AzureVMManagementServiceDelegate delegate = agent.getServiceDelegate();
            if (delegate != null) {
                return delegate.virtualMachineExists(agent.getNodeName(), agent.getResourceGroupName());
            }
            return false;
        }
        catch (AzureCloudException e) {
            LOGGER.log(Level.WARNING, "AzureVMManagementServiceDelegate: virtualMachineExists: error while determining whether vm exists", e);
            return false;
        }
    }

    public AzureVMAgent parseResponse(ProvisioningActivity.Id id, String vmname, String deploymentName, AzureVMAgentTemplate template, OperatingSystemTypes osType) throws AzureCloudException {
        try {
            LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: parseDeploymentResponse: \n\tfound agent {0}\n\tOS type {1}\n\tnumber of executors {2}", new Object[]{vmname, osType, template.getNoOfParallelJobs()});
            AzureVMCloud azureCloud = template.getAzureCloud();
            Map<String, Object> properties = AzureVMAgentTemplate.getTemplateProperties(template);
            VirtualMachine vm = (VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(template.getResourceGroupName(), vmname);
            PublicIPAddress publicIP = vm.getPrimaryPublicIPAddress();
            String privateIP = vm.getPrimaryNetworkInterface().primaryPrivateIP();
            String fqdn = "";
            fqdn = publicIP == null ? privateIP : publicIP.fqdn();
            return new AzureVMAgent(id, vmname, template.getTemplateName(), template.getTemplateDesc(), osType, template.getAgentWorkspace(), (Integer)properties.get("noOfParallelJobs"), template.getUseAgentAlwaysIfAvail(), template.getLabels(), template.getAzureCloud().getDisplayName(), template.getCredentialsId(), null, null, (String)properties.get("jvmOptions"), template.isShutdownOnIdle(), false, deploymentName, template.getRetentionStrategy(), (String)properties.get("initScript"), azureCloud.getAzureCredentialsId(), (String)properties.get("agentLaunchMethod"), CleanUpAction.DEFAULT, null, template.getResourceGroupName(), (Boolean)properties.get("executeInitScriptAsRoot"), (Boolean)properties.get("doNotUseMachineIfInitFails"), (Boolean)properties.get("enableMSI"), template, fqdn);
        }
        catch (Descriptor.FormException e) {
            throw AzureCloudException.create("AzureVMManagementServiceDelegate: parseResponse: Exception occurred while creating agent object", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw AzureCloudException.create("AzureVMManagementServiceDelegate: parseResponse: Exception occurred while creating agent object", e);
        }
    }

    private static Set<String> getAvailableLocationsStandard() {
        HashSet<String> locations = new HashSet<String>();
        locations.add("East US");
        locations.add("West US");
        locations.add("South Central US");
        locations.add("Central US");
        locations.add("North Central US");
        locations.add("North Europe");
        locations.add("West Europe");
        locations.add("Southeast Asia");
        locations.add("East Asia");
        locations.add("Japan West");
        locations.add("Japan East");
        locations.add("Brazil South");
        locations.add("Australia Southeast");
        locations.add("Australia East");
        locations.add("Central India");
        locations.add("South India");
        locations.add("West India");
        return locations;
    }

    private static Set<String> getAvailableLocationsChina() {
        HashSet<String> locations = new HashSet<String>();
        locations.add("China North");
        locations.add("China East");
        return locations;
    }

    private static Map<String, List<String>> getAvailableRoleSizes() {
        HashMap<String, List<String>> sizes = new HashMap<String, List<String>>();
        sizes.put("East US", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("West US", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("South Central US", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("Central US", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("North Central US", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("East US 2", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("North Europe", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("West Europe", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("Southeast Asia", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("East Asia", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_F1", "Standard_F16", "Standard_F2", "Standard_F4", "Standard_F8"));
        sizes.put("Japan West", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("Japan East", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("Brazil South", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("Australia Southeast", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("Australia East", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("Central India", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1_v2", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("South India", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1_v2", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("West India", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1_v2", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_F1", "Standard_F16", "Standard_F2", "Standard_F4", "Standard_F8"));
        sizes.put("China North", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("China East", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_F1", "Standard_F16", "Standard_F2", "Standard_F4", "Standard_F8"));
        return sizes;
    }

    private static Map<String, Map<String, String>> getDefaultImageProperties() {
        HashMap<String, Map<String, String>> imageProperties = new HashMap<String, Map<String, String>>();
        imageProperties.put("Windows Server 2016", new HashMap());
        imageProperties.put("Ubuntu 16.04 LTS", new HashMap());
        ((Map)imageProperties.get("Windows Server 2016")).put("defaultImagePublisher", "MicrosoftWindowsServer");
        ((Map)imageProperties.get("Windows Server 2016")).put("defaultImageOffer", "WindowsServer");
        ((Map)imageProperties.get("Windows Server 2016")).put("defaultImageSku", "2016-Datacenter");
        ((Map)imageProperties.get("Windows Server 2016")).put("defaultDockerImageSku", "2016-Datacenter-with-Containers");
        ((Map)imageProperties.get("Windows Server 2016")).put("defaultImageVersion", "latest");
        ((Map)imageProperties.get("Windows Server 2016")).put("defaultOsType", "Windows");
        ((Map)imageProperties.get("Windows Server 2016")).put("defaultLaunchMethod", "SSH");
        ((Map)imageProperties.get("Ubuntu 16.04 LTS")).put("defaultImagePublisher", "Canonical");
        ((Map)imageProperties.get("Ubuntu 16.04 LTS")).put("defaultImageOffer", "UbuntuServer");
        ((Map)imageProperties.get("Ubuntu 16.04 LTS")).put("defaultImageSku", "16.04-LTS");
        ((Map)imageProperties.get("Ubuntu 16.04 LTS")).put("defaultDockerImageSku", "16.04-LTS");
        ((Map)imageProperties.get("Ubuntu 16.04 LTS")).put("defaultImageVersion", "latest");
        ((Map)imageProperties.get("Ubuntu 16.04 LTS")).put("defaultOsType", "Linux");
        ((Map)imageProperties.get("Ubuntu 16.04 LTS")).put("defaultLaunchMethod", "SSH");
        return imageProperties;
    }

    private static Map<String, Map<String, String>> getPreInstalledToolsScript() {
        HashMap<String, Map<String, String>> tools = new HashMap<String, Map<String, String>>();
        tools.put("Windows Server 2016", new HashMap());
        tools.put("Ubuntu 16.04 LTS", new HashMap());
        try {
            ((Map)tools.get("Windows Server 2016")).put("Java", IOUtils.toString((InputStream)AzureVMManagementServiceDelegate.class.getResourceAsStream(INSTALL_JAVA_WINDOWS_FILENAME), (String)"UTF-8"));
            ((Map)tools.get("Windows Server 2016")).put("Maven", IOUtils.toString((InputStream)AzureVMManagementServiceDelegate.class.getResourceAsStream(INSTALL_MAVEN_WINDOWS_FILENAME), (String)"UTF-8"));
            ((Map)tools.get("Windows Server 2016")).put("Git", IOUtils.toString((InputStream)AzureVMManagementServiceDelegate.class.getResourceAsStream(INSTALL_GIT_WINDOWS_FILENAME), (String)"UTF-8"));
            ((Map)tools.get("Windows Server 2016")).put("Jnlp", IOUtils.toString((InputStream)AzureVMManagementServiceDelegate.class.getResourceAsStream(INSTALL_JNLP_WINDOWS_FILENAME), (String)"UTF-8"));
            ((Map)tools.get("Ubuntu 16.04 LTS")).put("Java", IOUtils.toString((InputStream)AzureVMManagementServiceDelegate.class.getResourceAsStream(INSTALL_JAVA_UBUNTU_FILENAME), (String)"UTF-8"));
            ((Map)tools.get("Ubuntu 16.04 LTS")).put("Maven", IOUtils.toString((InputStream)AzureVMManagementServiceDelegate.class.getResourceAsStream(INSTALL_MAVEN_UBUNTU_FILENAME), (String)"UTF-8"));
            ((Map)tools.get("Ubuntu 16.04 LTS")).put("Git", IOUtils.toString((InputStream)AzureVMManagementServiceDelegate.class.getResourceAsStream(INSTALL_GIT_UBUNTU_FILENAME), (String)"UTF-8"));
            ((Map)tools.get("Ubuntu 16.04 LTS")).put("Docker", IOUtils.toString((InputStream)AzureVMManagementServiceDelegate.class.getResourceAsStream(INSTALL_DOCKER_UBUNTU_FILENAME), (String)"UTF-8"));
            return tools;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "AzureVMManagementServiceDelegate: getPreInstalledToolsScript: Get pre-installed tools script {0} failed.", e);
            return tools;
        }
    }

    public Set<String> getVirtualMachineLocations(String envNameOrUrl) {
        if (envNameOrUrl == null) {
            return null;
        }
        envNameOrUrl = envNameOrUrl.toLowerCase();
        try {
            return LocationCache.getLocation(this.azureClient, envNameOrUrl);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AzureVMManagementServiceDelegate: getVirtualMachineLocations: error while fetching the regions {0}. Will return default list ", e);
            if (envNameOrUrl.contains("china")) {
                return AVAILABLE_LOCATIONS_CHINA;
            }
            return AVAILABLE_LOCATIONS_STD;
        }
    }

    public List<String> getVMSizes(String location) {
        if (location == null || location.isEmpty()) {
            return DEFAULT_VM_SIZES;
        }
        try {
            ArrayList<String> ret = new ArrayList<String>();
            PagedList vmSizes = this.azureClient.virtualMachines().sizes().listByRegion(location);
            for (VirtualMachineSize vmSize : vmSizes) {
                ret.add(vmSize.name());
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AzureVMManagementServiceDelegate: getVMSizes: error while fetching the VM sizes {0}. Will return default list ", e);
            return AVAILABLE_ROLE_SIZES.get(location);
        }
    }

    public String verifyConfiguration(String resourceGroupName, String maxVMLimit, String timeOut) {
        try {
            String result;
            if (!AzureUtil.isValidTimeOut(timeOut)) {
                return "Invalid Timeout, Should be a positive number, minimum value 1200";
            }
            if (!AzureUtil.isValidResourceGroupName(resourceGroupName)) {
                return "Error: " + Messages.Azure_GC_Template_ResourceGroupName_Err();
            }
            if (!AzureUtil.isValidMAxVMLimit(maxVMLimit)) {
                return "Invalid Limit, Should be a positive number, e.g. 10";
            }
            if (AzureUtil.isValidTimeOut(timeOut) && AzureUtil.isValidMAxVMLimit(maxVMLimit) && AzureUtil.isValidResourceGroupName(resourceGroupName) && !(result = this.verifyConfiguration(resourceGroupName)).matches("Success")) {
                return Messages.Azure_GC_Template_Val_Profile_Err();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error validating profile", e);
            return Messages.Azure_GC_Template_Val_Profile_Err();
        }
        return "Success";
    }

    public String verifyConfiguration(final String resourceGroupName) {
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws Exception {
                AzureVMManagementServiceDelegate.this.azureClient.storageAccounts().getByResourceGroup(resourceGroupName, "CI_SYSTEM");
                return "Success";
            }
        };
        try {
            int maxRetries = 3;
            int maxWaitIntervalInSeconds = 2;
            return ExecutionEngine.executeWithRetry(task, new ExponentialRetryStrategy(3, 2));
        }
        catch (AzureCloudException e) {
            LOGGER.log(Level.SEVERE, "Error validating configuration", e);
            return "Failure: Exception occurred while validating subscription configuration " + e;
        }
    }

    private VMStatus getVirtualMachineStatus(String vmName, String resourceGroupName) throws AzureCloudException {
        VirtualMachine vm;
        try {
            vm = (VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(resourceGroupName, vmName);
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
        String provisioningState = vm.provisioningState();
        if (!provisioningState.equalsIgnoreCase("succeeded")) {
            if (provisioningState.equalsIgnoreCase("updating")) {
                return VMStatus.UPDATING;
            }
            return VMStatus.PROVISIONING_OR_DEPROVISIONING;
        }
        return VMStatus.fromPowerState(vm.powerState());
    }

    public boolean isVMAliveOrHealthy(AzureVMAgent agent) throws AzureCloudException {
        VMStatus status = this.getVirtualMachineStatus(agent.getNodeName(), agent.getResourceGroupName());
        int maxRetryCount = 40;
        for (int currentRetryCount = 0; status.equals((Object)VMStatus.UPDATING) && currentRetryCount < 40; ++currentRetryCount) {
            status = this.getVirtualMachineStatus(agent.getNodeName(), agent.getResourceGroupName());
            LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: isVMAliveOrHealthy: Status is Updating, wait for another 30 seconds");
            int sleepInMills = 30000;
            try {
                Thread.sleep(30000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: isVMAliveOrHealthy: status {0}", status.toString());
        return !VMStatus.PROVISIONING_OR_DEPROVISIONING.equals((Object)status) && !VMStatus.UPDATING.equals((Object)status) && !VMStatus.DEALLOCATING.equals((Object)status) && !VMStatus.STOPPED.equals((Object)status) && !VMStatus.DEALLOCATED.equals((Object)status);
    }

    public int getVirtualMachineCount(String cloudName, String resourceGroupName) {
        try {
            PagedList vms = this.azureClient.virtualMachines().listByResourceGroup(resourceGroupName);
            int count = 0;
            AzureUtil.DeploymentTag deployTag = new AzureUtil.DeploymentTag();
            for (VirtualMachine vm : vms) {
                Map tags = vm.tags();
                if (!tags.containsKey("JenkinsResourceTag") || !deployTag.isFromSameInstance(new AzureUtil.DeploymentTag((String)tags.get("JenkinsResourceTag")))) continue;
                if (tags.containsKey("JenkinsCloudTag")) {
                    if (!((String)tags.get("JenkinsCloudTag")).equals(cloudName)) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AzureVMManagementServiceDelegate: getVirtualMachineCount: Got exception while getting hosted services info, assuming that there are no hosted services {0}", e);
            return 0;
        }
    }

    public void shutdownVirtualMachine(AzureVMAgent agent) {
        LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: shutdownVirtualMachine: called for {0}", agent.getNodeName());
        try {
            ((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(agent.getResourceGroupName(), agent.getNodeName())).deallocate();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AzureVMManagementServiceDelegate: provision: could not terminate or shutdown {0}, {1}", new Object[]{agent.getNodeName(), e});
        }
    }

    public static void terminateVirtualMachine(AzureVMAgent agent) throws AzureCloudException {
        AzureVMManagementServiceDelegate delegate = agent.getServiceDelegate();
        if (delegate != null) {
            delegate.terminateVirtualMachine(agent.getNodeName(), agent.getResourceGroupName(), new ExecutionEngine());
        }
    }

    public void terminateVirtualMachine(String vmName, String resourceGroupName) throws AzureCloudException {
        this.terminateVirtualMachine(vmName, resourceGroupName, new ExecutionEngine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateVirtualMachine(String vmName, String resourceGroupName, ExecutionEngine executionEngine) throws AzureCloudException {
        try {
            if (this.virtualMachineExists(vmName, resourceGroupName)) {
                ArrayList<URI> diskUrisToRemove = new ArrayList<URI>();
                ArrayList<String> diskIdToRemove = new ArrayList<String>();
                if (!((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(resourceGroupName, vmName)).isManagedDiskEnabled()) {
                    diskUrisToRemove.add(new URI(((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(resourceGroupName, vmName)).osUnmanagedDiskVhdUri()));
                } else {
                    diskIdToRemove.add(((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(resourceGroupName, vmName)).osDiskId());
                }
                LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: terminateVirtualMachine: Removing virtual machine {0}", vmName);
                this.azureClient.virtualMachines().deleteByResourceGroup(resourceGroupName, vmName);
                for (URI diskUri : diskUrisToRemove) {
                    this.removeStorageBlob(diskUri, resourceGroupName);
                }
                for (String id : diskIdToRemove) {
                    LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: terminateVirtualMachine: Removing managed disk with id: {0}", id);
                    this.azureClient.disks().deleteById(id);
                }
                if (!diskIdToRemove.isEmpty()) {
                    this.removeImage(this.azureClient, vmName, resourceGroupName);
                }
            }
            LOGGER.log(Level.INFO, "Clean operation starting for {0} NIC and IP", vmName);
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.WARNING, "AzureVMManagementServiceDelegate: terminateVirtualMachine: while deleting VM", e);
                if (!"ResourceNotFound".equalsIgnoreCase(e.getMessage())) {
                    throw AzureCloudException.create(e);
                }
                LOGGER.log(Level.INFO, "Clean operation starting for {0} NIC and IP", vmName);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.INFO, "Clean operation starting for {0} NIC and IP", vmName);
                executionEngine.executeAsync(new Callable<Void>(resourceGroupName, vmName){
                    final /* synthetic */ String val$resourceGroupName;
                    final /* synthetic */ String val$vmName;
                    {
                        this.val$resourceGroupName = string;
                        this.val$vmName = string2;
                    }

                    @Override
                    public Void call() throws Exception {
                        AzureVMManagementServiceDelegate.this.removeIPName(this.val$resourceGroupName, this.val$vmName);
                        return null;
                    }
                }, new NoRetryStrategy());
                throw throwable;
            }
            executionEngine.executeAsync(new /* invalid duplicate definition of identical inner class */, new NoRetryStrategy());
        }
        executionEngine.executeAsync(new /* invalid duplicate definition of identical inner class */, new NoRetryStrategy());
    }

    public void removeImage(Azure azureClient, String vmName, String resourceGroupName) {
        PagedList customImages = azureClient.virtualMachineCustomImages().listByResourceGroup(resourceGroupName);
        for (VirtualMachineCustomImage image : customImages) {
            String prefix = StringUtils.substringBefore((String)image.name(), (String)"Image");
            if (!StringUtils.contains((String)vmName, (String)prefix)) continue;
            LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: terminateVirtualMachine: Removing image with name: {0}", image.name());
            azureClient.virtualMachineCustomImages().deleteById(image.id());
        }
    }

    public void removeStorageBlob(URI blobURI, String resourceGroupName) throws Exception {
        String storageAccountName = blobURI.getHost().split("\\.")[0];
        String containerName = PathUtility.getContainerNameFromUri((URI)blobURI, (boolean)false);
        String blobName = PathUtility.getBlobNameFromURI((URI)blobURI, (boolean)false);
        LOGGER.log(Level.INFO, "removeStorageBlob: Removing blob {0}, in container {1} of storage account {2}", new Object[]{blobName, containerName, storageAccountName});
        CloudBlobContainer container = this.getCloudBlobContainer(this.azureClient, resourceGroupName, storageAccountName, containerName);
        container.getBlockBlobReference(blobName).deleteIfExists();
        if (containerName.startsWith("jnk")) {
            Iterable blobs = container.listBlobs();
            if (blobs.iterator().hasNext()) {
                return;
            }
            LOGGER.log(Level.INFO, "removeStorageBlob: Removing empty container ", containerName);
            container.delete();
        }
    }

    public void removeIPName(String resourceGroupName, String vmName) throws AzureCloudException {
        String nic = vmName + "NIC";
        try {
            LOGGER.log(Level.INFO, "Remove NIC {0}", nic);
            this.azureClient.networkInterfaces().deleteByResourceGroup(resourceGroupName, nic);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AzureVMManagementServiceDelegate: removeIPName: while deleting NIC", e);
        }
        String ip = vmName + "IPName";
        try {
            LOGGER.log(Level.INFO, "Remove IP {0}", ip);
            this.azureClient.publicIPAddresses().deleteByResourceGroup(resourceGroupName, ip);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AzureVMManagementServiceDelegate: removeIPName: while deleting IPName", e);
        }
    }

    public void restartVirtualMachine(AzureVMAgent agent) throws AzureCloudException {
        try {
            ((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(agent.getResourceGroupName(), agent.getNodeName())).restart();
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
    }

    public void startVirtualMachine(AzureVMAgent agent) throws AzureCloudException {
        LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: startVirtualMachine: {0}", agent.getNodeName());
        int retryCount = 0;
        boolean successful = false;
        while (!successful) {
            try {
                ((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(agent.getResourceGroupName(), agent.getNodeName())).start();
                successful = true;
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: startVirtualMachine: got exception while starting VM {0}. Will retry again after 30 seconds. Current retry count {1} / {2}\n", new Object[]{agent.getNodeName(), retryCount, 20});
                if (retryCount > 20) {
                    throw AzureCloudException.create(e);
                }
                ++retryCount;
                int sleepMillis = 30000;
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Network getVirtualNetwork(String virtualNetworkName, String resourceGroupName) {
        try {
            return (Network)this.azureClient.networks().getByResourceGroup(resourceGroupName, virtualNetworkName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "AzureVMManagementServiceDelegate: getVirtualNetworkInfo: Got exception while getting virtual network info: ", e);
            return null;
        }
    }

    private static String getLocationName(String location) {
        try {
            return Region.findByLabelOrName((String)location).name();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> verifyTemplate(String templateName, String labels, String location, String virtualMachineSize, String storageAccountName, String storageAccountType, String noOfParallelJobs, String imageTopLevelType, ImageReferenceType referenceType, String builtInImage, String image, String osType, String imageId, String imagePublisher, String imageOffer, String imageSku, String imageVersion, String agentLaunchMethod, String initScript, String credentialsId, String virtualNetworkName, String virtualNetworkResourceGroupName, String subnetName, AzureVMCloudBaseRetentionStrategy retentionStrategy, String jvmOptions, String resourceGroupName, boolean returnOnSingleError, boolean usePrivateIP, String nsgName) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            String validationResult = this.verifyTemplateName(templateName);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && errors.size() > 0) {
                return errors;
            }
            validationResult = AzureVMManagementServiceDelegate.verifyNoOfExecutors(noOfParallelJobs);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && errors.size() > 0) {
                return errors;
            }
            validationResult = AzureVMManagementServiceDelegate.verifyRetentionTime(retentionStrategy);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && errors.size() > 0) {
                return errors;
            }
            String adminPassword = "";
            try {
                StandardUsernamePasswordCredentials creds = AzureUtil.getCredentials(credentialsId);
                adminPassword = creds.getPassword().getPlainText();
            }
            catch (AzureCloudException e) {
                LOGGER.log(Level.SEVERE, "Could not load the VM credentials", e);
            }
            validationResult = AzureVMManagementServiceDelegate.verifyAdminPassword(adminPassword);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && errors.size() > 0) {
                return errors;
            }
            validationResult = AzureVMManagementServiceDelegate.verifyJvmOptions(jvmOptions);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && errors.size() > 0) {
                return errors;
            }
            validationResult = AzureVMManagementServiceDelegate.verifyImageParameters(imageTopLevelType, referenceType, builtInImage, image, osType, imageId, imagePublisher, imageOffer, imageSku, imageVersion);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && errors.size() > 0) {
                return errors;
            }
            this.verifyTemplateAsync(location, imageTopLevelType, referenceType, builtInImage, image, imageId, imagePublisher, imageOffer, imageSku, imageVersion, storageAccountName, storageAccountType, virtualNetworkName, virtualNetworkResourceGroupName, subnetName, resourceGroupName, errors, usePrivateIP, nsgName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error validating template", e);
            errors.add("Error occurred while validating Azure Profile");
        }
        return errors;
    }

    private void verifyTemplateAsync(final String location, final String imageTopLevelType, final ImageReferenceType referenceType, final String builtInImage, final String image, final String imageId, final String imagePublisher, final String imageOffer, final String imageSku, final String imageVersion, final String storageAccountName, final String storageAccountType, final String virtualNetworkName, final String virtualNetworkResourceGroupName, final String subnetName, final String resourceGroupName, List<String> errors, final boolean usePrivateIP, final String nsgName) {
        ArrayList<Callable<String>> verificationTaskList = new ArrayList<Callable<String>>();
        Callable<String> callVerifyVirtualNetwork = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AzureVMManagementServiceDelegate.this.verifyVirtualNetwork(virtualNetworkName, virtualNetworkResourceGroupName, subnetName, usePrivateIP, resourceGroupName);
            }
        };
        verificationTaskList.add(callVerifyVirtualNetwork);
        Callable<String> callVerifyVirtualMachineImage = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AzureVMManagementServiceDelegate.this.verifyVirtualMachineImage(location, storageAccountName, imageTopLevelType, referenceType, builtInImage, image, imageId, imagePublisher, imageOffer, imageSku, imageVersion);
            }
        };
        verificationTaskList.add(callVerifyVirtualMachineImage);
        Callable<String> callVerifyStorageAccountName = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AzureVMManagementServiceDelegate.this.verifyStorageAccountName(resourceGroupName, storageAccountName, storageAccountType);
            }
        };
        verificationTaskList.add(callVerifyStorageAccountName);
        Callable<String> callVerifyNSG = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AzureVMManagementServiceDelegate.this.verifyNSG(resourceGroupName, nsgName);
            }
        };
        verificationTaskList.add(callVerifyNSG);
        try {
            for (Future validationResult : AzureVMCloud.getThreadPool().invokeAll(verificationTaskList)) {
                try {
                    int timeoutInSeconds = 60;
                    String result = (String)validationResult.get(60L, TimeUnit.SECONDS);
                    AzureVMManagementServiceDelegate.addValidationResultIfFailed(result, errors);
                }
                catch (ExecutionException executionException) {
                    errors.add("Exception occurred while validating temaplate " + executionException);
                }
                catch (TimeoutException timeoutException) {
                    errors.add("Exception occurred while validating template " + timeoutException);
                }
                catch (Exception others) {
                    errors.add(others.getMessage() + others);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            errors.add("Exception occurred while validating template " + interruptedException);
        }
    }

    private static void addValidationResultIfFailed(String validationResult, List<String> errors) {
        if (!validationResult.equalsIgnoreCase("Success")) {
            errors.add(validationResult);
        }
    }

    public String verifyTemplateName(String templateName) {
        if (StringUtils.lowerCase((String)templateName).contains("login") || StringUtils.lowerCase((String)templateName).contains("microsoft") || StringUtils.lowerCase((String)templateName).contains("windows") || StringUtils.lowerCase((String)templateName).contains("xbox")) {
            return Messages.Azure_GC_Template_Name_Reserved();
        }
        return "Success";
    }

    public static String verifyNoOfExecutors(String noOfExecutors) {
        try {
            if (StringUtils.isBlank((String)noOfExecutors)) {
                return Messages.Azure_GC_Template_Executors_Null_Or_Empty();
            }
            AzureUtil.isPositiveInteger(noOfExecutors);
            return "Success";
        }
        catch (IllegalArgumentException e) {
            return Messages.Azure_GC_Template_Executors_Not_Positive();
        }
    }

    public static String verifyRetentionTime(AzureVMCloudBaseRetentionStrategy retentionStrategy) {
        try {
            if (retentionStrategy == null) {
                return Messages.Azure_GC_Template_RT_Null_Or_Empty();
            }
            return "Success";
        }
        catch (IllegalArgumentException e) {
            return Messages.Azure_GC_Template_RT_Not_Positive();
        }
    }

    public String verifyVirtualNetwork(String virtualNetworkName, String virtualNetworkResourceGroupName, String subnetName, boolean usePrivateIP, String resourceGroupName) {
        if (StringUtils.isNotBlank((String)virtualNetworkName)) {
            Network virtualNetwork;
            String finalResourceGroupName = resourceGroupName;
            if (StringUtils.isNotBlank((String)virtualNetworkResourceGroupName)) {
                finalResourceGroupName = virtualNetworkResourceGroupName;
            }
            if ((virtualNetwork = this.getVirtualNetwork(virtualNetworkName, finalResourceGroupName)) == null) {
                return Messages.Azure_GC_Template_VirtualNetwork_NotFound(virtualNetworkName, finalResourceGroupName);
            }
            if (StringUtils.isBlank((String)subnetName)) {
                return Messages.Azure_GC_Template_subnet_Empty();
            }
            if (virtualNetwork.subnets().get(subnetName) == null) {
                return Messages.Azure_GC_Template_subnet_NotFound(subnetName);
            }
        } else if (StringUtils.isNotBlank((String)subnetName) || usePrivateIP) {
            return Messages.Azure_GC_Template_VirtualNetwork_Null_Or_Empty();
        }
        return "Success";
    }

    public String verifyVirtualMachineImage(String locationLabel, String storageAccountName, String imageTopLevelType, ImageReferenceType referenceType, String builtInImage, String image, String imageId, String imagePublisher, String imageOffer, String imageSku, String imageVersion) {
        if (imageTopLevelType == null || imageTopLevelType.equals("basic")) {
            if (StringUtils.isNotBlank((String)builtInImage)) {
                return "Success";
            }
            return Messages.Azure_GC_Template_BuiltIn_Not_Valid();
        }
        if (referenceType == ImageReferenceType.UNKNOWN && StringUtils.isNotBlank((String)image) || referenceType == ImageReferenceType.CUSTOM) {
            try {
                URI u;
                try {
                    u = URI.create(image);
                }
                catch (Exception e) {
                    return Messages.Azure_GC_Template_ImageURI_Not_Valid();
                }
                String host = u.getHost();
                int firstDot = host.indexOf(46);
                if (firstDot == -1) {
                    return Messages.Azure_GC_Template_ImageURI_Not_Valid();
                }
                String uriStorageAccount = host.substring(0, firstDot);
                if (!uriStorageAccount.equals(storageAccountName)) {
                    return Messages.Azure_GC_Template_ImageURI_Wrong_Storage_Account();
                }
                return "Success";
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Invalid virtual machine image", e);
                return Messages.Azure_GC_Template_ImageURI_Not_Valid();
            }
        }
        if (referenceType == ImageReferenceType.CUSTOM_IMAGE) {
            try {
                GenericResource r = (GenericResource)this.azureClient.genericResources().getById(imageId);
                if (r == null) {
                    return Messages.Azure_GC_Template_ImageID_Not_Valid();
                }
                return "Success";
            }
            catch (Exception e) {
                return Messages.Azure_GC_Template_ImageID_Not_Valid();
            }
        }
        try {
            String locationName = AzureUtil.getLocationNameByLabel(locationLabel);
            PagedList publishers = this.azureClient.virtualMachineImages().publishers().listByRegion(locationName);
            for (VirtualMachinePublisher publisher : publishers) {
                if (!publisher.name().equalsIgnoreCase(imagePublisher)) continue;
                for (VirtualMachineOffer offer : publisher.offers().list()) {
                    if (!offer.name().equalsIgnoreCase(imageOffer)) continue;
                    for (VirtualMachineSku sku : offer.skus().list()) {
                        if (!sku.name().equalsIgnoreCase(imageSku)) continue;
                        PagedList images = sku.images().list();
                        if ((imageVersion.equalsIgnoreCase("latest") || StringUtils.isEmpty((String)imageVersion)) && images.size() > 0) {
                            return "Success";
                        }
                        for (VirtualMachineImage vmImage : images) {
                            if (!vmImage.version().equalsIgnoreCase(imageVersion)) continue;
                            return "Success";
                        }
                        return Messages.Azure_GC_Template_ImageReference_Not_Valid("Invalid image version");
                    }
                    return Messages.Azure_GC_Template_ImageReference_Not_Valid("Invalid SKU");
                }
                return Messages.Azure_GC_Template_ImageReference_Not_Valid("Invalid publisher");
            }
            return Messages.Azure_GC_Template_ImageReference_Not_Valid("Invalid region");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Invalid virtual machine image", e);
            return Messages.Azure_GC_Template_ImageReference_Not_Valid(e.getMessage());
        }
    }

    public String verifyStorageAccountName(String resourceGroupName, String storageAccountName, String storageAccountType) {
        boolean isAvailable = false;
        try {
            if (StringUtils.isBlank((String)storageAccountType)) {
                return Messages.Azure_GC_Template_SA_Type_Null_Or_Empty();
            }
            CheckNameAvailabilityResult checkResult = this.azureClient.storageAccounts().checkNameAvailability(storageAccountName);
            isAvailable = checkResult.isAvailable();
            if (!isAvailable && Reason.ACCOUNT_NAME_INVALID.equals((Object)checkResult.reason())) {
                return Messages.Azure_GC_Template_SA_Not_Valid();
            }
            if (!isAvailable) {
                StorageAccount checkAccount = (StorageAccount)this.azureClient.storageAccounts().getByResourceGroup(resourceGroupName, storageAccountName);
                if (null == checkAccount) {
                    return Messages.Azure_GC_Template_SA_Already_Exists();
                }
                if (((StorageAccountInner)checkAccount.inner()).sku().name().toString().equalsIgnoreCase(storageAccountType)) {
                    return "Success";
                }
                return Messages.Azure_GC_Template_SA_Type_Not_Match(storageAccountType, ((StorageAccountInner)checkAccount.inner()).sku().name().toString());
            }
            return "Success";
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Verification failed for storage account name", e);
            if (!isAvailable) {
                return Messages.Azure_GC_Template_SA_Already_Exists();
            }
            return Messages.Azure_GC_Template_SA_Cant_Validate();
        }
    }

    private static String verifyAdminPassword(String adminPassword) {
        if (StringUtils.isBlank((String)adminPassword)) {
            return Messages.Azure_GC_Template_PWD_Null_Or_Empty();
        }
        if (AzureUtil.isValidPassword(adminPassword)) {
            return "Success";
        }
        return Messages.Azure_GC_Template_PWD_Not_Valid();
    }

    private static String verifyJvmOptions(String jvmOptions) {
        if (StringUtils.isBlank((String)jvmOptions) || AzureUtil.isValidJvmOption(jvmOptions)) {
            return "Success";
        }
        return Messages.Azure_GC_JVM_Option_Err();
    }

    private static String verifyImageParameters(String imageTopLevelType, ImageReferenceType referenceType, String builtInImage, String image, String osType, String imageId, String imagePublisher, String imageOffer, String imageSku, String imageVersion) {
        if (imageTopLevelType == null || imageTopLevelType.equals("basic")) {
            if (StringUtils.isNotBlank((String)builtInImage)) {
                return "Success";
            }
            return Messages.Azure_GC_Template_BuiltIn_Not_Valid();
        }
        if (referenceType == ImageReferenceType.UNKNOWN && StringUtils.isNotBlank((String)image) && StringUtils.isNotBlank((String)osType) || referenceType == ImageReferenceType.CUSTOM) {
            try {
                URI.create(image);
            }
            catch (Exception e) {
                return Messages.Azure_GC_Template_ImageURI_Not_Valid();
            }
            return "Success";
        }
        if (referenceType == ImageReferenceType.CUSTOM_IMAGE && StringUtils.isNotBlank((String)imageId)) {
            return "Success";
        }
        if (StringUtils.isNotBlank((String)imagePublisher) && StringUtils.isNotBlank((String)imageOffer) && StringUtils.isNotBlank((String)imageSku) && StringUtils.isNotBlank((String)imageVersion)) {
            return "Success";
        }
        return Messages.Azure_GC_Template_ImageReference_Not_Valid("Image parameters should not be blank.");
    }

    public String verifyNSG(String resourceGroupName, String nsgName) {
        if (StringUtils.isNotBlank((String)nsgName)) {
            try {
                NetworkSecurityGroup nsg = (NetworkSecurityGroup)this.azureClient.networkSecurityGroups().getByResourceGroup(resourceGroupName, nsgName);
                if (nsg == null) {
                    return Messages.Azure_GC_Template_NSG_NotFound(nsgName);
                }
            }
            catch (Exception e) {
                return Messages.Azure_GC_Template_NSG_NotFound(nsgName);
            }
        }
        return "Success";
    }

    private void createAzureResourceGroup(Azure azureClient, String locationName, String resourceGroupName) throws AzureCloudException {
        try {
            ((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.Blank)azureClient.resourceGroups().define(resourceGroupName)).withRegion(locationName)).create();
        }
        catch (Exception e) {
            throw AzureCloudException.create(String.format(" Failed to create resource group with group name %s, location %s", resourceGroupName, locationName), e);
        }
    }

    private void createStorageAccount(Azure azureClient, String targetStorageAccountType, String targetStorageAccount, String location, String resourceGroupName) throws AzureCloudException {
        try {
            if (azureClient.storageAccounts().getByResourceGroup(resourceGroupName, targetStorageAccount) == null) {
                ((StorageAccount.DefinitionStages.WithCreate)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)azureClient.storageAccounts().define(targetStorageAccount)).withRegion(location)).withExistingResourceGroup(resourceGroupName)).withSku(SkuName.fromString((String)targetStorageAccountType)).create();
            }
        }
        catch (Exception e) {
            throw AzureCloudException.create(String.format("Failed to create storage account with account name %s, location %s, resourceGroupName %s", targetStorageAccount, location, resourceGroupName), e);
        }
    }

    private StorageAccount getStorageAccount(Azure azureClient, String targetStorageAccount, String resourceGroupName) throws AzureCloudException {
        try {
            return (StorageAccount)azureClient.storageAccounts().getByResourceGroup(resourceGroupName, targetStorageAccount);
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
    }

    public static String getBlobEndpointSuffixForTemplate(StorageAccount storageAccount) {
        return AzureVMManagementServiceDelegate.getBlobEndPointSuffix(storageAccount, "blob", ".", "/");
    }

    public static String getBlobEndpointSuffixForCloudStorageAccount(StorageAccount storageAccount) {
        return AzureVMManagementServiceDelegate.getBlobEndPointSuffix(storageAccount, "core", "", "");
    }

    private static String getBlobEndPointSuffix(StorageAccount storageAccount, String startKey, String prefix, String suffix) {
        String endpointSuffix = null;
        if (storageAccount != null) {
            String blobUri = storageAccount.endPoints().primary().blob().toLowerCase();
            endpointSuffix = AzureVMManagementServiceDelegate.getSubString(blobUri, startKey, prefix, suffix);
        }
        return endpointSuffix;
    }

    private static String getSubString(String uri, String startKey, String prefix, String suffix) {
        String subString = null;
        if (StringUtils.isNotBlank((String)uri)) {
            subString = StringUtils.isNotEmpty((String)startKey) && uri.indexOf(startKey) >= 0 ? uri.substring(uri.indexOf(startKey)) : uri;
            String string = subString = StringUtils.isNotEmpty((String)prefix) ? prefix + subString : subString;
            if (StringUtils.isNotEmpty((String)suffix) && subString.lastIndexOf(suffix) < subString.length() - suffix.length()) {
                subString = subString + suffix;
            }
        }
        return subString;
    }

    public static CloudStorageAccount getCloudStorageAccount(StorageAccount storageAccount) throws AzureCloudException {
        List storageKeys = storageAccount.getKeys();
        if (storageKeys.isEmpty()) {
            throw AzureCloudException.create("AzureVMManagementServiceDelegate: uploadCustomScript: Exception occurred while fetching the storage account key");
        }
        String storageAccountKey = ((StorageAccountKey)storageKeys.get(0)).value();
        String blobSuffix = AzureVMManagementServiceDelegate.getBlobEndpointSuffixForCloudStorageAccount(storageAccount);
        LOGGER.log(Level.INFO, "AzureVMManagementServiceDelegate: getCloudStorageAccount: the suffix for construct CloudStorageCloud is {0}", blobSuffix);
        if (StringUtils.isEmpty((String)blobSuffix)) {
            throw AzureCloudException.create("AzureVMManagementServiceDelegate: getCloudStorageAccount:Exception occurred while getting blobSuffix, it's empty'");
        }
        try {
            return new CloudStorageAccount((StorageCredentials)new StorageCredentialsAccountAndKey(storageAccount.name(), storageAccountKey), true, blobSuffix);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "AzureVMManagementServiceDelegate: GetCloudStorageAccount: unable to get CloudStorageAccount with storage account {0} and blob Suffix {1}", new Object[]{storageAccount.name(), blobSuffix});
            throw AzureCloudException.create(e);
        }
    }

    public static CloudBlobContainer getCloudBlobContainer(CloudStorageAccount account, String containerName) throws AzureCloudException {
        try {
            return account.createCloudBlobClient().getContainerReference(containerName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "AzureVMManagementServiceDelegate: getCloudBlobContainer: unable to get CloudStorageAccount with container name {1}", new Object[]{containerName});
            throw AzureCloudException.create(e);
        }
    }

    public CloudBlobContainer getCloudBlobContainer(Azure azureClient, String resourceGroupName, String targetStorageAccount, String blobContainerName) throws AzureCloudException {
        StorageAccount storageAccount = null;
        try {
            storageAccount = (StorageAccount)azureClient.storageAccounts().getByResourceGroup(resourceGroupName, targetStorageAccount);
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
        CloudStorageAccount account = AzureVMManagementServiceDelegate.getCloudStorageAccount(storageAccount);
        return AzureVMManagementServiceDelegate.getCloudBlobContainer(account, blobContainerName);
    }

    private AzureVMManagementServiceDelegate(Azure azureClient) {
        this.azureClient = azureClient;
    }

    public static class VMStatus
    extends ExpandableStringEnum<VMStatus> {
        public static final VMStatus PROVISIONING_OR_DEPROVISIONING = VMStatus.fromString("PROVISIONING_OR_DEPROVISIONING");
        public static final VMStatus UPDATING = VMStatus.fromString("UPDATING");
        public static final VMStatus RUNNING = VMStatus.fromString("PowerState/running");
        public static final VMStatus DEALLOCATING = VMStatus.fromString("PowerState/deallocating");
        public static final VMStatus DEALLOCATED = VMStatus.fromString("PowerState/deallocated");
        public static final VMStatus STARTING = VMStatus.fromString("PowerState/starting");
        public static final VMStatus STOPPED = VMStatus.fromString("PowerState/stopped");
        public static final VMStatus STOPPING = VMStatus.fromString("PowerState/stopping");
        public static final VMStatus UNKNOWN = VMStatus.fromString("PowerState/unknown");

        public static VMStatus fromString(String name) {
            return (VMStatus)VMStatus.fromString((String)name, VMStatus.class);
        }

        public static VMStatus fromPowerState(PowerState powerState) {
            return (VMStatus)VMStatus.fromString((String)powerState.toString(), VMStatus.class);
        }
    }
}

