/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMCloudPoolRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudVerificationTask;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.util.PoolLock;
import com.microsoft.azure.vmagent.util.TemplateUtil;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class AzureVMMaintainPoolTask
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(AzureVMMaintainPoolTask.class.getName());
    private static final int RECURRENCE_PERIOD_IN_MILLIS = 300000;

    public AzureVMMaintainPoolTask() {
        super("Azure VM Maintainer Pool Size");
    }

    public void maintain(AzureVMCloud cloud, AzureVMAgentTemplate template) {
        LOGGER.log(this.getNormalLoggingLevel(), "Starting to maintain template: {0}", template.getTemplateName());
        int currentSize = 0;
        int sizeLimit = ((AzureVMCloudPoolRetentionStrategy)template.getRetentionStrategy()).getPoolSize();
        if (PoolLock.checkProvisionLock(template)) {
            LOGGER.log(this.getNormalLoggingLevel(), "Agents of template {0} is creating, check later", template);
            return;
        }
        for (Computer computer : Jenkins.getInstance().getComputers()) {
            AzureVMComputer azureVMComputer;
            AzureVMAgent agent;
            if (!(computer instanceof AzureVMComputer) || (agent = (AzureVMAgent)(azureVMComputer = (AzureVMComputer)computer).getNode()) == null || !agent.getTemplate().getTemplateName().equals(template.getTemplateName()) || !TemplateUtil.checkSame(agent.getTemplate(), template)) continue;
            ++currentSize;
        }
        if (currentSize < sizeLimit) {
            LOGGER.log(this.getNormalLoggingLevel(), "Prepare for provisioning {0} agents for template {1}", new Object[]{sizeLimit - currentSize, template.getTemplateName()});
            this.provisionNodes(cloud, template, sizeLimit - currentSize);
        }
    }

    public void provisionNodes(AzureVMCloud cloud, AzureVMAgentTemplate template, int newAgents) {
        if (!template.getTemplateProvisionStrategy().isVerifiedPass()) {
            AzureVMCloudVerificationTask.verify(cloud.getCloudName(), template.getTemplateName());
        }
        if (template.getTemplateProvisionStrategy().isVerifiedPass()) {
            cloud.doProvision(newAgents, new ArrayList<NodeProvisioner.PlannedNode>(), template, true, new HashMap<String, String>());
        } else {
            LOGGER.log(Level.WARNING, "Template {0} failed to verify, cannot be provisioned", template.getTemplateName());
        }
    }

    public void execute(TaskListener arg0) {
        for (Cloud cloud : Jenkins.getInstance().clouds) {
            if (!(cloud instanceof AzureVMCloud)) continue;
            AzureVMCloud azureVMCloud = (AzureVMCloud)cloud;
            for (AzureVMAgentTemplate template : azureVMCloud.getVmTemplates()) {
                if (!(template.getRetentionStrategy() instanceof AzureVMCloudPoolRetentionStrategy)) continue;
                this.maintain(azureVMCloud, template);
            }
        }
    }

    public long getRecurrencePeriod() {
        return 300000L;
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }
}

