/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.retry.NoRetryStrategy;
import com.microsoft.azure.vmagent.util.ExecutionEngine;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;

public class AzureVMComputer
extends AbstractCloudComputer<AzureVMAgent>
implements TrackedItem {
    private static final Logger LOGGER = Logger.getLogger(AzureVMComputer.class.getName());
    private final ProvisioningActivity.Id provisioningId;

    public AzureVMComputer(AzureVMAgent agent) {
        super((AbstractCloudSlave)agent);
        this.provisioningId = agent.getId();
    }

    public HttpResponse doDoDelete() throws IOException {
        return this.doDoDelete(new ExecutionEngine());
    }

    protected HttpResponse doDoDelete(ExecutionEngine executionEngine) throws IOException {
        this.checkPermission(DELETE);
        this.setAcceptingTasks(false);
        final AzureVMAgent agent = (AzureVMAgent)this.getNode();
        if (agent != null) {
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    LOGGER.log(Level.INFO, "AzureVMComputer: doDoDelete called for agent {0}", agent.getNodeName());
                    try {
                        agent.deprovision(Messages._User_Delete());
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "AzureVMComputer: doDoDelete: Exception occurred while deleting agent", e);
                        throw AzureCloudException.create("AzureVMComputer: doDoDelete: Exception occurred while deleting agent", e);
                    }
                    return null;
                }
            };
            try {
                executionEngine.executeAsync(task, new NoRetryStrategy());
            }
            catch (AzureCloudException exception) {
                LOGGER.log(Level.INFO, "AzureVMComputer: execute: failed to shutdown/delete " + agent.getDisplayName(), exception);
            }
        }
        return new HttpRedirect("..");
    }

    public boolean isSetOfflineByUser() {
        return this.getOfflineCause() instanceof OfflineCause.UserCause;
    }

    public void waitUntilOnline() throws InterruptedException {
        super.waitUntilOnline();
    }

    @Nullable
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }
}

