/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

@Extension
public final class AzureVMCloudVerificationTask
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(AzureVMCloudVerificationTask.class.getName());
    private static final int RECURRENCE_PERIOD_IN_MILLIS = 3600000;

    public AzureVMCloudVerificationTask() {
        super("Azure VM Verification Task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verify(String cloudName, String templateName) {
        if (StringUtils.isBlank((String)cloudName) || StringUtils.isBlank((String)templateName)) {
            return;
        }
        AzureVMCloudVerificationTask.verifyCloud(cloudName);
        AzureVMCloud cloud = AzureVMCloudVerificationTask.getCloud(cloudName);
        if (cloud == null) {
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: parent cloud not found for {0} in {1}", new Object[]{templateName, cloudName});
            return;
        }
        AzureVMAgentTemplate agentTemplate = cloud.getAzureAgentTemplate(templateName);
        if (agentTemplate == null) {
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: could not retrieve agent template named {0} in {1}", new Object[]{templateName, cloudName});
            return;
        }
        AzureVMAgentTemplate azureVMAgentTemplate = agentTemplate;
        synchronized (azureVMAgentTemplate) {
            if (!cloud.getConfigurationStatus().equals("pass")) {
                agentTemplate.getTemplateProvisionStrategy().failure();
                return;
            }
            if (agentTemplate.getTemplateProvisionStrategy().isVerifiedPass()) {
                return;
            }
            if (!agentTemplate.getTemplateProvisionStrategy().isEnabled()) {
                return;
            }
            try {
                List<String> errors = agentTemplate.verifyTemplate();
                if (errors.isEmpty()) {
                    LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: {0} verified successfully", templateName);
                    agentTemplate.getTemplateProvisionStrategy().verifiedPass();
                    agentTemplate.setTemplateStatusDetails("");
                } else {
                    String details = StringUtils.join(errors, (String)"\n");
                    LOGGER.log(Level.WARNING, "AzureVMCloudVerificationTask: verify: {0} could not be verified:\n{1}", new Object[]{templateName, details});
                    agentTemplate.getTemplateProvisionStrategy().failure();
                    agentTemplate.setTemplateStatusDetails(details);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "AzureVMCloudVerificationTask: verify: got exception while verifying {0}:\n{1}", new Object[]{templateName, e.toString()});
                agentTemplate.getTemplateProvisionStrategy().failure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyCloud(String cloudName) {
        if (StringUtils.isBlank((String)cloudName)) {
            return;
        }
        LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: verifying cloud {0}", cloudName);
        AzureVMCloud cloud = AzureVMCloudVerificationTask.getCloud(cloudName);
        if (cloud == null) {
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: subscription {0} not found, skipping", cloudName);
            return;
        }
        AzureVMCloud azureVMCloud = cloud;
        synchronized (azureVMCloud) {
            if (cloud.getConfigurationStatus().equals("pass")) {
                LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: cloud {0} already verified pass", cloudName);
                cloud.setVirtualMachineCount(AzureVMCloudVerificationTask.getVirtualMachineCount(cloud));
                return;
            }
            if (AzureVMCloudVerificationTask.verifyConfiguration(cloud)) {
                LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: validate: {0} verified pass", cloudName);
                cloud.setVirtualMachineCount(AzureVMCloudVerificationTask.getVirtualMachineCount(cloud));
                cloud.setConfigurationStatus("pass");
                return;
            }
            cloud.setConfigurationStatus("failed");
            LOGGER.log(Level.WARNING, "AzureVMCloudVerificationTask: verify: {0} not verified, has errors", cloudName);
        }
    }

    public static boolean verifyConfiguration(AzureVMCloud cloud) {
        LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verifyConfiguration: start");
        String result = cloud.getServiceDelegate().verifyConfiguration(cloud.getResourceGroupName(), Integer.toString(cloud.getMaxVirtualMachinesLimit()), Integer.toString(cloud.getDeploymentTimeout()));
        if (!"Success".equals(result)) {
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verifyConfiguration: {0}", result);
            cloud.setConfigurationStatus("failed");
            return false;
        }
        return true;
    }

    public static int getVirtualMachineCount(AzureVMCloud cloud) {
        LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: getVirtualMachineCount: start");
        try {
            int vmCount = cloud.getServiceDelegate().getVirtualMachineCount(cloud.getCloudName(), cloud.getResourceGroupName());
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: getVirtualMachineCount: end, cloud {0} has currently {1} vms", new Object[]{cloud.getCloudName(), vmCount});
            return vmCount;
        }
        catch (Exception e) {
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: getVirtualMachineCount: failed to retrieve vm count:\n{0}", e.toString());
            return cloud.getApproximateVirtualMachineCount();
        }
    }

    public static AzureVMCloud getCloud(String cloudName) {
        return Jenkins.getInstance() == null ? null : (AzureVMCloud)Jenkins.getInstance().getCloud(cloudName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskListener arg0) {
        for (Cloud cloud : Jenkins.getInstance().clouds) {
            AzureVMCloud azureVMCloud;
            if (!(cloud instanceof AzureVMCloud)) continue;
            AzureVMCloud azureVMCloud2 = azureVMCloud = (AzureVMCloud)cloud;
            synchronized (azureVMCloud2) {
                azureVMCloud.setVirtualMachineCount(AzureVMCloudVerificationTask.getVirtualMachineCount(azureVMCloud));
            }
        }
    }

    public long getRecurrencePeriod() {
        return 3600000L;
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }

    private static Level getStaticNormalLoggingLevel() {
        return Level.FINE;
    }
}

