/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMCloudBaseRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.retry.LinearRetryForAllExceptions;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import com.microsoft.azure.vmagent.util.ExecutionEngine;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.slaves.RetentionStrategy;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class AzureVMCloudRetensionStrategy
extends AzureVMCloudBaseRetentionStrategy {
    private static final long serialVersionUID = 15743279621L;
    private final long idleTerminationMillis;
    private final long idleTerminationMinutes;
    private static final Logger LOGGER = Logger.getLogger(AzureVMManagementServiceDelegate.class.getName());
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public AzureVMCloudRetensionStrategy(int idleTerminationMinutes) {
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.idleTerminationMillis = TimeUnit.MINUTES.toMillis(idleTerminationMinutes);
    }

    public long check(AzureVMComputer agentNode) {
        return this.check(agentNode, new ExecutionEngine());
    }

    protected long check(final AzureVMComputer agentNode, ExecutionEngine executionEngine) {
        block6: {
            boolean canRecycle = true;
            canRecycle &= agentNode.isIdle();
            canRecycle &= agentNode.isOnline();
            canRecycle &= this.idleTerminationMillis > 0L;
            canRecycle &= this.idleTerminationMillis < System.currentTimeMillis() - agentNode.getIdleStartMilliseconds();
            if (agentNode.getNode() == null) {
                return 1L;
            }
            final AzureVMAgent agent = (AzureVMAgent)agentNode.getNode();
            if (canRecycle) {
                LOGGER.log(Level.INFO, "AzureVMCloudRetensionStrategy: check: Idle timeout reached for agent: {0}, action: {1}", new Object[]{agentNode.getName(), agent.isShutdownOnIdle() ? "shutdown" : "delete"});
                Callable<Void> task = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        agent.blockCleanUpAction();
                        if (agent.isShutdownOnIdle()) {
                            LOGGER.log(Level.INFO, "AzureVMCloudRetensionStrategy: going to idleTimeout agent: {0}", agentNode.getName());
                            agent.shutdown(Messages._Idle_Timeout_Shutdown());
                        } else {
                            agent.deprovision(Messages._Idle_Timeout_Delete());
                        }
                        return null;
                    }
                };
                try {
                    int maxRetries = 3;
                    int waitInterval = 30;
                    int defaultTimeoutInSeconds = 1800;
                    executionEngine.executeAsync(task, new LinearRetryForAllExceptions(3, 30, 1800));
                }
                catch (AzureCloudException ae) {
                    LOGGER.log(Level.WARNING, String.format("AzureVMCloudRetensionStrategy: check: could not terminate or shutdown %s", agentNode.getName()), ae);
                    AzureVMAgent node = (AzureVMAgent)agentNode.getNode();
                    if (node != null) {
                        node.setCleanUpAction(CleanUpAction.DELETE, Messages._Failed_Initial_Shutdown_Or_Delete());
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, String.format("AzureVMCloudRetensionStrategy: check: Exception occurred while calling timeout on node %s", agentNode.getName()), e);
                    AzureVMAgent node = (AzureVMAgent)agentNode.getNode();
                    if (node == null) break block6;
                    node.setCleanUpAction(CleanUpAction.DELETE, Messages._Failed_Initial_Shutdown_Or_Delete());
                }
            }
        }
        return 1L;
    }

    public long getIdleTerminationMinutes() {
        return this.idleTerminationMinutes;
    }

    public void start(AzureVMComputer azureComputer) {
        LOGGER.log(Level.INFO, "AzureVMCloudRetensionStrategy: start: azureComputer name {0}", azureComputer.getDisplayName());
        azureComputer.connect(false);
        this.resetShutdownVMStatus((AzureVMAgent)azureComputer.getNode());
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "Azure VM Idle Retention Strategy";
        }
    }
}

