/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMCloudBaseRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.RetentionStrategy;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class AzureVMCloudOnceRetentionStrategy
extends AzureVMCloudBaseRetentionStrategy
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(AzureVMManagementServiceDelegate.class.getName());
    private static final long serialVersionUID = 1566788691L;
    private static final transient long IDLE_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final transient long LAPSE = TimeUnit.SECONDS.toMillis(5L);
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public AzureVMCloudOnceRetentionStrategy() {
    }

    public long check(AzureVMComputer agentComputer) {
        if (agentComputer.isIdle()) {
            boolean neverConnected = agentComputer.getIdleStartMilliseconds() - agentComputer.getConnectTime() < LAPSE;
            long idleMilliseconds = System.currentTimeMillis() - agentComputer.getIdleStartMilliseconds();
            if (!neverConnected && idleMilliseconds > IDLE_MILLIS) {
                this.done(agentComputer);
            }
        }
        return 1L;
    }

    public void start(AzureVMComputer azureComputer) {
        LOGGER.log(Level.INFO, "AzureVMCloudOnceRetentionStrategy: start: azureComputer name {0}", azureComputer.getDisplayName());
        azureComputer.connect(false);
        this.resetShutdownVMStatus((AzureVMAgent)azureComputer.getNode());
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.done(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.done(executor);
    }

    public void done(Executor executor) {
        AbstractCloudComputer computer = (AbstractCloudComputer)executor.getOwner();
        if (!(computer instanceof AzureVMComputer)) {
            return;
        }
        this.done((AzureVMComputer)computer);
    }

    public void done(AzureVMComputer computer) {
        AzureVMAgent agent = (AzureVMAgent)computer.getNode();
        if (agent == null) {
            return;
        }
        AzureVMComputer azureComputer = computer;
        azureComputer.setAcceptingTasks(false);
        if (agent.isShutdownOnIdle()) {
            LOGGER.log(Level.INFO, "AzureVMCloudOnceRetentionStrategy: Tagging VM to shutdown when idle: {0}", azureComputer.getName());
            agent.setCleanUpAction(CleanUpAction.SHUTDOWN, Messages._Build_Action_Shutdown_Agent());
        } else {
            LOGGER.log(Level.INFO, "AzureVMCloudOnceRetentionStrategy: Tagging VM to delete when idle: {0}", azureComputer.getName());
            agent.setCleanUpAction(CleanUpAction.DELETE, Messages._Build_Action_Delete_Agent());
        }
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "Azure VM Once Retention Strategy";
        }
    }
}

