/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.resources.Deployment;
import com.microsoft.azure.management.resources.DeploymentOperation;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.azure.util.AzureMsiCredentials;
import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMAgentPlugin;
import com.microsoft.azure.vmagent.AzureVMAgentPostBuildAction;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloudRetensionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudVerificationTask;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.AzureVMDeploymentInfo;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.remote.AzureVMAgentSSHLauncher;
import com.microsoft.azure.vmagent.util.AzureClientHolder;
import com.microsoft.azure.vmagent.util.AzureClientUtil;
import com.microsoft.azure.vmagent.util.AzureUtil;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import com.microsoft.azure.vmagent.util.FailureStage;
import com.microsoft.azure.vmagent.util.PoolLock;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.logging.LogRecorder;
import hudson.logging.LogRecorderManager;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedPlannedNode;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AzureVMCloud
extends Cloud {
    public static final Logger LOGGER = Logger.getLogger(AzureVMCloud.class.getName());
    private String cloudName;
    private final String credentialsId;
    private final int maxVirtualMachinesLimit;
    private String resourceGroupReferenceType;
    private String newResourceGroupName;
    private final String existingResourceGroupName;
    private transient String resourceGroupName;
    private List<AzureVMAgentTemplate> vmTemplates;
    @Deprecated
    private transient List<AzureVMAgentTemplate> instTemplates;
    private final int deploymentTimeout;
    private static ExecutorService threadPool;
    private transient String configurationStatus;
    private int approximateVirtualMachineCount;
    private transient Supplier<Azure> azureClient = this.createAzureClientSupplier();

    private Supplier<Azure> createAzureClientSupplier() {
        return Suppliers.memoize((Supplier)new Supplier<Azure>(){

            public Azure get() {
                return AzureClientUtil.getClient(AzureVMCloud.this.credentialsId);
            }
        });
    }

    @DataBoundConstructor
    public AzureVMCloud(String cloudName, String id, String azureCredentialsId, String maxVirtualMachinesLimit, String deploymentTimeout, String resourceGroupReferenceType, String newResourceGroupName, String existingResourceGroupName, List<AzureVMAgentTemplate> vmTemplates) {
        this(cloudName, azureCredentialsId, maxVirtualMachinesLimit, deploymentTimeout, resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName, vmTemplates);
    }

    public AzureVMCloud(String cloudName, String azureCredentialsId, String maxVirtualMachinesLimit, String deploymentTimeout, String resourceGroupReferenceType, String newResourceGroupName, String existingResourceGroupName, List<AzureVMAgentTemplate> vmTemplates) {
        super(AzureVMCloud.getOrGenerateCloudName(cloudName, azureCredentialsId, AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName)));
        this.credentialsId = azureCredentialsId;
        this.resourceGroupReferenceType = resourceGroupReferenceType;
        this.newResourceGroupName = newResourceGroupName;
        this.existingResourceGroupName = existingResourceGroupName;
        this.resourceGroupName = AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName);
        this.cloudName = AzureVMCloud.getOrGenerateCloudName(cloudName, azureCredentialsId, this.resourceGroupName);
        this.maxVirtualMachinesLimit = StringUtils.isBlank((String)maxVirtualMachinesLimit) || !maxVirtualMachinesLimit.matches("\\d+") ? 10 : Integer.parseInt(maxVirtualMachinesLimit);
        this.deploymentTimeout = StringUtils.isBlank((String)deploymentTimeout) || !deploymentTimeout.matches("\\d+") ? 1200 : Integer.parseInt(deploymentTimeout);
        this.configurationStatus = "unverified";
        this.setVmTemplates(vmTemplates == null ? Collections.emptyList() : vmTemplates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        if (StringUtils.isBlank((String)this.newResourceGroupName) && StringUtils.isBlank((String)this.existingResourceGroupName) && StringUtils.isNotBlank((String)this.resourceGroupName)) {
            this.newResourceGroupName = this.resourceGroupName;
            this.resourceGroupReferenceType = "new";
        }
        this.resourceGroupName = AzureVMCloud.getResourceGroupName(this.resourceGroupReferenceType, this.newResourceGroupName, this.existingResourceGroupName);
        this.azureClient = this.createAzureClientSupplier();
        this.configurationStatus = "unverified";
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            if (this.instTemplates != null && this.vmTemplates == null) {
                this.vmTemplates = this.instTemplates;
                this.instTemplates = null;
            }
            this.ensureVmTemplateList();
            for (AzureVMAgentTemplate template : this.vmTemplates) {
                template.setAzureCloud(this);
            }
        }
        return this;
    }

    public boolean canProvision(Label label) {
        AzureVMAgentTemplate template = this.getAzureAgentTemplate(label);
        if (template == null) {
            return false;
        }
        if (template.isTemplateDisabled()) {
            LOGGER.log(Level.INFO, "AzureVMCloud: canProvision: template {0} is marked has disabled, cannot provision agents", template.getTemplateName());
            return false;
        }
        return template.getTemplateProvisionStrategy().isEnabled();
    }

    public static synchronized ExecutorService getThreadPool() {
        if (threadPool == null) {
            threadPool = Executors.newCachedThreadPool();
        }
        return threadPool;
    }

    public Boolean isResourceGroupReferenceTypeEquals(String type) {
        if (this.resourceGroupReferenceType == null && type.equalsIgnoreCase("new")) {
            return true;
        }
        return type != null && type.equalsIgnoreCase(this.resourceGroupReferenceType);
    }

    public int getMaxVirtualMachinesLimit() {
        return this.maxVirtualMachinesLimit;
    }

    public static String getResourceGroupName(String type, String newName, String existingName) {
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)newName) || StringUtils.isNotBlank((String)type) && type.equalsIgnoreCase("new")) {
            return newName;
        }
        return existingName;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public static String getOrGenerateCloudName(String cloudName, String credentialId, String resourceGroupName) {
        return StringUtils.isBlank((String)cloudName) ? AzureUtil.getCloudName(credentialId, resourceGroupName) : cloudName;
    }

    public String getNewResourceGroupName() {
        return this.newResourceGroupName;
    }

    public String getExistingResourceGroupName() {
        return this.existingResourceGroupName;
    }

    public String getResourceGroupReferenceType() {
        return this.resourceGroupReferenceType;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public int getDeploymentTimeout() {
        return this.deploymentTimeout;
    }

    public String getAzureCredentialsId() {
        return this.credentialsId;
    }

    private void ensureVmTemplateList() {
        if (this.vmTemplates == null) {
            this.vmTemplates = new ArrayList<AzureVMAgentTemplate>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearVmTemplates() {
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            this.ensureVmTemplateList();
            this.vmTemplates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVmTemplate(AzureVMAgentTemplate newTemplate) {
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            this.ensureVmTemplateList();
            this.vmTemplates.add(newTemplate);
            newTemplate.setAzureCloud(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVmTemplates(List<AzureVMAgentTemplate> newTemplates) {
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            this.ensureVmTemplateList();
            this.vmTemplates.clear();
            for (AzureVMAgentTemplate newTemplate : newTemplates) {
                this.vmTemplates.add(newTemplate);
                newTemplate.setAzureCloud(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeVmTemplate(String templateName) {
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            this.ensureVmTemplateList();
            ArrayList<AzureVMAgentTemplate> removeTemplates = new ArrayList<AzureVMAgentTemplate>();
            for (AzureVMAgentTemplate template : this.vmTemplates) {
                if (!template.getTemplateName().equals(templateName)) continue;
                removeTemplates.add(template);
            }
            this.vmTemplates.removeAll(removeTemplates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AzureVMAgentTemplate> getVmTemplates() {
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            this.ensureVmTemplateList();
            ArrayList<AzureVMAgentTemplate> listCopy = new ArrayList<AzureVMAgentTemplate>(this.vmTemplates);
            return Collections.unmodifiableList(listCopy);
        }
    }

    public String getConfigurationStatus() {
        return this.configurationStatus;
    }

    public void setConfigurationStatus(String status) {
        this.configurationStatus = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getApproximateVirtualMachineCount() {
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            return this.approximateVirtualMachineCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int adjustVirtualMachineCount(int delta) {
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            if (delta < 0) {
                LOGGER.log(Level.FINE, "Current estimated VM count: {0}, reducing by {1}", new Object[]{this.approximateVirtualMachineCount, delta});
                this.approximateVirtualMachineCount = Math.max(0, this.approximateVirtualMachineCount + delta);
                return 0;
            }
            LOGGER.log(Level.FINE, "Current estimated VM count: {0}, quantity desired {1}", new Object[]{this.approximateVirtualMachineCount, delta});
            if (this.approximateVirtualMachineCount + delta <= this.getMaxVirtualMachinesLimit()) {
                this.approximateVirtualMachineCount += delta;
                return delta;
            }
            int quantityAvailable = Math.max(0, this.getMaxVirtualMachinesLimit() - this.approximateVirtualMachineCount);
            this.approximateVirtualMachineCount += quantityAvailable;
            return quantityAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVirtualMachineCount(int newCount) {
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            this.approximateVirtualMachineCount = newCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AzureVMAgentTemplate getAzureAgentTemplate(Label label) {
        LOGGER.log(Level.FINE, "AzureVMCloud: getAzureAgentTemplate: Retrieving agent template with label {0}", label);
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            for (AzureVMAgentTemplate agentTemplate : this.vmTemplates) {
                LOGGER.log(Level.FINE, "AzureVMCloud: getAzureAgentTemplate: Found agent template {0}", agentTemplate.getTemplateName());
                if (agentTemplate.getUseAgentAlwaysIfAvail() == Node.Mode.NORMAL) {
                    if (label != null && !label.matches(agentTemplate.getLabelDataSet())) continue;
                    LOGGER.log(Level.FINE, "AzureVMCloud: getAzureAgentTemplate: {0} matches!", agentTemplate.getTemplateName());
                    return agentTemplate;
                }
                if (agentTemplate.getUseAgentAlwaysIfAvail() != Node.Mode.EXCLUSIVE || label == null || !label.matches(agentTemplate.getLabelDataSet())) continue;
                LOGGER.log(Level.FINE, "AzureVMCloud: getAzureAgentTemplate: {0} matches!", agentTemplate.getTemplateName());
                return agentTemplate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AzureVMAgentTemplate getAzureAgentTemplate(String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            for (AzureVMAgentTemplate agentTemplate : this.vmTemplates) {
                if (!name.equals(agentTemplate.getTemplateName())) continue;
                return agentTemplate;
            }
        }
        return null;
    }

    public AzureVMAgent createProvisionedAgent(ProvisioningActivity.Id provisioningId, AzureVMAgentTemplate template, String vmName, String deploymentName) throws AzureCloudException {
        int maxTries;
        LOGGER.log(Level.INFO, "AzureVMCloud: createProvisionedAgent: Waiting for deployment {0} to be completed", deploymentName);
        int sleepTimeInSeconds = 30;
        int timeoutInSeconds = this.getDeploymentTimeout();
        int triesLeft = maxTries = timeoutInSeconds / 30;
        do {
            --triesLeft;
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                Azure newAzureClient = AzureClientUtil.getClient(this.credentialsId);
                Deployment dep = (Deployment)newAzureClient.deployments().getByName(deploymentName);
                if (dep == null) {
                    throw AzureCloudException.create(String.format("AzureVMCloud: createProvisionedAgent: Could not find deployment %s", deploymentName));
                }
                PagedList ops = dep.deploymentOperations().list();
                for (DeploymentOperation op : ops) {
                    if (op.targetResource() == null) continue;
                    String resource = op.targetResource().resourceName();
                    String type = op.targetResource().resourceType();
                    String state = op.provisioningState();
                    if (!op.targetResource().resourceType().contains("virtualMachine") || !resource.equalsIgnoreCase(vmName)) continue;
                    if (!(state.equalsIgnoreCase("creating") || state.equalsIgnoreCase("succeeded") || state.equalsIgnoreCase("running"))) {
                        String statusCode = op.statusCode();
                        Object statusMessage = op.statusMessage();
                        String finalStatusMessage = statusCode;
                        if (statusMessage != null) {
                            finalStatusMessage = finalStatusMessage + " - " + statusMessage.toString();
                        }
                        throw AzureCloudException.create(String.format("AzureVMCloud: createProvisionedAgent: Deployment %s: %s:%s - %s", state, type, resource, finalStatusMessage));
                    }
                    if (state.equalsIgnoreCase("succeeded")) {
                        LOGGER.log(Level.INFO, "AzureVMCloud: createProvisionedAgent: VM available: {0}", resource);
                        VirtualMachine vm = (VirtualMachine)newAzureClient.virtualMachines().getByResourceGroup(this.resourceGroupName, resource);
                        OperatingSystemTypes osType = vm.storageProfile().osDisk().osType();
                        AzureVMAgent newAgent = this.getServiceDelegate().parseResponse(provisioningId, vmName, deploymentName, template, osType);
                        this.getServiceDelegate().setVirtualMachineDetails(newAgent, template);
                        return newAgent;
                    }
                    LOGGER.log(Level.INFO, "AzureVMCloud: createProvisionedAgent: Deployment {0} not yet finished ({1}): {2}:{3} - waited {4} seconds", new Object[]{deploymentName, state, type, resource, (maxTries - triesLeft) * 30});
                }
            }
            catch (AzureCloudException e) {
                throw e;
            }
            catch (Exception e) {
                throw AzureCloudException.create(e);
            }
        } while (triesLeft > 0);
        throw AzureCloudException.create(String.format("AzureVMCloud: createProvisionedAgent: Deployment %s failed, max timeout reached (%d seconds)", deploymentName, timeoutInSeconds));
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int workLoad) {
        LOGGER.log(Level.INFO, "AzureVMCloud: provision: start for label {0} workLoad {1}", new Object[]{label, workLoad});
        final AzureVMAgentTemplate template = this.getAzureAgentTemplate(label);
        int numberOfAgents = (workLoad + template.getNoOfParallelJobs() - 1) / template.getNoOfParallelJobs();
        ArrayList<NodeProvisioner.PlannedNode> plannedNodes = new ArrayList<NodeProvisioner.PlannedNode>(numberOfAgents);
        if (!template.getTemplateProvisionStrategy().isVerifiedPass()) {
            AzureVMCloudVerificationTask.verify(this.cloudName, template.getTemplateName());
        }
        if (template.getTemplateProvisionStrategy().isVerifiedFailed()) {
            LOGGER.log(Level.INFO, "AzureVMCloud: provision: template {0} has just verified failed", template.getTemplateName());
            if (StringUtils.isNotBlank((String)template.getTemplateStatusDetails())) {
                LOGGER.log(Level.INFO, template.getTemplateStatusDetails());
            }
            return new ArrayList<NodeProvisioner.PlannedNode>();
        }
        final HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("NumberOfAgents", String.valueOf(plannedNodes.size()));
        properties.put("SubscriptionId", this.getAzureClient().subscriptionId());
        properties.put("Location", template.getLocation());
        properties.put("AgentOS", template.getOsType());
        properties.put("RetentionStrategy", template.getRetentionStrategy().getClass().getName());
        properties.put("Connection method", template.getAgentLaunchMethod());
        LOGGER.log(Level.INFO, "AzureVMCloud: provision: checking for node reuse options");
        for (Computer agentComputer : Jenkins.getInstance().getComputers()) {
            AzureVMComputer azureComputer;
            AzureVMAgent agentNode;
            if (numberOfAgents == 0) break;
            if (!(agentComputer instanceof AzureVMComputer) || !agentComputer.isOffline() || (agentNode = (AzureVMAgent)(azureComputer = (AzureVMComputer)((Object)AzureVMComputer.class.cast(agentComputer))).getNode()) == null || !AzureVMCloud.isNodeEligibleForReuse(agentNode, template)) continue;
            LOGGER.log(Level.INFO, "AzureVMCloud: provision: agent computer eligible for reuse {0}", agentComputer.getName());
            try {
                if (!AzureVMManagementServiceDelegate.virtualMachineExists(agentNode)) continue;
                --numberOfAgents;
                plannedNodes.add(new NodeProvisioner.PlannedNode(agentNode.getNodeName(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Node call() throws AzureCloudException {
                        AzureVMAgent azureVMAgent = agentNode;
                        synchronized (azureVMAgent) {
                            if (agentNode.getComputer().isOnline()) {
                                return agentNode;
                            }
                            LOGGER.log(Level.INFO, "Found existing node, starting VM {0}", agentNode.getNodeName());
                            try {
                                AzureVMCloud.this.getServiceDelegate().startVirtualMachine(agentNode);
                                int waitTimeInMillis = 30000;
                                AzureVMCloud.this.getServiceDelegate().setVirtualMachineDetails(agentNode, template);
                                Jenkins.getInstance().addNode((Node)agentNode);
                                if (agentNode.getAgentLaunchMethod().equalsIgnoreCase("SSH")) {
                                    azureComputer.connect(false).get();
                                } else {
                                    AzureVMCloud.this.waitUntilJNLPNodeIsOnline(agentNode);
                                }
                                LOGGER.info(String.format("Remove suspended status for node: %s", agentNode.getNodeName()));
                                azureComputer.setAcceptingTasks(true);
                                agentNode.clearCleanUpAction();
                                agentNode.setEligibleForReuse(false);
                            }
                            catch (Exception e) {
                                properties.put("Message", e.getMessage());
                                AzureVMAgentPlugin.sendEvent("VMAgent", "ProvisionFailed", properties);
                                throw AzureCloudException.create(e);
                            }
                            AzureVMAgentPlugin.sendEvent("VMAgent", "Provision", properties);
                            template.getTemplateProvisionStrategy().success();
                            return agentNode;
                        }
                    }
                }), template.getNoOfParallelJobs()));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Failed to reuse agent computer %s", agentComputer.getName()), e);
                azureComputer.setAcceptingTasks(false);
                agentNode.setCleanUpAction(CleanUpAction.DEFAULT, Messages._Shutdown_Agent_Failed_To_Revive());
            }
        }
        if (numberOfAgents > 0) {
            try {
                int adjustedNumberOfAgents = this.adjustVirtualMachineCount(numberOfAgents);
                if (adjustedNumberOfAgents == 0) {
                    LOGGER.log(Level.INFO, "Not able to create any new nodes, at or above maximum VM count of {0}", this.getMaxVirtualMachinesLimit());
                    return plannedNodes;
                }
                if (adjustedNumberOfAgents < numberOfAgents) {
                    LOGGER.log(Level.INFO, "Able to create new nodes, but can only create {0} (desired {1})", new Object[]{adjustedNumberOfAgents, numberOfAgents});
                }
                this.doProvision(adjustedNumberOfAgents, plannedNodes, template, properties);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, String.format("Failure provisioning agents about '%s'", template.getLabels()), e);
                properties.put("Message", e.getMessage());
                AzureVMAgentPlugin.sendEvent("VMAgent", "ProvisionFailed", properties);
            }
        }
        LOGGER.log(Level.INFO, "AzureVMCloud: provision: asynchronous provision finished, returning {0} planned node(s)", plannedNodes.size());
        AzureVMAgentPlugin.sendEvent("VMAgent", "Provision", properties);
        return plannedNodes;
    }

    public void doProvision(int numberOfNewAgents, List<NodeProvisioner.PlannedNode> plannedNodes, AzureVMAgentTemplate template, Map<String, String> properties) {
        this.doProvision(numberOfNewAgents, plannedNodes, template, false, properties);
    }

    public void doProvision(final int numberOfNewAgents, List<NodeProvisioner.PlannedNode> plannedNodes, final AzureVMAgentTemplate template, final boolean isProvisionOutside, final Map<String, String> properties) {
        Callable<AzureVMDeploymentInfo> callableTask = new Callable<AzureVMDeploymentInfo>(){

            @Override
            public AzureVMDeploymentInfo call() throws AzureCloudException {
                try {
                    return template.provisionAgents((TaskListener)new StreamTaskListener((OutputStream)System.out, Charset.defaultCharset()), numberOfNewAgents);
                }
                catch (AzureCloudException e) {
                    properties.put("Message", e.getMessage());
                    AzureVMAgentPlugin.sendEvent("VMAgent", "ProvisionFailed", properties);
                    throw e;
                }
                catch (Exception e) {
                    properties.put("Message", e.getMessage());
                    AzureVMAgentPlugin.sendEvent("VMAgent", "ProvisionFailed", properties);
                    throw AzureCloudException.create(e);
                }
            }
        };
        final Future<AzureVMDeploymentInfo> deploymentFuture = AzureVMCloud.getThreadPool().submit(callableTask);
        int i = 0;
        while (i < numberOfNewAgents) {
            final int index = i++;
            final ProvisioningActivity.Id provisioningId = new ProvisioningActivity.Id(this.name, template.getTemplateName());
            plannedNodes.add((NodeProvisioner.PlannedNode)new TrackedPlannedNode(provisioningId, template.getNoOfParallelJobs(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Node call() throws AzureCloudException {
                    try {
                        PoolLock.provisionLock(template);
                        if (isProvisionOutside) {
                            CloudStatistics.ProvisioningListener.get().onStarted(provisioningId);
                        }
                        AzureVMDeploymentInfo info = null;
                        try {
                            info = (AzureVMDeploymentInfo)deploymentFuture.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw AzureCloudException.create(e);
                        }
                        String deploymentName = info.getDeploymentName();
                        String vmBaseName = info.getVmBaseName();
                        String vmName = String.format("%s%d", vmBaseName, index);
                        AzureVMAgent agent = null;
                        try {
                            agent = AzureVMCloud.this.createProvisionedAgent(provisioningId, template, vmName, deploymentName);
                        }
                        catch (AzureCloudException e) {
                            LOGGER.log(Level.SEVERE, String.format("Failure creating provisioned agent '%s'", vmName), e);
                            this.handleFailure(template, vmName, e, FailureStage.PROVISIONING);
                            throw e;
                        }
                        try {
                            LOGGER.log(Level.INFO, "Azure Cloud: provision: Adding agent {0} to Jenkins nodes", agent.getNodeName());
                            try {
                                agent.blockCleanUpAction();
                                Jenkins.getInstance().addNode((Node)agent);
                                Computer computer = agent.toComputer();
                                if (agent.getAgentLaunchMethod().equalsIgnoreCase("SSH") && computer != null) {
                                    computer.connect(false).get();
                                } else if (agent.getAgentLaunchMethod().equalsIgnoreCase("JNLP")) {
                                    AzureVMCloud.this.waitUntilJNLPNodeIsOnline(agent);
                                }
                            }
                            finally {
                                agent.clearCleanUpAction();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, String.format("Failure to in post-provisioning for '%s'", vmName), e);
                            this.handleFailure(template, vmName, e, FailureStage.POSTPROVISIONING);
                            try {
                                Jenkins.getInstance().removeNode((Node)agent);
                            }
                            catch (IOException nodeRemoveEx) {
                                LOGGER.log(Level.SEVERE, String.format("Failure removing Jenkins node for '%s'", vmName), nodeRemoveEx);
                            }
                            throw AzureCloudException.create(e);
                        }
                        if (isProvisionOutside) {
                            CloudStatistics.ProvisioningListener.get().onComplete(provisioningId, (Node)agent);
                        }
                        template.getTemplateProvisionStrategy().success();
                        AzureVMAgent azureVMAgent = agent;
                        return azureVMAgent;
                    }
                    catch (AzureCloudException e) {
                        if (isProvisionOutside) {
                            CloudStatistics.ProvisioningListener.get().onFailure(provisioningId, (Throwable)e);
                        }
                        properties.put("Message", e.getMessage());
                        AzureVMAgentPlugin.sendEvent("VMAgent", "ProvisionFailed", properties);
                        throw e;
                    }
                    finally {
                        PoolLock.provisionUnlock(template);
                    }
                }

                private void handleFailure(AzureVMAgentTemplate template2, String vmName, Exception e, FailureStage stage) {
                    try {
                        AzureVMCloud.this.getServiceDelegate().terminateVirtualMachine(vmName, template2.getResourceGroupName());
                    }
                    catch (AzureCloudException terminateEx) {
                        LOGGER.log(Level.SEVERE, String.format("Failure terminating previous failed agent '%s'", vmName), terminateEx);
                    }
                    template2.getAzureCloud().adjustVirtualMachineCount(-1);
                    template2.handleTemplateProvisioningFailure(e.getMessage(), stage);
                }
            })));
        }
    }

    private void waitUntilJNLPNodeIsOnline(final AzureVMAgent agent) throws AzureCloudException {
        LOGGER.log(Level.INFO, "Azure Cloud: waitUntilOnline: for agent {0}", agent.getDisplayName());
        Callable<String> callableTask = new Callable<String>(){

            @Override
            public String call() {
                try {
                    Computer computer = agent.toComputer();
                    if (computer != null) {
                        computer.waitUntilOnline();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return "success";
            }
        };
        Future<String> future = AzureVMCloud.getThreadPool().submit(callableTask);
        try {
            int timeoutInMinutes = 30;
            String result = future.get(30L, TimeUnit.MINUTES);
            LOGGER.log(Level.INFO, "Azure Cloud: waitUntilOnline: node is alive , result {0}", result);
        }
        catch (Exception ex) {
            throw AzureCloudException.create("Azure Cloud: waitUntilOnline: Failure waiting till online", ex);
        }
        finally {
            future.cancel(true);
        }
    }

    private static boolean isNodeEligibleForReuse(AzureVMAgent agentNode, AzureVMAgentTemplate agentTemplate) {
        if (!agentNode.isEligibleForReuse()) {
            return false;
        }
        if (StringUtils.isBlank((String)agentNode.getLabelString()) && agentNode.getMode() == Node.Mode.NORMAL) {
            return true;
        }
        return StringUtils.isNotBlank((String)agentNode.getLabelString()) && agentNode.getLabelString().equalsIgnoreCase(agentTemplate.getLabels());
    }

    public Azure getAzureClient() {
        return (Azure)this.azureClient.get();
    }

    public AzureVMManagementServiceDelegate getServiceDelegate() {
        return AzureVMManagementServiceDelegate.getInstance(this.getAzureClient());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        private static final String LOG_RECORDER_NAME = "Azure VM Agent (Auto)";

        public String getLogRecorderName() {
            return LOG_RECORDER_NAME;
        }

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.AzureVMCloud", AzureVMCloud.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.AzureVMAgent", AzureVMAgent.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.remote.AzureVMAgentSSHLauncher", AzureVMAgentSSHLauncher.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.AzureVMAgentTemplate", AzureVMAgentTemplate.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.AzureVMCloudRetensionStrategy", AzureVMCloudRetensionStrategy.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.AzureVMAgentPostBuildAction", AzureVMAgentPostBuildAction.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.Messages", Messages.class);
        }

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addLogRecorder(Jenkins h) throws IOException {
            if (!h.hasPermission(Jenkins.ADMINISTER)) {
                return;
            }
            LogRecorderManager manager = h.getLog();
            Map logRecorders = manager.logRecorders;
            if (!logRecorders.containsKey(LOG_RECORDER_NAME)) {
                LogRecorder recorder = new LogRecorder(LOG_RECORDER_NAME);
                String packageName = AzureVMAgent.class.getPackage().getName();
                recorder.targets.add((Object)new LogRecorder.Target(packageName, Level.WARNING));
                logRecorders.put(LOG_RECORDER_NAME, recorder);
                recorder.save();
            }
        }

        public String getDisplayName() {
            return "Microsoft Azure VM Agents";
        }

        public String getDefaultserviceManagementURL() {
            return "https://management.core.windows.net/";
        }

        public int getDefaultMaxVMLimit() {
            return 10;
        }

        public int getDefaultDeploymentTimeout() {
            return 1200;
        }

        public String getDefaultResourceGroupName() {
            return "jenkins";
        }

        public FormValidation doVerifyConfiguration(@QueryParameter String azureCredentialsId, @QueryParameter String maxVirtualMachinesLimit, @QueryParameter String deploymentTimeout, @QueryParameter String resourceGroupReferenceType, @QueryParameter String newResourceGroupName, @QueryParameter String existingResourceGroupName) {
            Azure azureClient;
            String validationResult;
            String resourceGroupName = AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName);
            if (StringUtils.isBlank((String)resourceGroupName)) {
                resourceGroupName = "jenkins";
            }
            if (!(validationResult = AzureVMManagementServiceDelegate.getInstance(azureClient = AzureClientHolder.get(azureCredentialsId)).verifyConfiguration(resourceGroupName, maxVirtualMachinesLimit, deploymentTimeout)).equalsIgnoreCase("Success")) {
                return FormValidation.error((String)validationResult);
            }
            return FormValidation.ok((String)Messages.Azure_Config_Success());
        }

        public ListBoxModel doFillAzureCredentialsIdItems(@AncestorInPath Item owner) {
            return new StandardListBoxModel().includeEmptyValue().withAll((Iterable)CredentialsProvider.lookupCredentials(AzureCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList())).withAll((Iterable)CredentialsProvider.lookupCredentials(AzureMsiCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListBoxModel doFillExistingResourceGroupNameItems(@QueryParameter String azureCredentialsId) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("--- Select Resource Group ---", "");
            if (StringUtils.isBlank((String)azureCredentialsId)) {
                return model;
            }
            try {
                Azure azureClient = AzureClientHolder.get(azureCredentialsId);
                for (ResourceGroup resourceGroup : azureClient.resourceGroups().list()) {
                    model.add(resourceGroup.name());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot list resource group name: ", e);
            }
            finally {
                return model;
            }
        }
    }
}

