/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.compute.AvailabilitySet;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.vmagent.AvailabilityType;
import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMCloudBaseRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudOnceRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudPoolRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudRetensionStrategy;
import com.microsoft.azure.vmagent.AzureVMDeploymentInfo;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.ImageReferenceType;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.ProvisionStrategy;
import com.microsoft.azure.vmagent.builders.AdvancedImage;
import com.microsoft.azure.vmagent.builders.AdvancedImageBuilder;
import com.microsoft.azure.vmagent.builders.Availability;
import com.microsoft.azure.vmagent.builders.AvailabilityBuilder;
import com.microsoft.azure.vmagent.builders.BuiltInImage;
import com.microsoft.azure.vmagent.builders.BuiltInImageBuilder;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.util.AzureClientHolder;
import com.microsoft.azure.vmagent.util.AzureClientUtil;
import com.microsoft.azure.vmagent.util.AzureUtil;
import com.microsoft.azure.vmagent.util.FailureStage;
import com.microsoft.jenkins.azurecommons.core.credentials.TokenCredentialData;
import hudson.Extension;
import hudson.Functions;
import hudson.RelativePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.security.ACL;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.xml.bind.DatatypeConverter;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AzureVMAgentTemplate
implements Describable<AzureVMAgentTemplate>,
Serializable {
    private static final long serialVersionUID = 1574325691L;
    private static final Logger LOGGER = Logger.getLogger(AzureVMAgentTemplate.class.getName());
    private static final int GEN_STORAGE_ACCOUNT_UID_LENGTH = 22;
    private final String templateName;
    private final String templateDesc;
    private final String labels;
    private final String location;
    private final String availabilityType;
    private final String availabilitySet;
    private final String virtualMachineSize;
    private String storageAccountNameReferenceType;
    private transient String storageAccountName;
    private String diskType;
    private int osDiskSize;
    private String newStorageAccountName;
    private String existingStorageAccountName;
    private String storageAccountType;
    private final int noOfParallelJobs;
    private Node.Mode usageMode;
    private final boolean shutdownOnIdle;
    private String imageTopLevelType;
    private final String imageReferenceType;
    private String builtInImage;
    private final boolean isInstallGit;
    private final boolean isInstallMaven;
    private final boolean isInstallDocker;
    private final String image;
    private final String osType;
    private final String imageId;
    private final String imagePublisher;
    private final String imageOffer;
    private final String imageSku;
    private final String imageVersion;
    private final String agentLaunchMethod;
    private boolean preInstallSsh;
    private final String initScript;
    private final String credentialsId;
    private final String agentWorkspace;
    private int retentionTimeInMin;
    private String virtualNetworkName;
    private String virtualNetworkResourceGroupName;
    private String subnetName;
    private boolean usePrivateIP;
    private final String nsgName;
    private final String jvmOptions;
    private final boolean templateDisabled;
    private String templateStatusDetails;
    private transient AzureVMCloud azureCloud;
    private transient Set<LabelAtom> labelDataSet;
    private boolean templateVerified;
    private transient ProvisionStrategy templateProvisionStrategy;
    private boolean executeInitScriptAsRoot;
    private boolean doNotUseMachineIfInitFails;
    private final boolean enableMSI;
    private AzureVMCloudBaseRetentionStrategy retentionStrategy;

    @DataBoundConstructor
    public AzureVMAgentTemplate(String templateName, String templateDesc, String labels, String location, AvailabilityTypeClass availabilityTypeClass, String virtualMachineSize, String storageAccountNameReferenceType, String storageAccountType, String newStorageAccountName, String existingStorageAccountName, String diskType, int osDiskSize, String noOfParallelJobs, String usageMode, String builtInImage, boolean isInstallGit, boolean isInstallMaven, boolean isInstallDocker, String osType, String imageTopLevelType, boolean imageReference, ImageReferenceTypeClass imageReferenceTypeClass, String agentLaunchMethod, boolean preInstallSsh, String initScript, String credentialsId, String virtualNetworkName, String virtualNetworkResourceGroupName, String subnetName, boolean usePrivateIP, String nsgName, String agentWorkspace, String jvmOptions, AzureVMCloudBaseRetentionStrategy retentionStrategy, boolean shutdownOnIdle, boolean templateDisabled, String templateStatusDetails, boolean executeInitScriptAsRoot, boolean doNotUseMachineIfInitFails, boolean enableMSI) {
        this.templateName = templateName;
        this.templateDesc = templateDesc;
        this.labels = labels;
        this.location = location;
        this.availabilityType = this.getAvailabilityType(availabilityTypeClass);
        this.availabilitySet = availabilityTypeClass == null ? null : availabilityTypeClass.getAvailabilitySet();
        this.virtualMachineSize = virtualMachineSize;
        this.storageAccountType = storageAccountType;
        this.storageAccountName = AzureVMAgentTemplate.getStorageAccountName(storageAccountNameReferenceType, newStorageAccountName, existingStorageAccountName);
        this.newStorageAccountName = newStorageAccountName;
        this.existingStorageAccountName = existingStorageAccountName;
        this.storageAccountNameReferenceType = storageAccountNameReferenceType;
        this.diskType = diskType;
        this.osDiskSize = osDiskSize;
        this.noOfParallelJobs = StringUtils.isBlank((String)noOfParallelJobs) || !noOfParallelJobs.matches("\\d+") || noOfParallelJobs.trim().equals("0") ? 1 : Integer.parseInt(noOfParallelJobs);
        this.setUsageMode(usageMode);
        this.imageTopLevelType = imageTopLevelType;
        this.imageReferenceType = this.getImageReferenceType(imageReferenceTypeClass);
        this.builtInImage = builtInImage;
        this.isInstallDocker = isInstallDocker;
        this.isInstallGit = isInstallGit;
        this.isInstallMaven = isInstallMaven;
        this.image = imageReferenceTypeClass.getImage();
        this.osType = osType;
        this.imageId = imageReferenceTypeClass.getImageId();
        this.imagePublisher = imageReferenceTypeClass.getImagePublisher();
        this.imageOffer = imageReferenceTypeClass.getImageOffer();
        this.imageSku = imageReferenceTypeClass.getImageSku();
        this.imageVersion = imageReferenceTypeClass.getImageVersion();
        this.shutdownOnIdle = shutdownOnIdle;
        this.initScript = initScript;
        this.agentLaunchMethod = agentLaunchMethod;
        this.preInstallSsh = preInstallSsh;
        this.credentialsId = credentialsId;
        this.virtualNetworkName = virtualNetworkName;
        this.virtualNetworkResourceGroupName = virtualNetworkResourceGroupName;
        this.subnetName = subnetName;
        this.usePrivateIP = usePrivateIP;
        this.nsgName = nsgName;
        this.agentWorkspace = agentWorkspace;
        this.jvmOptions = jvmOptions;
        this.executeInitScriptAsRoot = executeInitScriptAsRoot;
        this.doNotUseMachineIfInitFails = doNotUseMachineIfInitFails;
        this.enableMSI = enableMSI;
        this.templateDisabled = templateDisabled;
        this.templateStatusDetails = "";
        this.templateProvisionStrategy = new ProvisionStrategy();
        this.retentionStrategy = retentionStrategy;
        this.labelDataSet = Label.parse((String)labels);
    }

    public static Map<String, Object> getTemplateProperties(AzureVMAgentTemplate template) {
        HashMap<String, Object> templateProperties = new HashMap<String, Object>();
        String builtInImage = template.getBuiltInImage();
        Map<String, String> defaultProperties = AzureVMManagementServiceDelegate.DEFAULT_IMAGE_PROPERTIES.get(builtInImage);
        boolean isBasic = template.isTopLevelType("basic");
        String imageSkuName = template.getIsInstallDocker() ? "defaultDockerImageSku" : "defaultImageSku";
        templateProperties.put("imageId", isBasic ? defaultProperties.get("defaultImageId") : template.getImageId());
        templateProperties.put("imagePublisher", isBasic ? defaultProperties.get("defaultImagePublisher") : template.getImagePublisher());
        templateProperties.put("imageOffer", isBasic ? defaultProperties.get("defaultImageOffer") : template.getImageOffer());
        templateProperties.put("imageSku", isBasic ? defaultProperties.get(imageSkuName) : template.getImageSku());
        templateProperties.put("imageVersion", isBasic ? defaultProperties.get("defaultImageVersion") : template.getImageVersion());
        templateProperties.put("osType", isBasic ? defaultProperties.get("defaultOsType") : template.getOsType());
        templateProperties.put("agentLaunchMethod", isBasic ? defaultProperties.get("defaultLaunchMethod") : template.getAgentLaunchMethod());
        templateProperties.put("initScript", isBasic ? AzureVMAgentTemplate.getBasicInitScript(template) : template.getInitScript());
        templateProperties.put("virtualNetworkName", isBasic ? "" : template.getVirtualNetworkName());
        templateProperties.put("virtualNetworkResourceGroupName", isBasic ? "" : template.getVirtualNetworkResourceGroupName());
        templateProperties.put("subnetName", isBasic ? "" : template.getSubnetName());
        templateProperties.put("usePrivateIP", isBasic ? false : template.getUsePrivateIP());
        templateProperties.put("nsgName", isBasic ? "" : template.getNsgName());
        templateProperties.put("jvmOptions", isBasic ? "" : template.getJvmOptions());
        templateProperties.put("noOfParallelJobs", isBasic ? 1 : template.getNoOfParallelJobs());
        templateProperties.put("templateDisabled", isBasic ? false : template.isTemplateDisabled());
        templateProperties.put("executeInitScriptAsRoot", isBasic ? true : template.getExecuteInitScriptAsRoot());
        templateProperties.put("doNotUseMachineIfInitFails", isBasic ? true : template.getDoNotUseMachineIfInitFails());
        templateProperties.put("enableMSI", isBasic ? false : template.isEnableMSI());
        return templateProperties;
    }

    public static String getBasicInitScript(AzureVMAgentTemplate template) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(AzureVMManagementServiceDelegate.PRE_INSTALLED_TOOLS_SCRIPT.get(template.getBuiltInImage()).get("Java"));
            if (template.getIsInstallMaven()) {
                stringBuilder.append(AzureVMAgentTemplate.getSeparator(template.getOsType()));
                stringBuilder.append(AzureVMManagementServiceDelegate.PRE_INSTALLED_TOOLS_SCRIPT.get(template.getBuiltInImage()).get("Maven"));
            }
            if (template.getIsInstallGit()) {
                stringBuilder.append(AzureVMAgentTemplate.getSeparator(template.getOsType()));
                stringBuilder.append(AzureVMManagementServiceDelegate.PRE_INSTALLED_TOOLS_SCRIPT.get(template.getBuiltInImage()).get("Git"));
            }
            if (template.getBuiltInImage().equals("Ubuntu 16.04 LTS") && template.getIsInstallDocker()) {
                stringBuilder.append(AzureVMAgentTemplate.getSeparator(template.getOsType()));
                stringBuilder.append(AzureVMManagementServiceDelegate.PRE_INSTALLED_TOOLS_SCRIPT.get(template.getBuiltInImage()).get("Docker").replace("${ADMIN}", template.getVMCredentials().getUsername()));
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AzureVMTemplate: getBasicInitScript: Get pre-installed tools script {0} failed.", e);
            return stringBuilder.toString();
        }
    }

    public static String getSeparator(String osType) {
        if (osType.equals("Windows")) {
            return "\r\n";
        }
        return "\n";
    }

    public boolean isType(String type) {
        if (this.imageReferenceType == null && type.equals("reference")) {
            return true;
        }
        return type != null && type.equalsIgnoreCase(this.imageReferenceType);
    }

    public boolean isTopLevelType(String type) {
        if (this.imageTopLevelType == null && type.equals("basic")) {
            return true;
        }
        return type != null && type.equalsIgnoreCase(this.imageTopLevelType);
    }

    private Object readResolve() {
        this.labelDataSet = Label.parse((String)this.labels);
        this.templateProvisionStrategy = new ProvisionStrategy();
        if (StringUtils.isBlank((String)this.storageAccountType)) {
            this.storageAccountType = SkuName.STANDARD_LRS.toString();
        }
        if (StringUtils.isBlank((String)this.newStorageAccountName) && StringUtils.isBlank((String)this.existingStorageAccountName) && StringUtils.isNotBlank((String)this.storageAccountName)) {
            this.newStorageAccountName = this.storageAccountName;
            this.storageAccountNameReferenceType = "new";
        }
        this.storageAccountName = AzureVMAgentTemplate.getStorageAccountName(this.storageAccountNameReferenceType, this.newStorageAccountName, this.existingStorageAccountName);
        if (StringUtils.isBlank((String)this.imageTopLevelType)) {
            this.imageTopLevelType = StringUtils.isNotBlank((String)this.image) || StringUtils.isNotBlank((String)this.imageId) || StringUtils.isNotBlank((String)this.imageOffer) || StringUtils.isNotBlank((String)this.imageSku) || StringUtils.isNotBlank((String)this.imagePublisher) ? "advanced" : "basic";
            this.builtInImage = "Windows Server 2016";
        }
        if (StringUtils.isBlank((String)this.diskType)) {
            this.diskType = "unmanaged";
        }
        if (this.retentionStrategy == null) {
            this.retentionStrategy = new AzureVMCloudRetensionStrategy(this.retentionTimeInMin);
        }
        return this;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAvailabilitySet() {
        return this.availabilitySet;
    }

    public String getVirtualMachineSize() {
        return this.virtualMachineSize;
    }

    public String getStorageAccountType() {
        return StringUtils.isBlank((String)this.storageAccountType) ? SkuName.STANDARD_LRS.toString() : this.storageAccountType;
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public static String getStorageAccountName(String type, String newName, String existingName) {
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)newName) || StringUtils.isNotBlank((String)type) && type.equalsIgnoreCase("new")) {
            return newName;
        }
        return existingName;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public int getOsDiskSize() {
        return this.osDiskSize;
    }

    public String getStorageAccountNameReferenceType() {
        return this.storageAccountNameReferenceType;
    }

    public void setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
    }

    public String getNewStorageAccountName() {
        return this.newStorageAccountName;
    }

    public String getExistingStorageAccountName() {
        return this.existingStorageAccountName;
    }

    public Node.Mode getUseAgentAlwaysIfAvail() {
        return this.usageMode == null ? Node.Mode.NORMAL : this.usageMode;
    }

    public boolean isStorageAccountNameReferenceTypeEquals(String type) {
        if (this.storageAccountNameReferenceType == null && type.equalsIgnoreCase("new")) {
            return true;
        }
        return type != null && type.equalsIgnoreCase(this.storageAccountNameReferenceType);
    }

    public String getUsageMode() {
        return this.getUseAgentAlwaysIfAvail().getDescription();
    }

    public void setUsageMode(String mode) {
        Node.Mode val = Node.Mode.NORMAL;
        for (Node.Mode m : Functions.getNodeModes()) {
            if (!mode.equalsIgnoreCase(m.getDescription())) continue;
            val = m;
            break;
        }
        this.usageMode = val;
    }

    public boolean isShutdownOnIdle() {
        return this.shutdownOnIdle;
    }

    public String getAvailabilityType() {
        return this.availabilityType;
    }

    public String getImageReferenceType() {
        return this.imageReferenceType;
    }

    public String getImageTopLevelType() {
        return this.imageTopLevelType;
    }

    public String getAvailabilityType(AvailabilityTypeClass availabilityTypeClass) {
        if (availabilityTypeClass == null) {
            return AvailabilityType.UNKNOWN.getName();
        }
        if (availabilityTypeClass.getAvailabilitySet() != null) {
            return AvailabilityType.AVAILABILITY_SET.getName();
        }
        return AvailabilityType.UNKNOWN.getName();
    }

    public String getImageReferenceType(ImageReferenceTypeClass imageReferenceTypeClass) {
        if (imageReferenceTypeClass.image != null) {
            return ImageReferenceType.CUSTOM.getName();
        }
        if (imageReferenceTypeClass.imageId != null) {
            return ImageReferenceType.CUSTOM_IMAGE.getName();
        }
        return ImageReferenceType.REFERENCE.getName();
    }

    public String getBuiltInImage() {
        return this.builtInImage;
    }

    public boolean getIsInstallGit() {
        return this.isInstallGit;
    }

    public boolean getIsInstallMaven() {
        return this.isInstallMaven;
    }

    public boolean getIsInstallDocker() {
        return this.isInstallDocker;
    }

    public String getImage() {
        return this.image;
    }

    public String getOsType() {
        return this.osType;
    }

    public boolean getPreInstallSsh() {
        return this.preInstallSsh;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getImagePublisher() {
        return this.imagePublisher;
    }

    public String getImageOffer() {
        return this.imageOffer;
    }

    public String getImageSku() {
        return this.imageSku;
    }

    public String getImageVersion() {
        return this.imageVersion;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StandardUsernamePasswordCredentials getVMCredentials() throws AzureCloudException {
        return AzureUtil.getCredentials(this.credentialsId);
    }

    public String getVirtualNetworkName() {
        return this.virtualNetworkName;
    }

    public void setVirtualNetworkName(String virtualNetworkName) {
        this.virtualNetworkName = virtualNetworkName;
    }

    public String getVirtualNetworkResourceGroupName() {
        return this.virtualNetworkResourceGroupName;
    }

    public String getSubnetName() {
        return this.subnetName;
    }

    public void setSubnetName(String subnetName) {
        this.subnetName = subnetName;
    }

    public boolean getUsePrivateIP() {
        return this.usePrivateIP;
    }

    public String getNsgName() {
        return this.nsgName;
    }

    public String getAgentWorkspace() {
        return this.agentWorkspace;
    }

    public int getRetentionTimeInMin() {
        return this.retentionTimeInMin;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public AzureVMCloud getAzureCloud() {
        return this.azureCloud;
    }

    public void setAzureCloud(AzureVMCloud cloud) {
        this.azureCloud = cloud;
        if (StringUtils.isBlank((String)this.storageAccountName)) {
            this.newStorageAccountName = this.storageAccountName = AzureVMAgentTemplate.generateUniqueStorageAccountName(this.azureCloud.getResourceGroupName(), this.templateName);
            this.storageAccountNameReferenceType = "new";
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplateDesc() {
        return this.templateDesc;
    }

    public int getNoOfParallelJobs() {
        return this.noOfParallelJobs;
    }

    public String getAgentLaunchMethod() {
        return this.agentLaunchMethod;
    }

    public ProvisionStrategy getTemplateProvisionStrategy() {
        return this.templateProvisionStrategy;
    }

    public void setTemplateProvisionStrategy(ProvisionStrategy templateProvisionStrategy) {
        this.templateProvisionStrategy = templateProvisionStrategy;
    }

    public boolean isTemplateDisabled() {
        return this.templateDisabled;
    }

    public boolean isTemplateVerified() {
        return this.templateVerified;
    }

    public void setTemplateVerified(boolean isValid) {
        this.templateVerified = isValid;
    }

    public String getTemplateStatusDetails() {
        return this.templateStatusDetails;
    }

    public void setTemplateStatusDetails(String templateStatusDetails) {
        this.templateStatusDetails = templateStatusDetails;
    }

    public String getResourceGroupName() {
        return this.getAzureCloud().getResourceGroupName();
    }

    public boolean getExecuteInitScriptAsRoot() {
        return this.executeInitScriptAsRoot;
    }

    public void setExecuteInitScriptAsRoot(boolean executeAsRoot) {
        this.executeInitScriptAsRoot = executeAsRoot;
    }

    public boolean getDoNotUseMachineIfInitFails() {
        return this.doNotUseMachineIfInitFails;
    }

    public boolean isEnableMSI() {
        return this.enableMSI;
    }

    public void setDoNotUseMachineIfInitFails(boolean doNotUseMachineIfInitFails) {
        this.doNotUseMachineIfInitFails = doNotUseMachineIfInitFails;
    }

    public AdvancedImage getAdvancedImageInside() {
        return ((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)new AdvancedImageBuilder().withCustomImage(this.getImage())).withCustomManagedImage(this.getImageId())).withReferenceImage(this.getImagePublisher(), this.getImageOffer(), this.getImageSku(), this.getImageVersion())).withNumberOfExecutors(String.valueOf(this.getNoOfParallelJobs()))).withOsType(this.getOsType())).withLaunchMethod(this.getAgentLaunchMethod())).withPreInstallSsh(this.getPreInstallSsh())).withInitScript(this.getInitScript())).withVirtualNetworkName(this.getVirtualNetworkName())).withVirtualNetworkResourceGroupName(this.getVirtualNetworkResourceGroupName())).withSubnetName(this.getSubnetName())).withUsePrivateIP(this.getUsePrivateIP())).withNetworkSecurityGroupName(this.getNsgName())).withJvmOptions(this.getJvmOptions())).withDisableTemplate(this.isTemplateDisabled())).withRunScriptAsRoot(this.getExecuteInitScriptAsRoot())).withDoNotUseMachineIfInitFails(this.getDoNotUseMachineIfInitFails())).withEnableMSI(this.isEnableMSI())).build();
    }

    public BuiltInImage getBuiltInImageInside() {
        return ((BuiltInImageBuilder)((BuiltInImageBuilder)((BuiltInImageBuilder)((BuiltInImageBuilder)new BuiltInImageBuilder().withBuiltInImageName(this.getBuiltInImage())).withInstallGit(this.getIsInstallGit())).withInstallDocker(this.getIsInstallDocker())).withInstallMaven(this.getIsInstallMaven())).build();
    }

    public Availability getAvailabilityInside() {
        return ((AvailabilityBuilder)new AvailabilityBuilder().withAvailabilitySet(this.getAvailabilitySet())).build();
    }

    public Descriptor<AzureVMAgentTemplate> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public Set<LabelAtom> getLabelDataSet() {
        return this.labelDataSet;
    }

    public AzureVMCloudBaseRetentionStrategy getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public AzureVMDeploymentInfo provisionAgents(TaskListener listener, int numberOfAgents) throws Exception {
        return this.getServiceDelegate().createDeployment(this, numberOfAgents);
    }

    private AzureVMManagementServiceDelegate getServiceDelegate() {
        return this.getAzureCloud().getServiceDelegate();
    }

    public void handleTemplateProvisioningFailure(String message, FailureStage failureStep) {
        this.templateProvisionStrategy.failure();
        this.setTemplateStatusDetails(message);
    }

    public List<String> verifyTemplate() throws Exception {
        return this.getServiceDelegate().verifyTemplate(this.templateName, this.labels, this.location, this.virtualMachineSize, this.storageAccountName, this.storageAccountType, this.noOfParallelJobs + "", this.imageTopLevelType, ImageReferenceType.get(this.imageReferenceType), this.builtInImage, this.image, this.osType, this.imageId, this.imagePublisher, this.imageOffer, this.imageSku, this.imageVersion, this.agentLaunchMethod, this.initScript, this.credentialsId, this.virtualNetworkName, this.virtualNetworkResourceGroupName, this.subnetName, this.retentionStrategy, this.jvmOptions, this.getResourceGroupName(), true, this.usePrivateIP, this.nsgName);
    }

    public void setVirtualMachineDetails(AzureVMAgent agent) throws Exception {
        this.getServiceDelegate().setVirtualMachineDetails(agent, this);
    }

    public static String generateUniqueStorageAccountName(String resourceGroupName, String templateName) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (null != templateName) {
                md.update(templateName.getBytes(StandardCharsets.UTF_8));
            }
            if (null != resourceGroupName) {
                md.update(resourceGroupName.getBytes(StandardCharsets.UTF_8));
            }
            String uid = DatatypeConverter.printBase64Binary((byte[])md.digest());
            uid = uid.substring(0, 22);
            uid = uid.toLowerCase();
            uid = uid.replaceAll("[^a-z0-9]", "a");
            return "jn" + uid;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.WARNING, "Could not generate UID from the resource group name. Will fallback on using the resource group name.", e);
            return "";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AzureVMAgentTemplate> {
        public String getDisplayName() {
            return "";
        }

        public List<Descriptor<RetentionStrategy<?>>> getAzureVMRetentionStrategy() {
            ArrayList list = new ArrayList();
            list.add(AzureVMCloudRetensionStrategy.DESCRIPTOR);
            list.add(AzureVMCloudPoolRetentionStrategy.DESCRIPTOR);
            list.add(AzureVMCloudOnceRetentionStrategy.DESCRIPTOR);
            return list;
        }

        public ListBoxModel doFillVirtualMachineSizeItems(@RelativePath(value="..") @QueryParameter String azureCredentialsId, @QueryParameter String location) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            List<String> vmSizes = AzureClientHolder.getDelegate(azureCredentialsId).getVMSizes(location);
            if (vmSizes != null) {
                for (String vmSize : vmSizes) {
                    model.add(vmSize);
                }
            }
            return model;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            return new StandardListBoxModel().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }

        public ListBoxModel doFillOsTypeItems() throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("Linux");
            model.add("Windows");
            return model;
        }

        public ListBoxModel doFillLocationItems(@RelativePath(value="..") @QueryParameter String azureCredentialsId) {
            ListBoxModel model = new ListBoxModel();
            TokenCredentialData token = AzureClientUtil.getToken(azureCredentialsId);
            if (token != null) {
                String envName = token.getAzureEnvironmentName();
                String managementEndpoint = token.getManagementEndpoint();
                Set<String> locations = AzureClientHolder.getDelegate(azureCredentialsId).getVirtualMachineLocations(managementEndpoint != null ? managementEndpoint : envName);
                if (locations != null) {
                    for (String location : locations) {
                        model.add(location);
                    }
                }
            }
            return model;
        }

        public String doFillAvailabilityTypeItems() {
            return null;
        }

        public ListBoxModel doFillAvailabilitySetItems(@RelativePath(value="../..") @QueryParameter String azureCredentialsId, @RelativePath(value="../..") @QueryParameter String resourceGroupReferenceType, @RelativePath(value="../..") @QueryParameter String newResourceGroupName, @RelativePath(value="../..") @QueryParameter String existingResourceGroupName, @RelativePath(value="..") @QueryParameter String location) {
            ListBoxModel model = new ListBoxModel();
            model.add("--- Select Availability Set in current resource group and location ---", "");
            if (StringUtils.isBlank((String)azureCredentialsId)) {
                return model;
            }
            resourceGroupReferenceType = null;
            try {
                Azure azureClient = AzureClientHolder.get(azureCredentialsId);
                String resourceGroupName = AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName);
                PagedList availabilitySets = azureClient.availabilitySets().listByResourceGroup(resourceGroupName);
                for (AvailabilitySet set : availabilitySets) {
                    String label = set.region().label();
                    if (!label.equals(location)) continue;
                    model.add(set.name());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot list availability set: ", e);
            }
            return model;
        }

        public ListBoxModel doFillStorageAccountTypeItems(@QueryParameter String virtualMachineSize) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("--- Select Storage Account Type ---", "");
            model.add(SkuName.STANDARD_LRS.toString());
            if (virtualMachineSize.matches(".*_[a-zA-Z]([0-9]+[Mm]?[Ss]|[Ss][0-9]+).*")) {
                model.add(SkuName.PREMIUM_LRS.toString());
            }
            return model;
        }

        public ListBoxModel doFillUsageModeItems() throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            for (Node.Mode m : Functions.getNodeModes()) {
                model.add(m.getDescription());
            }
            return model;
        }

        public ListBoxModel doFillAgentLaunchMethodItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("SSH");
            model.add("JNLP");
            return model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListBoxModel doFillExistingStorageAccountNameItems(@RelativePath(value="..") @QueryParameter String azureCredentialsId, @RelativePath(value="..") @QueryParameter String resourceGroupReferenceType, @RelativePath(value="..") @QueryParameter String newResourceGroupName, @RelativePath(value="..") @QueryParameter String existingResourceGroupName, @QueryParameter String storageAccountType) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            if (StringUtils.isBlank((String)azureCredentialsId)) {
                return model;
            }
            resourceGroupReferenceType = null;
            try {
                Azure azureClient = AzureClientHolder.get(azureCredentialsId);
                String resourceGroupName = AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName);
                PagedList storageAccountList = azureClient.storageAccounts().listByResourceGroup(resourceGroupName);
                for (StorageAccount storageAccount : storageAccountList) {
                    if (!storageAccount.sku().name().toString().equalsIgnoreCase(storageAccountType)) continue;
                    model.add(storageAccount.name());
                }
            }
            catch (NullPointerException azureClient) {}
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot list storage account: ", e);
            }
            finally {
                return model;
            }
        }

        public ListBoxModel doFillBuiltInImageItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Windows Server 2016");
            model.add("Ubuntu 16.04 LTS");
            return model;
        }

        public FormValidation doCheckInitScript(@QueryParameter String value, @QueryParameter String agentLaunchMethod) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warningWithMarkup((String)Messages.Azure_GC_InitScript_Warn_Msg());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckStorageAccountName(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok((String)Messages.SA_Blank_Create_New());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillDiskTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Managed Disk", "managed");
            model.add("Unmanaged Disk", "unmanaged");
            return model;
        }

        public String doFillImageReferenceTypeItems() {
            return null;
        }

        public FormValidation doAgentLaunchMethod(@QueryParameter String value) {
            if ("JNLP".equals(value)) {
                return FormValidation.warning((String)Messages.Azure_GC_LaunchMethod_Warn_Msg());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTemplateName(@QueryParameter String value, @QueryParameter boolean templateDisabled, @QueryParameter String osType) {
            ArrayList<FormValidation> errors = new ArrayList<FormValidation>();
            if (!AzureUtil.isValidTemplateName(value)) {
                errors.add(FormValidation.error((String)Messages.Azure_GC_Template_Name_Not_Valid()));
            }
            if (templateDisabled) {
                errors.add(FormValidation.warning((String)Messages.Azure_GC_TemplateStatus_Warn_Msg()));
            }
            if (errors.size() > 0) {
                return FormValidation.aggregate(errors);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNoOfParallelJobs(@QueryParameter String value) {
            if (StringUtils.isNotBlank((String)value)) {
                String result = AzureVMManagementServiceDelegate.verifyNoOfExecutors(value);
                if (result.equalsIgnoreCase("Success")) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)result);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAdminPassword(@QueryParameter String value) {
            if (StringUtils.isNotBlank((String)value)) {
                if (AzureUtil.isValidPassword(value)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)Messages.Azure_GC_Password_Err());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJvmOptions(@QueryParameter String value) {
            if (StringUtils.isNotBlank((String)value)) {
                if (AzureUtil.isValidJvmOption(value)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)Messages.Azure_GC_JVM_Option_Err());
            }
            return FormValidation.ok();
        }

        public FormValidation doVerifyConfiguration(@RelativePath(value="..") @QueryParameter String azureCredentialsId, @RelativePath(value="..") @QueryParameter String resourceGroupReferenceType, @RelativePath(value="..") @QueryParameter String newResourceGroupName, @RelativePath(value="..") @QueryParameter String existingResourceGroupName, @RelativePath(value="..") @QueryParameter String maxVirtualMachinesLimit, @RelativePath(value="..") @QueryParameter String deploymentTimeout, @QueryParameter String templateName, @QueryParameter String labels, @QueryParameter String location, @QueryParameter String virtualMachineSize, @QueryParameter String storageAccountNameReferenceType, @QueryParameter String newStorageAccountName, @QueryParameter String existingStorageAccountName, @QueryParameter String storageAccountType, @QueryParameter String noOfParallelJobs, @QueryParameter String imageTopLevelType, @QueryParameter String builtInImage, @RelativePath(value="imageReferenceTypeClass") @QueryParameter String image, @QueryParameter String osType, @RelativePath(value="imageReferenceTypeClass") @QueryParameter String imageId, @RelativePath(value="imageReferenceTypeClass") @QueryParameter String imagePublisher, @RelativePath(value="imageReferenceTypeClass") @QueryParameter String imageOffer, @RelativePath(value="imageReferenceTypeClass") @QueryParameter String imageSku, @RelativePath(value="imageReferenceTypeClass") @QueryParameter String imageVersion, @QueryParameter String agentLaunchMethod, @QueryParameter String initScript, @QueryParameter String credentialsId, @QueryParameter String virtualNetworkName, @QueryParameter String virtualNetworkResourceGroupName, @QueryParameter String subnetName, @QueryParameter boolean usePrivateIP, @QueryParameter String nsgName, @QueryParameter String jvmOptions, @QueryParameter String imageReferenceType) {
            ImageReferenceType referenceType = ImageReferenceType.get(imageReferenceType);
            String resourceGroupName = AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName);
            String storageAccountName = AzureVMAgentTemplate.getStorageAccountName(storageAccountNameReferenceType, newStorageAccountName, existingStorageAccountName);
            if (storageAccountName.trim().isEmpty()) {
                storageAccountName = AzureVMAgentTemplate.generateUniqueStorageAccountName(resourceGroupName, templateName);
            }
            LOGGER.log(Level.INFO, "Verify configuration:\n\t{0}{1}{2}{3}resourceGroupName: {4};\n\ttemplateName: {5};\n\tlabels: {6};\n\tlocation: {7};\n\tvirtualMachineSize: {8};\n\tstorageAccountName: {9};\n\tnoOfParallelJobs: {10};\n\timageTopLevelType: {11};\n\tbuiltInImage: {12};\n\timage: {13};\n\tosType: {14};\n\timageId: {15};\n\timagePublisher: {16};\n\timageOffer: {17};\n\timageSku: {18};\n\timageVersion: {19};\n\tagentLaunchMethod: {20};\n\tinitScript: {21};\n\tcredentialsId: {22};\n\tvirtualNetworkName: {23};\n\tvirtualNetworkResourceGroupName: {24};\n\tsubnetName: {25};\n\tprivateIP: {26};\n\tnsgName: {27};\n\tjvmOptions: {28};", new Object[]{"", "", "", "", resourceGroupName, templateName, labels, location, virtualMachineSize, storageAccountName, noOfParallelJobs, imageTopLevelType, builtInImage, image, osType, imageId, imagePublisher, imageOffer, imageSku, imageVersion, agentLaunchMethod, initScript, credentialsId, virtualNetworkName, virtualNetworkResourceGroupName, subnetName, usePrivateIP, nsgName, jvmOptions});
            String result = AzureClientHolder.getDelegate(azureCredentialsId).verifyConfiguration(resourceGroupName, maxVirtualMachinesLimit, deploymentTimeout);
            if (!result.equals("Success")) {
                return FormValidation.error((String)result);
            }
            List<String> errors = AzureClientHolder.getDelegate(azureCredentialsId).verifyTemplate(templateName, labels, location, virtualMachineSize, storageAccountName, storageAccountType, noOfParallelJobs, imageTopLevelType, referenceType, builtInImage, image, osType, imageId, imagePublisher, imageOffer, imageSku, imageVersion, agentLaunchMethod, initScript, credentialsId, virtualNetworkName, virtualNetworkResourceGroupName, subnetName, new AzureVMCloudRetensionStrategy(0), jvmOptions, resourceGroupName, false, usePrivateIP, nsgName);
            if (errors.size() > 0) {
                StringBuilder errorString = new StringBuilder(Messages.Azure_GC_Template_Error_List()).append("\n");
                for (int i = 0; i < errors.size(); ++i) {
                    errorString.append(i + 1).append(": ").append(errors.get(i)).append("\n");
                }
                return FormValidation.error((String)errorString.toString());
            }
            return FormValidation.ok((String)Messages.Azure_Template_Config_Success());
        }

        public String getDefaultNoOfExecutors() {
            return "1";
        }
    }

    public static class AvailabilityTypeClass {
        private String availabilitySet;

        @DataBoundConstructor
        public AvailabilityTypeClass(String availabilitySet) {
            this.availabilitySet = availabilitySet;
        }

        public String getAvailabilitySet() {
            return this.availabilitySet;
        }
    }

    public static class ImageReferenceTypeClass {
        private String image;
        private String imageId;
        private String imagePublisher;
        private String imageOffer;
        private String imageSku;
        private String imageVersion;

        @DataBoundConstructor
        public ImageReferenceTypeClass(String image, String imageId, String imagePublisher, String imageOffer, String imageSku, String imageVersion) {
            this.image = image;
            this.imageId = imageId;
            this.imagePublisher = imagePublisher;
            this.imageOffer = imageOffer;
            this.imageSku = imageSku;
            this.imageVersion = imageVersion;
        }

        public String getImage() {
            return this.image;
        }

        public String getImageId() {
            return this.imageId;
        }

        public String getImagePublisher() {
            return this.imagePublisher;
        }

        public String getImageOffer() {
            return this.imageOffer;
        }

        public String getImageSku() {
            return this.imageSku;
        }

        public String getImageVersion() {
            return this.imageVersion;
        }
    }
}

